/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.darksouls.common.entities.mobs.parents;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;

public abstract class DarkSoulsEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Integer> CURRENT_TIME = SynchedEntityData.m_135353_(DarkSoulsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FINAL_TIME = SynchedEntityData.m_135353_(DarkSoulsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIMATIONSTATE = SynchedEntityData.m_135353_(DarkSoulsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);

    public abstract boolean isDemon();

    public abstract boolean isAbyssal();

    public abstract boolean isBoss();

    public abstract int getPhysDefence();

    public abstract int getLightningDefence();

    public abstract int getFireDefence();

    public abstract int getDarkDefence();

    public abstract int getMagicDefence();

    public DarkSoulsEntity(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATIONSTATE);
    }

    public void setAnimationState(int anim) {
        this.f_19804_.m_135381_(ANIMATIONSTATE, (Object)anim);
    }

    public int getCurrentAnimationTime() {
        return (Integer)this.f_19804_.m_135370_(CURRENT_TIME);
    }

    public void setCurrentAnimationTime(int anim) {
        this.f_19804_.m_135381_(CURRENT_TIME, (Object)anim);
    }

    public int getFinalAnimationTime() {
        return (Integer)this.f_19804_.m_135370_(FINAL_TIME);
    }

    public void setFinalAnimationTime(int anim) {
        this.f_19804_.m_135381_(FINAL_TIME, (Object)anim);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATIONSTATE, (Object)0);
        this.f_19804_.m_135372_(CURRENT_TIME, (Object)0);
        this.f_19804_.m_135372_(FINAL_TIME, (Object)0);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setAnimationState(tag.m_128451_("AnimationId"));
        this.setCurrentAnimationTime(tag.m_128451_("CurrentAnimationAge"));
        this.setFinalAnimationTime(tag.m_128451_("FinalAnimationAge"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("AnimationId", this.getAnimationState());
        tag.m_128405_("CombatStateId", this.getCurrentAnimationTime());
        tag.m_128405_("EntityStateId", this.getFinalAnimationTime());
    }

    public void m_6457_(ServerPlayer p_184178_1_) {
        super.m_6457_(p_184178_1_);
        if (this.isBoss()) {
            this.bossEvent.m_6543_(p_184178_1_);
        }
    }

    public void m_6452_(ServerPlayer p_184203_1_) {
        super.m_6452_(p_184203_1_);
        this.bossEvent.m_6539_(p_184203_1_);
    }

    public void m_8119_() {
        float h = this.m_21223_();
        this.bossEvent.m_142711_(h / this.m_21233_());
        super.m_8119_();
    }

    public abstract String getIdleAnimation();

    public void m_6043_() {
        if (this.isBoss()) {
            if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
                this.m_146870_();
            } else {
                this.f_20891_ = 0;
            }
        } else {
            super.m_6043_();
        }
    }
}

