/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.raids;

import com.calculusmaster.difficultraids.entity.DifficultRaidsEntityTypes;
import com.calculusmaster.difficultraids.entity.entities.core.AbstractIllagerVariant;
import com.calculusmaster.difficultraids.entity.entities.elite.XydraxEliteEntity;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.RegistryObject;

public class RaidWaves {
    public static final Map<RaidDifficulty, WaveHolder> WAVES = new LinkedHashMap<RaidDifficulty, WaveHolder>();
    private static final Random random = new Random();
    public static final String VINDICATOR = "VINDICATOR";
    public static final String EVOKER = "EVOKER";
    public static final String PILLAGER = "PILLAGER";
    public static final String WITCH = "WITCH";
    public static final String RAVAGER = "RAVAGER";
    public static final String ILLUSIONER = "ILLUSIONER";
    public static final String WARRIOR = "WARRIOR_ILLAGER";
    public static final String DART = "DART_ILLAGER";
    public static final String CONDUCTOR = "ELECTRO_ILLAGER";
    public static final String NECROMANCER = "NECROMANCER_ILLAGER";
    public static final String SHAMAN = "SHAMAN_ILLAGER";
    public static final String TANK = "TANK_ILLAGER";
    public static final String ASSASSIN = "ASSASSIN_ILLAGER";
    public static final String FROSTMAGE = "FROST_ILLAGER";
    public static final String HUNTER = "HUNTERILLAGER";
    public static final String ENCHANTER = "ENCHANTER";

    public static void load() {
    }

    private static void registerDefaultHero() {
        WaveHolder holder = new WaveHolder();
        holder.addWaveSet(Wave.create(P.of(PILLAGER, 4), P.of(VINDICATOR, 2), P.of(WARRIOR, 2)), Wave.create(P.of(PILLAGER, 3), P.of(VINDICATOR, 1), P.of(WARRIOR, 1), P.of(HUNTER, 1)), Wave.create(P.of(PILLAGER, 5), P.of(VINDICATOR, 1), P.of(TANK, 1)), Wave.create(P.of(PILLAGER, 5), P.of(WARRIOR, 1), P.of(TANK, 1)));
        holder.addWaveSet(Wave.create(P.of(PILLAGER, 4), P.of(VINDICATOR, 3), P.of(WARRIOR, 2), P.of(WITCH, 1)), Wave.create(P.of(PILLAGER, 4), P.of(VINDICATOR, 2), P.of(WARRIOR, 3), P.of(WITCH, 1)), Wave.create(P.of(PILLAGER, 6), P.of(TANK, 2), P.of(WITCH, 1)), Wave.create(P.of(PILLAGER, 4), P.of(TANK, 1), P.of(HUNTER, 2)));
        holder.addWaveSet(Wave.create(P.of(PILLAGER, 4), P.of(VINDICATOR, 3), P.of(WARRIOR, 3), P.of(WITCH, 2)), Wave.create(P.of(PILLAGER, 4), P.of(VINDICATOR, 3), P.of(WARRIOR, 3), P.of(EVOKER, 1), P.of(TANK, 1)), Wave.create(P.of(PILLAGER, 4), P.of(VINDICATOR, 1), P.of(WARRIOR, 1), P.of(TANK, 4), P.of(EVOKER, 1)), Wave.create(P.of(PILLAGER, 3), P.of(VINDICATOR, 3), P.of(WARRIOR, 3), P.of(WITCH, 2), P.of(HUNTER, 1)));
        holder.addWaveSet(List.of(P.of(TANK, 1)), Wave.create(P.of(PILLAGER, 5), P.of(VINDICATOR, 3), P.of(WARRIOR, 3), P.of(WITCH, 2), P.of(EVOKER, 1), P.of(HUNTER, 1)), Wave.create(P.of(PILLAGER, 5), P.of(VINDICATOR, 3), P.of(WARRIOR, 3), P.of(WITCH, 2), P.of(RAVAGER, 1), P.of(HUNTER, 1)), Wave.create(P.of(PILLAGER, 2), P.of(VINDICATOR, 5), P.of(WARRIOR, 3), P.of(WITCH, 2), P.of(HUNTER, 1)), Wave.create(P.of(PILLAGER, 2), P.of(VINDICATOR, 3), P.of(WARRIOR, 5), P.of(WITCH, 2), P.of(HUNTER, 1)), Wave.create(P.of(PILLAGER, 1), P.of(VINDICATOR, 2), P.of(WARRIOR, 2), P.of(WITCH, 2), P.of(HUNTER, 5)), Wave.create(P.of(RAVAGER, 2), P.of(HUNTER, 2)));
        holder.addWaveSet(List.of(P.of(TANK, 2), P.of(VINDICATOR, 4), P.of(WARRIOR, 4), P.of(WITCH, 3)), Wave.create(P.of(PILLAGER, 7), P.of(HUNTER, 5), P.of(EVOKER, 3)), Wave.create(P.of(PILLAGER, 6), P.of(HUNTER, 4), P.of(EVOKER, 1), P.of(RAVAGER, 1)), Wave.create(P.of(PILLAGER, 7), P.of(HUNTER, 4), P.of(EVOKER, 3), P.of(ILLUSIONER, 1)), Wave.create(P.of(PILLAGER, 6), P.of(HUNTER, 4), P.of(EVOKER, 1), P.of(RAVAGER, 1), P.of(ILLUSIONER, 1)));
        WAVES.put(RaidDifficulty.HERO, holder);
    }

    private static void registerDefaultLegend() {
        WaveHolder holder = new WaveHolder();
        WAVES.put(RaidDifficulty.LEGEND, holder);
    }

    private static void registerDefaultMaster() {
        WaveHolder holder = new WaveHolder();
        WAVES.put(RaidDifficulty.MASTER, holder);
    }

    private static void registerDefaultApocalypse() {
        WaveHolder holder = new WaveHolder();
        WAVES.put(RaidDifficulty.GRANDMASTER, holder);
    }

    public static class WaveHolder {
        private final List<WaveOptions> waveData = new ArrayList<WaveOptions>(List.of(WaveOptions.EMPTY));

        WaveHolder() {
        }

        void addWaveSet(Wave ... waves) {
            this.waveData.add(WaveOptions.withWaves(waves));
        }

        void addWaveSet(List<P> fixed, Wave ... waves) {
            for (Wave w : waves) {
                w.add(fixed);
            }
            this.addWaveSet(waves);
        }

        void setLatestAsEliteWithTier(int tier) {
            this.waveData.get(this.waveData.size() - 1).setEliteTier(tier);
        }
    }

    public static class Wave {
        private final Map<String, Integer> raiders = new HashMap<String, Integer>();

        Wave() {
        }

        static Wave create(P ... raiderPairs) {
            Wave wave = new Wave();
            for (P raiderPair : raiderPairs) {
                wave.raiders.put(raiderPair.type, raiderPair.count);
            }
            return wave;
        }

        void add(List<P> pairs) {
            pairs.forEach(p -> this.raiders.put(p.type, p.count));
        }

        void remove(String raiderType) {
            this.raiders.remove(raiderType);
        }
    }

    private record P(String type, int count) {
        static P of(String type, int count) {
            return new P(type, count);
        }
    }

    public static class WaveOptions {
        private static final WaveOptions EMPTY = new WaveOptions();
        private final List<Wave> waves = new ArrayList<Wave>();
        private int eliteTier = 0;

        WaveOptions() {
        }

        static WaveOptions withWaves(Wave ... waves) {
            WaveOptions waveOptions = new WaveOptions();
            waveOptions.waves.addAll(List.of(waves));
            return waveOptions;
        }

        public Wave pickRandom() {
            ArrayList<Wave> pool = new ArrayList<Wave>(List.copyOf(this.waves));
            if (DifficultRaidsUtil.isHunterIllagerLoaded()) {
                pool.removeIf(w -> w.raiders.containsKey(RaidWaves.HUNTER));
            }
            if (DifficultRaidsUtil.isEnchantWithMobLoaded()) {
                pool.removeIf(w -> w.raiders.containsKey(RaidWaves.ENCHANTER));
            }
            return (Wave)pool.get(random.nextInt(pool.size()));
        }

        void setEliteTier(int tier) {
            this.eliteTier = tier;
        }

        public EntityType<? extends AbstractIllagerVariant> pickElite() {
            List<RegistryObject<EntityType<XydraxEliteEntity>>> pool;
            List<Object> list = this.eliteTier == 1 ? List.of(DifficultRaidsEntityTypes.NUAOS_ELITE, DifficultRaidsEntityTypes.XYDRAX_ELITE) : (pool = this.eliteTier == 2 ? List.of(DifficultRaidsEntityTypes.MODUR_ELITE, DifficultRaidsEntityTypes.VOLDON_ELITE) : List.of());
            if (pool.isEmpty()) {
                return null;
            }
            return (EntityType)pool.get(random.nextInt(pool.size())).get();
        }
    }
}

