/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.mixins;

import com.calculusmaster.difficultraids.entity.DifficultRaidsEntityTypes;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={AbstractIllager.class})
public abstract class AbstractIllagerMixin
extends Raider {
    protected AbstractIllagerMixin(EntityType<? extends Raider> p_37839_, Level p_37840_) {
        super(p_37839_, p_37840_);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        RaidDifficulty raidDifficulty;
        boolean inRaid = this.m_37885_() != null;
        Random random = new Random();
        if (inRaid && !(raidDifficulty = RaidDifficulty.get(this.m_37885_().m_37773_())).isDefault() && mobSpawnType.equals((Object)MobSpawnType.EVENT) && !this.m_6095_().equals(DifficultRaidsEntityTypes.TANK_ILLAGER.get())) {
            List<ArmorMaterials> tiers = raidDifficulty.config().validArmorTiers();
            int armorChance = raidDifficulty.config().armorChance();
            int protectionChance = raidDifficulty.config().protectionChance();
            int maxArmorPieces = raidDifficulty.config().maxArmorPieces();
            if (!tiers.isEmpty() && armorChance > 0 && maxArmorPieces > 0) {
                int armorCount = 0;
                for (EquipmentSlot slot : List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET)) {
                    if (armorCount >= maxArmorPieces || tiers.isEmpty() || random.nextInt(100) >= armorChance) continue;
                    ArmorMaterials mat = tiers.get(random.nextInt(tiers.size()));
                    ItemStack armor = DifficultRaidsUtil.getArmorPiece(slot, mat);
                    if (!armor.m_41720_().equals(Items.f_41852_)) {
                        Map enchants = EnchantmentHelper.m_44831_((ItemStack)armor);
                        if (random.nextInt(100) < protectionChance) {
                            Tuple<Integer, Integer> minMaxLevel = raidDifficulty.config().protectionLevel();
                            if ((Integer)minMaxLevel.m_14419_() < (Integer)minMaxLevel.m_14418_()) {
                                minMaxLevel.m_145023_((Object)1);
                                minMaxLevel.m_145025_((Object)1);
                                LogUtils.getLogger().warn("Invalid config option for Abstract Illager Protection Level! Minimum is greater than the maximum! Defaulting to a Protection Level of 1.");
                            }
                            enchants.put(Enchantments.f_44965_, ((Integer)minMaxLevel.m_14418_()).equals(minMaxLevel.m_14419_()) ? ((Integer)minMaxLevel.m_14418_()).intValue() : random.nextInt((Integer)minMaxLevel.m_14418_(), (Integer)minMaxLevel.m_14419_() + 1));
                        }
                        enchants.put(Enchantments.f_44963_, 1);
                        EnchantmentHelper.m_44865_((Map)enchants, (ItemStack)armor);
                        this.m_8061_(slot, armor);
                    }
                    ++armorCount;
                }
            }
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, tag);
    }
}

