/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.raider;

import com.calculusmaster.difficultraids.entity.entities.core.AbstractEvokerVariant;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.entities.Guard;

public class NecromancerIllagerEntity
extends AbstractEvokerVariant {
    private List<Monster> activeHorde = new ArrayList<Monster>();
    private int hordeLifetimeTicks = 0;
    private List<Monster> activeMinions = new ArrayList<Monster>();

    public NecromancerIllagerEntity(EntityType<? extends AbstractEvokerVariant> p_33724_, Level p_33725_) {
        super(p_33724_, p_33725_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 30.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new NecromancerCastSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new NecromancerSummonMinionsSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new NecromancerBuryTargetGoal());
        this.f_21345_.m_25352_(5, (Goal)new NecromancerSummonHordeSpellGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.3));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        if (DifficultRaidsUtil.isGuardVillagersLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guard.class, 8.0f, 0.7, 1.0));
        }
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    @Override
    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.isCastingSpell()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        List<Integer> hordeIDs = this.activeHorde.stream().filter(LivingEntity::m_6084_).map(Entity::m_142049_).toList();
        pCompound.m_128408_("ActiveHorde", hordeIDs);
        pCompound.m_128405_("ActiveHordeLifetimeTicks", this.hordeLifetimeTicks);
        List<Integer> minionIDs = this.activeMinions.stream().filter(LivingEntity::m_6084_).map(Entity::m_142049_).toList();
        pCompound.m_128408_("ActiveMinions", minionIDs);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        int[] minionIDs;
        int[] hordeIDs;
        super.m_7378_(pCompound);
        for (int ID : hordeIDs = pCompound.m_128465_("ActiveHorde")) {
            Monster monster;
            Entity entity = this.f_19853_.m_6815_(ID);
            if (!(entity instanceof Monster) || !(monster = (Monster)entity).m_6084_()) continue;
            this.activeHorde.add(monster);
        }
        this.hordeLifetimeTicks = pCompound.m_128451_("ActiveHordeLifetimeTicks");
        for (int ID : minionIDs = pCompound.m_128465_("ActiveMinions")) {
            Monster monster;
            Entity entity = this.f_19853_.m_6815_(ID);
            if (!(entity instanceof Monster) || !(monster = (Monster)entity).m_6084_()) continue;
            this.activeMinions.add(monster);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7639_() instanceof LivingEntity && !this.activeMinions.isEmpty() && pAmount > 1.0f && this.f_19796_.nextFloat() < 0.33f) {
            float deflectedDamage = pAmount * 0.4f;
            Monster target = this.activeMinions.get(this.f_19796_.nextInt(this.activeMinions.size()));
            if (target.m_21223_() > deflectedDamage) {
                target.m_6469_(pSource, deflectedDamage);
                pAmount -= deflectedDamage;
                this.m_5496_(SoundEvents.f_11986_, 1.5f, 0.9f);
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        this.activeHorde.forEach(m -> m.m_6469_(DamageSource.f_19313_, m.m_21223_() + 1.0f));
        this.activeMinions.forEach(m -> m.m_6469_(DamageSource.f_19313_, m.m_21223_() + 1.0f));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.activeHorde.isEmpty()) {
            this.activeHorde.removeIf(LivingEntity::m_21224_);
            if (this.activeHorde.isEmpty()) {
                this.hordeLifetimeTicks = 0;
            }
        }
        if (!this.activeMinions.isEmpty()) {
            this.activeMinions.removeIf(LivingEntity::m_21224_);
        }
        if (this.hordeLifetimeTicks > 0) {
            --this.hordeLifetimeTicks;
            if (this.hordeLifetimeTicks == 0) {
                this.activeHorde.forEach(m -> m.m_6469_(DamageSource.f_19313_, m.m_21223_() + 1.0f));
                this.activeHorde.clear();
            }
        }
        if (!this.activeMinions.isEmpty() && this.m_5448_() != null) {
            for (Monster minion : this.activeMinions) {
                if (minion.m_5448_() != null) continue;
                minion.m_6710_(this.m_5448_());
            }
        }
    }

    private class NecromancerCastSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerCastSpellGoal {
        private NecromancerCastSpellGoal() {
        }

        @Override
        public void m_8037_() {
            if (NecromancerIllagerEntity.this.m_5448_() != null) {
                NecromancerIllagerEntity.this.m_21563_().m_24960_((Entity)NecromancerIllagerEntity.this.m_5448_(), (float)NecromancerIllagerEntity.this.m_8085_(), (float)NecromancerIllagerEntity.this.m_8132_());
            }
        }
    }

    private class NecromancerSummonMinionsSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private NecromancerSummonMinionsSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = NecromancerIllagerEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)NecromancerIllagerEntity.this.m_183503_();
            boolean raid = NecromancerIllagerEntity.this.isInRaid();
            if (target != null) {
                ArrayList<EntityType> minionPool;
                Random random = new Random();
                int summons = switch (level.m_46791_()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Difficulty.PEACEFUL -> 0;
                    case Difficulty.EASY -> 2;
                    case Difficulty.NORMAL -> 3;
                    case Difficulty.HARD -> 4;
                };
                switch (level.m_46791_()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case PEACEFUL: {
                        ArrayList<EntityType> arrayList = new ArrayList<EntityType>();
                        break;
                    }
                    case EASY: {
                        ArrayList<EntityType> arrayList = new ArrayList<EntityType>(List.of(EntityType.f_20501_));
                        break;
                    }
                    case NORMAL: {
                        ArrayList<EntityType> arrayList = new ArrayList<EntityType>(List.of(EntityType.f_20501_, EntityType.f_20524_));
                        break;
                    }
                    case HARD: {
                        ArrayList<EntityType> arrayList = minionPool = new ArrayList<EntityType>(List.of(EntityType.f_20501_, EntityType.f_20524_, EntityType.f_20458_, EntityType.f_20481_));
                    }
                }
                if (raid) {
                    RaidDifficulty raidDifficulty = NecromancerIllagerEntity.this.getRaidDifficulty();
                    summons = raidDifficulty.config().necromancer().minionSummonCount();
                    if (level.m_46791_().equals((Object)Difficulty.EASY)) {
                        --summons;
                    } else if (level.m_46791_().equals((Object)Difficulty.HARD)) {
                        ++summons;
                    }
                    switch (raidDifficulty) {
                        case HERO: {
                            minionPool.add(EntityType.f_20562_);
                            break;
                        }
                        case LEGEND: {
                            minionPool.addAll(List.of(EntityType.f_20562_, EntityType.f_20497_));
                            break;
                        }
                        case MASTER: {
                            minionPool.addAll(List.of(EntityType.f_20562_, EntityType.f_20497_, EntityType.f_20530_));
                        }
                    }
                }
                for (int i = 0; i < summons; ++i) {
                    EntityType type = (EntityType)minionPool.get(random.nextInt(minionPool.size()));
                    Monster minion = (Monster)type.m_20615_((Level)level);
                    if (minion == null) continue;
                    BlockPos summonPos = target.m_142538_().m_142082_(-4 + random.nextInt(9), 0, -4 + random.nextInt(9));
                    List<Item> armor = switch (level.m_46791_()) {
                        default -> throw new IncompatibleClassChangeError();
                        case Difficulty.PEACEFUL -> List.of();
                        case Difficulty.EASY -> List.of(Items.f_42464_, Items.f_42465_, Items.f_42466_, Items.f_42467_);
                        case Difficulty.NORMAL -> List.of(Items.f_42468_, Items.f_42469_, Items.f_42470_, Items.f_42471_);
                        case Difficulty.HARD -> List.of(Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_);
                    };
                    int protectionLevel = 0;
                    if (raid) {
                        protectionLevel = NecromancerIllagerEntity.this.getRaidDifficulty().config().necromancer().minionProtectionLevel();
                    }
                    List<EquipmentSlot> slots = List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
                    for (Item item : armor) {
                        ItemStack armorStack = new ItemStack((ItemLike)item);
                        if (protectionLevel != 0) {
                            armorStack.m_41663_(Enchantments.f_44965_, protectionLevel == 1 ? 1 : random.nextInt(1, protectionLevel));
                        }
                        minion.m_8061_(slots.get(armor.indexOf(item)), armorStack);
                    }
                    minion.m_20035_(summonPos, 0.0f, 0.0f);
                    minion.m_6710_(target);
                    minion.m_21563_().m_148051_((Entity)target);
                    minion.f_21346_.m_148096_();
                    minion.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)minion, Player.class, true));
                    minion.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)minion, AbstractVillager.class, true));
                    minion.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)minion, IronGolem.class, true));
                    if (DifficultRaidsUtil.isGuardVillagersLoaded()) {
                        minion.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)minion, Guard.class, true));
                    }
                    level.m_7967_((Entity)minion);
                    NecromancerIllagerEntity.this.activeMinions.add(minion);
                }
            }
        }

        @Override
        public boolean m_8036_() {
            int minionThreshold = switch (NecromancerIllagerEntity.this.m_183503_().m_46791_()) {
                default -> throw new IncompatibleClassChangeError();
                case Difficulty.PEACEFUL -> 0;
                case Difficulty.EASY -> 1;
                case Difficulty.NORMAL, Difficulty.HARD -> 2;
            };
            return super.m_8036_() && NecromancerIllagerEntity.this.activeMinions.size() <= minionThreshold && NecromancerIllagerEntity.this.hordeLifetimeTicks < 40;
        }

        @Override
        protected int getCastingTime() {
            return 160;
        }

        @Override
        protected int getCastingInterval() {
            return 600;
        }

        @Override
        protected int getCastWarmupTime() {
            return 30;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.NECROMANCER_SUMMON_MINIONS;
        }
    }

    private class NecromancerBuryTargetGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private NecromancerBuryTargetGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = NecromancerIllagerEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)NecromancerIllagerEntity.this.m_183503_();
            boolean raid = NecromancerIllagerEntity.this.isInRaid();
            Random random = new Random();
            if (target != null) {
                int fullBuryChance;
                if (raid) {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 1));
                }
                target.m_5496_(SoundEvents.f_11816_, 5.0f, 0.75f);
                int buryDistance = 1;
                switch (level.m_46791_()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case PEACEFUL: {
                        int n = 0;
                        break;
                    }
                    case EASY: {
                        int n = 20;
                        break;
                    }
                    case NORMAL: {
                        int n = 35;
                        break;
                    }
                    case HARD: {
                        int n = fullBuryChance = 50;
                    }
                }
                buryDistance = random.nextInt(100) < fullBuryChance ? 1 + Mth.m_14167_((float)target.m_20206_()) * (target.m_20096_() ? 1 : 2) : (buryDistance *= target.m_20096_() ? 1 : 2);
                target.m_6027_((double)target.m_146903_(), (double)(target.m_146904_() - buryDistance), (double)target.m_146907_());
                if (!level.m_8055_(target.m_146901_()).m_60795_() && target instanceof AbstractVillager) {
                    AbstractVillager villager = (AbstractVillager)target;
                    villager.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 1));
                }
            }
        }

        @Override
        public boolean m_8036_() {
            Level level = NecromancerIllagerEntity.this.m_183503_();
            LivingEntity target = NecromancerIllagerEntity.this.m_5448_();
            return super.m_8036_() && level.m_8055_(target.m_146901_()).m_60795_() && Math.pow(NecromancerIllagerEntity.this.m_142538_().m_123331_((Vec3i)target.m_142538_()), 0.5) < 4.0;
        }

        @Override
        protected int getCastingTime() {
            return 30;
        }

        @Override
        protected int getCastingInterval() {
            return NecromancerIllagerEntity.this.m_21223_() < NecromancerIllagerEntity.this.m_21233_() / 5.0f ? 100 : 600;
        }

        @Override
        protected int getCastWarmupTime() {
            return 20;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11865_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.NECROMANCER_BURY_TARGET;
        }
    }

    private class NecromancerSummonHordeSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private NecromancerSummonHordeSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = NecromancerIllagerEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)NecromancerIllagerEntity.this.m_183503_();
            boolean raid = NecromancerIllagerEntity.this.isInRaid();
            if (target != null) {
                int n;
                int size;
                Random random = new Random();
                if (raid) {
                    RaidDifficulty raidDifficulty = NecromancerIllagerEntity.this.getRaidDifficulty();
                    int n2 = raidDifficulty.config().necromancer().hordeSize();
                    size = n2 + (switch (level.m_46791_()) {
                        default -> throw new IncompatibleClassChangeError();
                        case Difficulty.PEACEFUL -> -raidDifficulty.config().necromancer().hordeSize();
                        case Difficulty.EASY -> -5;
                        case Difficulty.NORMAL -> 0;
                        case Difficulty.HARD -> 5;
                    });
                } else {
                    size = switch (level.m_46791_()) {
                        default -> throw new IncompatibleClassChangeError();
                        case Difficulty.PEACEFUL -> 0;
                        case Difficulty.EASY -> 5;
                        case Difficulty.NORMAL -> 10;
                        case Difficulty.HARD -> 18;
                    };
                }
                NecromancerIllagerEntity.this.m_5496_(SoundEvents.f_11900_, 10.0f, 1.0f);
                BlockPos currentPos = NecromancerIllagerEntity.this.m_142538_();
                for (int i = 0; i < size; ++i) {
                    Skeleton hordeMember = (Skeleton)EntityType.f_20524_.m_20615_((Level)level);
                    hordeMember.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 500, 3));
                    hordeMember.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 500, 1));
                    hordeMember.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42407_));
                    hordeMember.m_6710_(target);
                    hordeMember.m_21563_().m_148051_((Entity)target);
                    hordeMember.f_21346_.m_148096_();
                    hordeMember.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)hordeMember, Player.class, true));
                    hordeMember.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)hordeMember, AbstractVillager.class, true));
                    hordeMember.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)hordeMember, IronGolem.class, true));
                    if (DifficultRaidsUtil.isGuardVillagersLoaded()) {
                        hordeMember.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)hordeMember, Guard.class, true));
                    }
                    BlockPos summonPos = currentPos.m_142082_(-10 + random.nextInt(21), 0, -10 + random.nextInt(21));
                    hordeMember.m_20035_(summonPos, 0.0f, 0.0f);
                    level.m_7967_((Entity)hordeMember);
                    NecromancerIllagerEntity.this.activeHorde.add((Monster)hordeMember);
                }
                if (raid) {
                    n = NecromancerIllagerEntity.this.getRaidDifficulty().config().necromancer().hordeLifetime();
                } else {
                    switch (level.m_46791_()) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case PEACEFUL: {
                            n = 1;
                            break;
                        }
                        case EASY: {
                            n = 300;
                            break;
                        }
                        case NORMAL: {
                            n = 600;
                            break;
                        }
                        case HARD: {
                            n = 900;
                        }
                    }
                }
                NecromancerIllagerEntity.this.hordeLifetimeTicks = n;
            }
        }

        @Override
        public boolean m_8036_() {
            int minionThreshold = switch (NecromancerIllagerEntity.this.m_183503_().m_46791_()) {
                default -> throw new IncompatibleClassChangeError();
                case Difficulty.PEACEFUL -> 0;
                case Difficulty.EASY -> 1;
                case Difficulty.NORMAL -> 2;
                case Difficulty.HARD -> 3;
            };
            return super.m_8036_() && NecromancerIllagerEntity.this.activeMinions.size() <= minionThreshold && NecromancerIllagerEntity.this.activeHorde.isEmpty();
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        protected int getCastingInterval() {
            return 700;
        }

        @Override
        protected int getCastWarmupTime() {
            return 20;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.NECROMANCER_SUMMON_HORDE;
        }
    }
}

