/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.raider;

import com.calculusmaster.difficultraids.entity.DifficultRaidsEntityTypes;
import com.calculusmaster.difficultraids.entity.entities.component.FrostSnowballEntity;
import com.calculusmaster.difficultraids.entity.entities.core.AbstractEvokerVariant;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.entities.Guard;

public class FrostIllagerEntity
extends AbstractEvokerVariant {
    private int barrageTicks = 0;

    public FrostIllagerEntity(EntityType<? extends AbstractEvokerVariant> p_33724_, Level p_33725_) {
        super(p_33724_, p_33725_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 30.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FrostIllagerCastSpell());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FrostIllagerFreezeSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new FrostIllagerBarrageSpellGoal());
        this.f_21345_.m_25352_(5, (Goal)new FrostIllagerSnowballBlastSpellGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        if (DifficultRaidsUtil.isGuardVillagersLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guard.class, 8.0f, 0.7, 1.0));
        }
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_19360_()) {
            pAmount *= 2.0f;
        }
        return super.m_6469_(pSource, pAmount);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("SnowballBarrageTicks", this.barrageTicks);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.barrageTicks = pCompound.m_128451_("SnowballBarrageTicks");
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        AABB checkRadius = new AABB(this.m_142538_()).m_82400_(6.0);
        List nearbyPlayers = this.f_19853_.m_6443_(Player.class, checkRadius, p -> !p.m_21023_(MobEffects.f_19597_) && !p.m_7500_() && !p.m_5833_());
        List nearbyVillagers = this.f_19853_.m_6443_(AbstractVillager.class, checkRadius, v -> !v.m_21023_(MobEffects.f_19597_));
        List nearbyGolems = this.f_19853_.m_6443_(IronGolem.class, checkRadius, g -> !g.m_21023_(MobEffects.f_19597_));
        Supplier<MobEffectInstance> slowness = () -> new MobEffectInstance(MobEffects.f_19597_, 20, 3);
        nearbyPlayers.forEach(p -> p.m_7292_((MobEffectInstance)slowness.get()));
        nearbyVillagers.forEach(v -> v.m_7292_((MobEffectInstance)slowness.get()));
        nearbyGolems.forEach(g -> g.m_7292_((MobEffectInstance)slowness.get()));
        if (DifficultRaidsUtil.isGuardVillagersLoaded()) {
            List nearbyGuards = this.f_19853_.m_6443_(Guard.class, checkRadius, g -> !g.m_21023_(MobEffects.f_19597_));
            nearbyGuards.forEach(g -> g.m_7292_((MobEffectInstance)slowness.get()));
        }
        if (this.barrageTicks > 0) {
            --this.barrageTicks;
            LivingEntity target = this.m_5448_();
            if (target != null) {
                int size = this.f_19796_.nextInt(15, 31);
                for (int i = 0; i < size; ++i) {
                    FrostSnowballEntity snowball = (FrostSnowballEntity)((EntityType)DifficultRaidsEntityTypes.FROST_SNOWBALL.get()).m_20615_(this.f_19853_);
                    snowball.m_5602_((Entity)this);
                    snowball.m_6034_(this.m_146901_().m_123341_(), (double)this.m_146901_().m_123342_() - 0.2, this.m_146901_().m_123343_());
                    snowball.setDamage(switch (this.f_19853_.m_46791_()) {
                        default -> throw new IncompatibleClassChangeError();
                        case Difficulty.PEACEFUL -> 0.0f;
                        case Difficulty.EASY -> 1.8f;
                        case Difficulty.NORMAL -> 2.4f;
                        case Difficulty.HARD -> 2.9f;
                    });
                    if (this.f_19796_.nextInt(100) < 40) {
                        snowball.m_6842_(true);
                    }
                    double targetY = target.m_20188_() - 1.1;
                    double targetX = target.m_20185_() - this.m_20185_();
                    double targetSnowballY = targetY - snowball.m_20186_();
                    double targetZ = target.m_20189_() - this.m_20189_();
                    double distanceY = Math.sqrt(targetX * targetX + targetZ * targetZ) * (double)0.2f;
                    snowball.m_6686_(targetX, targetSnowballY + distanceY, targetZ, 1.6f, 14.0f);
                    this.f_19853_.m_7967_((Entity)snowball);
                }
                this.m_5496_(SoundEvents.f_12479_, 1.0f, 0.4f / (this.f_19796_.nextFloat() * 0.4f + 0.8f));
                if (target.m_21224_()) {
                    this.barrageTicks = 0;
                }
            } else {
                this.barrageTicks = 0;
            }
        }
    }

    private class FrostIllagerCastSpell
    extends AbstractEvokerVariant.SpellcastingIllagerCastSpellGoal {
        private FrostIllagerCastSpell() {
        }

        @Override
        public void m_8037_() {
            if (FrostIllagerEntity.this.m_5448_() != null) {
                FrostIllagerEntity.this.m_21563_().m_24960_((Entity)FrostIllagerEntity.this.m_5448_(), (float)FrostIllagerEntity.this.m_8085_(), (float)FrostIllagerEntity.this.m_8132_());
            }
        }
    }

    private class FrostIllagerFreezeSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private FrostIllagerFreezeSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            boolean raid;
            LivingEntity target = FrostIllagerEntity.this.m_5448_();
            ServerLevel level = (ServerLevel)FrostIllagerEntity.this.m_183503_();
            boolean bl = raid = FrostIllagerEntity.this.m_37885_() != null;
            if (target != null) {
                int duration;
                if (raid) {
                    v1 = FrostIllagerEntity.this.getRaidDifficulty().config().frost().freezeDuration();
                } else {
                    switch (level.m_46791_()) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case PEACEFUL: {
                            v1 = 0;
                            break;
                        }
                        case EASY: {
                            v1 = 60;
                            break;
                        }
                        case NORMAL: {
                            v1 = 100;
                            break;
                        }
                        case HARD: {
                            v1 = duration = 140;
                        }
                    }
                }
                if (target.m_142079_()) {
                    target.m_146917_(target.m_146888_() + duration);
                }
            }
        }

        @Override
        protected int getCastingTime() {
            return 50;
        }

        @Override
        protected int getCastingInterval() {
            return 430;
        }

        @Override
        protected int getCastWarmupTime() {
            return 30;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11862_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.FROST_FREEZE;
        }
    }

    private class FrostIllagerBarrageSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private FrostIllagerBarrageSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            int n;
            if (FrostIllagerEntity.this.isInRaid()) {
                n = FrostIllagerEntity.this.getRaidDifficulty().config().frost().barrageDuration();
            } else {
                switch (FrostIllagerEntity.this.f_19853_.m_46791_()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case PEACEFUL: {
                        n = 0;
                        break;
                    }
                    case EASY: {
                        n = 40;
                        break;
                    }
                    case NORMAL: {
                        n = 100;
                        break;
                    }
                    case HARD: {
                        n = 180;
                    }
                }
            }
            FrostIllagerEntity.this.barrageTicks = n;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && FrostIllagerEntity.this.barrageTicks == 0;
        }

        @Override
        protected int getCastingTime() {
            return 20;
        }

        @Override
        protected int getCastingInterval() {
            return 600;
        }

        @Override
        protected int getCastWarmupTime() {
            return 50;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11867_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.FROST_BARRAGE;
        }
    }

    private class FrostIllagerSnowballBlastSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private FrostIllagerSnowballBlastSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = FrostIllagerEntity.this.m_5448_();
            int size = 5;
            if (target != null) {
                float f;
                if (FrostIllagerEntity.this.isInRaid()) {
                    float f2 = FrostIllagerEntity.this.getRaidDifficulty().config().frost().snowballBlastDamage();
                    f = f2 + (switch (FrostIllagerEntity.this.f_19853_.m_46791_()) {
                        default -> throw new IncompatibleClassChangeError();
                        case Difficulty.PEACEFUL, Difficulty.NORMAL -> 0.0f;
                        case Difficulty.EASY -> -0.5f;
                        case Difficulty.HARD -> 0.5f;
                    });
                } else {
                    switch (FrostIllagerEntity.this.f_19853_.m_46791_()) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case PEACEFUL: {
                            f = 0.0f;
                            break;
                        }
                        case EASY: {
                            f = 4.75f;
                            break;
                        }
                        case NORMAL: {
                            f = 6.5f;
                            break;
                        }
                        case HARD: {
                            f = 8.0f;
                        }
                    }
                }
                float damage = f;
                for (int i = 0; i < size; ++i) {
                    FrostSnowballEntity snowball = (FrostSnowballEntity)((EntityType)DifficultRaidsEntityTypes.FROST_SNOWBALL.get()).m_20615_(FrostIllagerEntity.this.f_19853_);
                    snowball.m_5602_((Entity)FrostIllagerEntity.this);
                    snowball.m_6034_(FrostIllagerEntity.this.m_146901_().m_123341_(), (double)FrostIllagerEntity.this.m_146901_().m_123342_() - 0.2, FrostIllagerEntity.this.m_146901_().m_123343_());
                    snowball.setDamage(damage);
                    double targetY = target.m_20188_() - 1.1;
                    double targetX = target.m_20185_() - FrostIllagerEntity.this.m_20185_();
                    double targetSnowballY = targetY - snowball.m_20186_();
                    double targetZ = target.m_20189_() - FrostIllagerEntity.this.m_20189_();
                    double distanceY = Math.sqrt(targetX * targetX + targetZ * targetZ) * (double)0.2f;
                    snowball.m_6686_(targetX, targetSnowballY + distanceY, targetZ, 1.6f, 3.0f);
                    FrostIllagerEntity.this.f_19853_.m_7967_((Entity)snowball);
                }
            }
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && FrostIllagerEntity.this.barrageTicks == 0;
        }

        @Override
        protected int getCastingTime() {
            return 15;
        }

        @Override
        protected int getCastingInterval() {
            return 60;
        }

        @Override
        protected int getCastWarmupTime() {
            return 5;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11867_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.FROST_SNOWBALL_BLAST;
        }
    }
}

