/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.elite;

import com.calculusmaster.difficultraids.entity.entities.core.AbstractEvokerVariant;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.entities.Guard;

public class XydraxEliteEntity
extends AbstractEvokerVariant {
    private final TextComponent ELITE_NAME = new TextComponent("Xydrax, Windborne");
    private final ServerBossEvent ELITE_EVENT = new ServerBossEvent((Component)this.ELITE_NAME, BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
    private boolean isHealing;
    private int windColumnTicks;
    private BlockPos windColumnCenterPos;
    private AABB windColumnAABB;
    private List<BlockPos> windColumnParticleSpawnPositions;

    public XydraxEliteEntity(EntityType<? extends AbstractEvokerVariant> p_33724_, Level p_33725_) {
        super(p_33724_, p_33725_);
    }

    public static AttributeSupplier.Builder createEliteAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.39f).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 85.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22278_, 0.8);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new XydraxCastSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new XydraxAvoidEntityGoal(4.0f, 0.7, 0.9));
        this.f_21345_.m_25352_(3, (Goal)new XydraxWindBlastGoal());
        this.f_21345_.m_25352_(4, (Goal)new XydraxHealGoal());
        this.f_21345_.m_25352_(4, (Goal)new XydraxWindColumnGoal());
        this.f_21345_.m_25352_(5, (Goal)new XydraxBarrageGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        if (DifficultRaidsUtil.isGuardVillagersLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guard.class, 8.0f, 0.7, 1.0));
        }
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
        HashMap<Enchantment, Integer> generalEnchants = new HashMap<Enchantment, Integer>();
        generalEnchants.put(Enchantments.f_44965_, 1);
        generalEnchants.put(Enchantments.f_44963_, 1);
        ItemStack helm = new ItemStack((ItemLike)Items.f_42472_);
        ItemStack chest = new ItemStack((ItemLike)Items.f_42473_);
        ItemStack legs = new ItemStack((ItemLike)Items.f_42474_);
        ItemStack boots = new ItemStack((ItemLike)Items.f_42475_);
        EnchantmentHelper.m_44865_(generalEnchants, (ItemStack)helm);
        EnchantmentHelper.m_44865_(generalEnchants, (ItemStack)chest);
        EnchantmentHelper.m_44865_(generalEnchants, (ItemStack)legs);
        EnchantmentHelper.m_44865_(generalEnchants, (ItemStack)boots);
        this.m_8061_(EquipmentSlot.HEAD, helm);
        this.m_8061_(EquipmentSlot.CHEST, chest);
        this.m_8061_(EquipmentSlot.LEGS, legs);
        this.m_8061_(EquipmentSlot.FEET, boots);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsHealing", this.isHealing);
        pCompound.m_128405_("WindColumnTicks", this.windColumnTicks);
        pCompound.m_128385_("WindColumnCenterPos", new int[]{this.windColumnCenterPos.m_123341_(), this.windColumnCenterPos.m_123342_(), this.windColumnCenterPos.m_123343_()});
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.isHealing = pCompound.m_128471_("IsHealing");
        this.windColumnTicks = pCompound.m_128451_("WindColumnTicks");
        int[] posArray = pCompound.m_128465_("WindColumnCenterPos");
        BlockPos blockPos = this.windColumnCenterPos = posArray.length == 3 ? new BlockPos(posArray[0], posArray[1], posArray[2]) : BlockPos.f_121853_;
        if (this.windColumnTicks > 0 && !this.windColumnCenterPos.equals((Object)BlockPos.f_121853_)) {
            this.buildWindColumn(this.windColumnCenterPos);
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.ELITE_EVENT.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity;
        if (pSource.m_7639_() instanceof IronGolem || DifficultRaidsUtil.isGuardVillagersLoaded() && pSource.m_7639_() instanceof Guard) {
            pAmount = (float)((double)pAmount * 0.4);
        }
        if ((entity = pSource.m_7640_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if ((double)this.f_19796_.nextFloat() < 0.2) {
                living.m_5997_(0.0, (double)this.f_19796_.nextFloat() * 0.7, 0.0);
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isHealing()) {
            if (this.m_20096_()) {
                this.m_21195_(MobEffects.f_19591_);
                this.isHealing = false;
            } else {
                float currentHealth = this.m_21223_();
                float maxHealth = this.m_21233_();
                if (maxHealth - currentHealth > 0.5f) {
                    float healAmount = this.f_19796_.nextFloat();
                    this.m_5634_(healAmount);
                }
            }
        } else if (this.isWindColumnActive()) {
            --this.windColumnTicks;
            if (this.m_21573_().m_26572_()) {
                this.m_21573_().m_26573_();
            }
            if (this.f_19853_.f_46443_) {
                this.windColumnParticleSpawnPositions.forEach(pos -> {
                    Supplier<Triple> particleSpawn = () -> Triple.of((Object)((double)((float)pos.m_123341_() + this.f_19796_.nextFloat()) - 0.5), (Object)((double)pos.m_123342_() + 3.0), (Object)((double)((float)pos.m_123343_() + this.f_19796_.nextFloat()) - 0.5));
                    for (int i = 0; i < 3; ++i) {
                        Triple spawn = particleSpawn.get();
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, ((Double)spawn.getLeft()).doubleValue(), ((Double)spawn.getMiddle()).doubleValue(), ((Double)spawn.getRight()).doubleValue(), 0.05, 0.6, 0.05);
                    }
                });
            }
            ArrayList<EntityType> validTypes = new ArrayList<EntityType>(List.of(EntityType.f_20492_, EntityType.f_20460_, EntityType.f_20532_));
            if (DifficultRaidsUtil.isGuardVillagersLoaded()) {
                validTypes.add((EntityType)GuardEntityType.GUARD.get());
            }
            List targets = this.f_19853_.m_6443_(LivingEntity.class, this.windColumnAABB, e -> {
                if (e instanceof Player) {
                    Player player = (Player)e;
                    return !player.m_5833_() && !player.m_7500_();
                }
                return validTypes.contains(e.m_6095_());
            });
            targets.forEach(living -> living.m_5997_((double)(this.f_19796_.nextFloat() / 3.0f), 0.7, (double)(this.f_19796_.nextFloat() / 3.0f)));
            if (this.windColumnTicks == 0) {
                this.windColumnCenterPos = BlockPos.f_121853_;
                this.windColumnAABB = new AABB(BlockPos.f_121853_);
                this.windColumnParticleSpawnPositions = List.of();
            }
        }
    }

    private Vec3 vectorTo(LivingEntity other) {
        Vec3 thisPos = this.m_146892_();
        Vec3 otherPos = other.m_146892_();
        return new Vec3(otherPos.f_82479_ - thisPos.f_82479_, otherPos.f_82480_ - thisPos.f_82480_, otherPos.f_82481_ - thisPos.f_82481_);
    }

    public boolean isHealing() {
        return this.isHealing;
    }

    public boolean isWindColumnActive() {
        return this.windColumnTicks > 0;
    }

    private void buildWindColumn(BlockPos thisPos) {
        this.windColumnCenterPos = new BlockPos((Vec3i)thisPos);
        this.windColumnAABB = new AABB(this.windColumnCenterPos).m_82400_(2.0);
        double yOffset = 0.3;
        this.windColumnParticleSpawnPositions = List.of(this.windColumnCenterPos.m_142022_(2.0, yOffset, 0.0), this.windColumnCenterPos.m_142022_(-2.0, yOffset, 0.0), this.windColumnCenterPos.m_142022_(0.0, yOffset, 2.0), this.windColumnCenterPos.m_142022_(0.0, yOffset, -2.0), this.windColumnCenterPos.m_142022_(2.0, yOffset, 2.0), this.windColumnCenterPos.m_142022_(-2.0, yOffset, 2.0), this.windColumnCenterPos.m_142022_(2.0, yOffset, -2.0), this.windColumnCenterPos.m_142022_(-2.0, yOffset, -2.0));
    }

    private boolean isInExtendedSpellState() {
        return this.isHealing() || this.isWindColumnActive();
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.ELITE_EVENT.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.ELITE_EVENT.m_6539_(pPlayer);
    }

    private class XydraxCastSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerCastSpellGoal {
        private XydraxCastSpellGoal() {
        }

        @Override
        public void m_8037_() {
            if (XydraxEliteEntity.this.m_5448_() != null) {
                XydraxEliteEntity.this.m_21563_().m_24960_((Entity)XydraxEliteEntity.this.m_5448_(), (float)XydraxEliteEntity.this.m_8085_(), (float)XydraxEliteEntity.this.m_8132_());
            }
        }
    }

    private class XydraxAvoidEntityGoal
    extends AvoidEntityGoal<LivingEntity> {
        public XydraxAvoidEntityGoal(float pMaxDistance, double pWalkSpeedModifier, double pSprintSpeedModifier) {
            super((PathfinderMob)XydraxEliteEntity.this, LivingEntity.class, pMaxDistance, pWalkSpeedModifier, pSprintSpeedModifier, e -> {
                Player player;
                return e instanceof Player && !(player = (Player)e).m_7500_() && !player.m_5833_() || DifficultRaidsUtil.isGuardVillagersLoaded() && e instanceof Guard;
            });
        }

        public boolean m_8036_() {
            return super.m_8036_() && !XydraxEliteEntity.this.isInExtendedSpellState() && !XydraxEliteEntity.this.isCastingSpell();
        }
    }

    private class XydraxWindBlastGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private final List<EntityType<?>> targetTypes;
        private final Supplier<Double> radius;

        private XydraxWindBlastGoal() {
            super(new Goal.Flag[0]);
            this.targetTypes = new ArrayList<EntityType>(List.of(EntityType.f_20492_, EntityType.f_20460_, EntityType.f_20532_));
            if (DifficultRaidsUtil.isGuardVillagersLoaded()) {
                this.targetTypes.add((EntityType)GuardEntityType.GUARD.get());
            }
            this.radius = () -> switch (XydraxEliteEntity.this.f_19853_.m_46791_()) {
                default -> throw new IncompatibleClassChangeError();
                case Difficulty.PEACEFUL -> 0.0;
                case Difficulty.EASY -> 4.0;
                case Difficulty.NORMAL -> 7.0;
                case Difficulty.HARD -> 10.0;
            };
        }

        private List<LivingEntity> getNearbyEntities(double radius) {
            AABB aabb = new AABB(XydraxEliteEntity.this.m_142538_()).m_82400_(radius);
            return XydraxEliteEntity.this.f_19853_.m_6443_(LivingEntity.class, aabb, e -> {
                if (e instanceof Player) {
                    Player player = (Player)e;
                    return !player.m_7500_() && !player.m_5833_();
                }
                return this.targetTypes.contains(e.m_6095_());
            });
        }

        @Override
        protected void castSpell() {
            this.getNearbyEntities(this.radius.get()).forEach(entity -> {
                Vec3 vecToNormalized = XydraxEliteEntity.this.vectorTo((LivingEntity)entity).m_82541_();
                double force = switch (XydraxEliteEntity.this.f_19853_.m_46791_()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Difficulty.PEACEFUL -> 0.0;
                    case Difficulty.EASY -> 0.5;
                    case Difficulty.NORMAL -> 1.25;
                    case Difficulty.HARD -> 2.0;
                };
                Vec3 pushVector = new Vec3(vecToNormalized.f_82479_ * force, 0.5, vecToNormalized.f_82481_ * force);
                entity.m_5997_(pushVector.f_82479_, pushVector.f_82480_, pushVector.f_82481_);
            });
        }

        @Override
        public boolean m_8036_() {
            return XydraxEliteEntity.this.f_19797_ >= this.spellCooldown && !XydraxEliteEntity.this.isCastingSpell() && !this.getNearbyEntities(this.radius.get()).isEmpty() && !XydraxEliteEntity.this.isInExtendedSpellState();
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 500;
        }

        @Override
        protected int getCastWarmupTime() {
            return 5;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11937_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.XYDRAX_WIND_BLAST;
        }
    }

    private class XydraxHealGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private XydraxHealGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            XydraxEliteEntity xydrax = XydraxEliteEntity.this;
            xydrax.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 300, 1, false, false));
            Vec3 pos = xydrax.m_146892_();
            xydrax.m_6021_(pos.f_82479_, pos.f_82480_ + 3.0 + (double)(xydrax.f_19796_.nextFloat() * 5.0f), pos.f_82481_);
            xydrax.m_6853_(false);
            xydrax.isHealing = true;
        }

        @Override
        public boolean m_8036_() {
            XydraxEliteEntity e = XydraxEliteEntity.this;
            return XydraxEliteEntity.this.f_19797_ >= this.spellCooldown && !XydraxEliteEntity.this.isCastingSpell() && !e.isInExtendedSpellState() && (double)e.m_21223_() < (double)e.m_21233_() * 0.5;
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 640;
        }

        @Override
        protected int getCastWarmupTime() {
            return 6;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.XYDRAX_HEAL;
        }
    }

    private class XydraxWindColumnGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private XydraxWindColumnGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            XydraxEliteEntity xydrax = XydraxEliteEntity.this;
            xydrax.m_21573_().m_26573_();
            xydrax.windColumnTicks = xydrax.f_19796_.nextInt(100, 401);
            xydrax.buildWindColumn(xydrax.m_142538_());
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !XydraxEliteEntity.this.isInExtendedSpellState();
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        protected int getCastingInterval() {
            return 700;
        }

        @Override
        protected int getCastWarmupTime() {
            return 20;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11983_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.XYDRAX_WIND_COLUMN;
        }
    }

    private class XydraxBarrageGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private XydraxBarrageGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            LivingEntity target = XydraxEliteEntity.this.m_5448_();
            if (target != null) {
                for (int i = 0; i < 8; ++i) {
                    Arrow arrow = new Arrow(XydraxEliteEntity.this.f_19853_, (LivingEntity)XydraxEliteEntity.this){

                        protected void m_8060_(BlockHitResult p_36755_) {
                            super.m_8060_(p_36755_);
                            this.m_146870_();
                        }

                        protected void m_5790_(EntityHitResult pResult) {
                            if (!(pResult.m_82443_() instanceof Raider)) {
                                super.m_5790_(pResult);
                            }
                        }
                    };
                    arrow.m_6034_((double)XydraxEliteEntity.this.m_146901_().m_123341_(), (double)XydraxEliteEntity.this.m_146901_().m_123342_() - 0.2, (double)XydraxEliteEntity.this.m_146901_().m_123343_());
                    double targetY = target.m_20188_() - 1.1;
                    double targetX = target.m_20185_() - XydraxEliteEntity.this.m_20185_();
                    double targetArrowY = targetY - arrow.m_20186_();
                    double targetZ = target.m_20189_() - XydraxEliteEntity.this.m_20189_();
                    double distanceY = Math.sqrt(targetX * targetX + targetZ * targetZ) * (double)0.2f;
                    arrow.m_6686_(targetX, targetArrowY + distanceY, targetZ, 2.0f, 7.0f);
                    XydraxEliteEntity.this.f_19853_.m_7967_((Entity)arrow);
                }
            }
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !XydraxEliteEntity.this.isInExtendedSpellState();
        }

        @Override
        protected int getCastingTime() {
            return 50;
        }

        @Override
        protected int getCastingInterval() {
            return 100;
        }

        @Override
        protected int getCastWarmupTime() {
            return 10;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11865_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.XYDRAX_ARROW_BARRAGE;
        }
    }
}

