/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.elite;

import com.calculusmaster.difficultraids.entity.entities.component.VoldonFamiliarEntity;
import com.calculusmaster.difficultraids.entity.entities.core.AbstractEvokerVariant;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.setup.DifficultRaidsItems;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.entities.Guard;

public class VoldonEliteEntity
extends AbstractEvokerVariant
implements RangedAttackMob {
    private final TextComponent ELITE_NAME = new TextComponent("Voldon, The Protected");
    private final ServerBossEvent ELITE_EVENT = new ServerBossEvent((Component)this.ELITE_NAME, BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
    private int totalFamiliars = 0;
    private List<LivingEntity> familiars = new ArrayList<LivingEntity>();

    public VoldonEliteEntity(EntityType<? extends AbstractEvokerVariant> p_33724_, Level p_33725_) {
        super(p_33724_, p_33725_);
    }

    public static AttributeSupplier.Builder createEliteAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.42f).m_22268_(Attributes.f_22277_, 15.0).m_22268_(Attributes.f_22276_, 90.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22278_, 0.3);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new VoldonCastSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 4.0f, 0.6, 0.75));
        this.f_21345_.m_25352_(3, (Goal)new VoldonSummonFamiliarsSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new VoldonTeleportFamiliarSpellGoal());
        this.f_21345_.m_25352_(5, (Goal)new VoldonSacrificeFamiliarSpellGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        if (DifficultRaidsUtil.isGuardVillagersLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guard.class, 8.0f, 0.7, 1.0));
        }
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        for (int ID : pCompound.m_128465_("FamiliarIDs")) {
            Entity entity = this.f_19853_.m_6815_(ID);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity familiar = (LivingEntity)entity;
            this.familiars.add(familiar);
        }
        this.totalFamiliars = pCompound.m_128451_("TotalFamiliarCount");
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        int[] IDs = new int[this.familiars.size()];
        for (int i = 0; i < IDs.length; ++i) {
            IDs[i] = this.familiars.get(i).m_142049_();
        }
        pCompound.m_128385_("FamiliarIDs", IDs);
        pCompound.m_128405_("TotalFamiliarCount", this.totalFamiliars);
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
        HashMap<Enchantment, Integer> generalEnchants = new HashMap<Enchantment, Integer>();
        generalEnchants.put(Enchantments.f_44965_, 1);
        generalEnchants.put(Enchantments.f_44963_, 1);
        ItemStack helm = new ItemStack((ItemLike)Items.f_42472_);
        ItemStack chest = new ItemStack((ItemLike)Items.f_42473_);
        ItemStack legs = new ItemStack((ItemLike)Items.f_42470_);
        ItemStack boots = new ItemStack((ItemLike)Items.f_42471_);
        EnchantmentHelper.m_44865_(generalEnchants, (ItemStack)helm);
        EnchantmentHelper.m_44865_(generalEnchants, (ItemStack)chest);
        EnchantmentHelper.m_44865_(generalEnchants, (ItemStack)legs);
        EnchantmentHelper.m_44865_(generalEnchants, (ItemStack)boots);
        this.m_8061_(EquipmentSlot.HEAD, helm);
        this.m_8061_(EquipmentSlot.CHEST, chest);
        this.m_8061_(EquipmentSlot.LEGS, legs);
        this.m_8061_(EquipmentSlot.FEET, boots);
    }

    public boolean areFamiliarsDead() {
        return this.familiars.isEmpty();
    }

    public void removeFamiliar(VoldonFamiliarEntity familiar) {
        this.familiars.remove((Object)familiar);
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.ELITE_EVENT.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7639_() instanceof IronGolem || DifficultRaidsUtil.isGuardVillagersLoaded() && pSource.m_7639_() instanceof Guard) {
            pAmount = (float)((double)pAmount * 0.5);
        }
        if (!this.areFamiliarsDead()) {
            pAmount = (float)((double)pAmount * (1.0 - (double)this.familiars.size() / (double)this.totalFamiliars + (double)0.1f));
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        BlockPos pos = this.m_142538_();
        int randomSpawnCount = this.f_19796_.nextInt(3, 6);
        for (int i = 0; i < randomSpawnCount; ++i) {
            BlockPos spawnPos = pos.m_142082_(5 - this.f_19796_.nextInt(1, 10), 1, 5 - this.f_19796_.nextInt(1, 10));
            Monster zombie = (Monster)EntityType.f_20501_.m_20615_(this.f_19853_);
            zombie.m_20035_(spawnPos, 0.0f, 0.0f);
            zombie.f_21346_.m_148096_();
            zombie.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)zombie, Villager.class, true));
            zombie.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)zombie, Player.class, true));
            zombie.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)zombie, IronGolem.class, true));
            if (!DifficultRaidsUtil.isGuardVillagersLoaded()) continue;
            zombie.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)zombie, Guard.class, true));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.familiars.removeIf(LivingEntity::m_21224_);
        }
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        this.m_19983_(new ItemStack((ItemLike)DifficultRaidsItems.TOTEM_OF_PROTECTION.get()));
        this.m_19983_(new ItemStack((ItemLike)DifficultRaidsItems.TOTEM_OF_PROTECTION.get()));
        this.m_19983_(new ItemStack((ItemLike)DifficultRaidsItems.TOTEM_OF_PROTECTION.get()));
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.ELITE_EVENT.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.ELITE_EVENT.m_6539_(pPlayer);
    }

    private class VoldonCastSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerCastSpellGoal {
        private VoldonCastSpellGoal() {
        }

        @Override
        public void m_8037_() {
            if (VoldonEliteEntity.this.m_5448_() != null) {
                VoldonEliteEntity.this.m_21563_().m_24960_((Entity)VoldonEliteEntity.this.m_5448_(), (float)VoldonEliteEntity.this.m_8085_(), (float)VoldonEliteEntity.this.m_8132_());
            }
        }
    }

    private class VoldonSummonFamiliarsSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private VoldonSummonFamiliarsSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            int familiarCount;
            if (VoldonEliteEntity.this.isInRaid() && !VoldonEliteEntity.this.getRaidDifficulty().isDefault()) {
                familiarCount = switch (VoldonEliteEntity.this.getRaidDifficulty()) {
                    case RaidDifficulty.HERO -> 4;
                    case RaidDifficulty.LEGEND -> 6;
                    case RaidDifficulty.MASTER -> 8;
                    case RaidDifficulty.GRANDMASTER -> 12;
                    default -> 0;
                };
            } else {
                familiarCount = switch (VoldonEliteEntity.this.f_19853_.m_46791_()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Difficulty.PEACEFUL -> 0;
                    case Difficulty.EASY -> 3;
                    case Difficulty.NORMAL -> 4;
                    case Difficulty.HARD -> 6;
                };
            }
            VoldonEliteEntity.this.totalFamiliars = familiarCount;
            BlockPos sourcePos = VoldonEliteEntity.this.m_142538_();
            Supplier<BlockPos> familiarPos = () -> sourcePos.m_142082_(VoldonEliteEntity.this.f_19796_.nextInt(2, 6), VoldonEliteEntity.this.f_19796_.nextInt(2, 6), VoldonEliteEntity.this.f_19796_.nextInt(2, 6));
            for (int i = 0; i < familiarCount; ++i) {
                VoldonFamiliarEntity familiar = new VoldonFamiliarEntity(VoldonEliteEntity.this.f_19853_, VoldonEliteEntity.this);
                familiar.m_20035_(familiarPos.get(), 0.0f, 0.0f);
                familiar.m_6853_(true);
                LogUtils.getLogger().info("Spawning Voldon Familiar!");
                familiar.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 10000, 1));
                VoldonEliteEntity.this.f_19853_.m_7967_((Entity)familiar);
                VoldonEliteEntity.this.familiars.add((LivingEntity)familiar);
            }
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && VoldonEliteEntity.this.areFamiliarsDead();
        }

        @Override
        protected int getCastingTime() {
            return 70;
        }

        @Override
        protected int getCastingInterval() {
            return 1800;
        }

        @Override
        protected int getCastWarmupTime() {
            return 20;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.VOLDON_SUMMON_FAMILIARS;
        }
    }

    private class VoldonTeleportFamiliarSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private VoldonTeleportFamiliarSpellGoal() {
            super(Goal.Flag.MOVE, Goal.Flag.LOOK);
        }

        @Override
        protected void castSpell() {
            List<LivingEntity> familiars = VoldonEliteEntity.this.familiars.stream().filter(LivingEntity::m_6084_).toList();
            if (!familiars.isEmpty()) {
                LivingEntity target = familiars.get(VoldonEliteEntity.this.f_19796_.nextInt(familiars.size()));
                VoldonEliteEntity.this.m_21563_().m_148051_((Entity)target);
                double yOffset = 0.3;
                BlockPos targetPos = target.m_142538_().m_142022_(0.0, yOffset, 0.0);
                BlockPos thisPos = VoldonEliteEntity.this.m_142538_().m_142022_(0.0, yOffset, 0.0);
                VoldonEliteEntity.this.m_20324_(targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_());
                target.m_20324_((double)thisPos.m_123341_(), (double)thisPos.m_123342_(), (double)thisPos.m_123343_());
            }
        }

        @Override
        public boolean m_8036_() {
            return VoldonEliteEntity.this.f_19797_ >= this.spellCooldown && !VoldonEliteEntity.this.areFamiliarsDead() && VoldonEliteEntity.this.m_21223_() < VoldonEliteEntity.this.m_21233_() * 2.0f / 3.0f;
        }

        @Override
        protected int getCastingTime() {
            return 10;
        }

        @Override
        protected int getCastingInterval() {
            return 700;
        }

        @Override
        protected int getCastWarmupTime() {
            return 5;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11852_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.VOLDON_TELEPORT_FAMILIAR;
        }
    }

    private class VoldonSacrificeFamiliarSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private VoldonSacrificeFamiliarSpellGoal() {
            super(Goal.Flag.LOOK);
        }

        @Override
        protected void castSpell() {
            boolean last;
            List<LivingEntity> familiars = VoldonEliteEntity.this.familiars.stream().filter(LivingEntity::m_6084_).toList();
            boolean bl = last = familiars.size() == 1;
            if (!familiars.isEmpty()) {
                LivingEntity target = familiars.get(VoldonEliteEntity.this.f_19796_.nextInt(familiars.size()));
                VoldonEliteEntity.this.m_21563_().m_148051_((Entity)target);
                ((Mob)target).m_21563_().m_148051_((Entity)VoldonEliteEntity.this);
                int health = (int)target.m_21223_();
                int resistanceDuration = health * 10 + (last ? 100 : 0);
                int regenerationDuration = health * 5 + (last ? 80 : 0);
                VoldonEliteEntity.this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, resistanceDuration, 1));
                VoldonEliteEntity.this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, regenerationDuration, 1));
                VoldonEliteEntity.this.m_5496_(SoundEvents.f_12551_, 1.0f, 1.0f);
                target.m_6469_(DamageSource.f_19313_, (float)health + 1.0f);
            }
        }

        @Override
        public boolean m_8036_() {
            return VoldonEliteEntity.this.f_19797_ >= this.spellCooldown && !VoldonEliteEntity.this.areFamiliarsDead();
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 900;
        }

        @Override
        protected int getCastWarmupTime() {
            return 10;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11900_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.VOLDON_SACRIFICE_FAMILIAR;
        }
    }
}

