/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.elite;

import com.calculusmaster.difficultraids.entity.entities.core.AbstractIllagerVariant;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.entities.Guard;

public class NuaosEliteEntity
extends AbstractIllagerVariant {
    private final TextComponent ELITE_NAME = new TextComponent("Nuaos, The Chosen");
    private final ServerBossEvent ELITE_EVENT = new ServerBossEvent((Component)this.ELITE_NAME, BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
    private static final EntityDataAccessor<Float> STORED_CHARGE_DAMAGE = SynchedEntityData.m_135353_(NuaosEliteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final float maxChargedDamage;
    private int ticksLastDamageTaken = 0;
    private static final AttributeModifier NUAOS_CHARGED_DAMAGE_BOOST = new AttributeModifier("Nuaos Charged Damage Boost", 1.25, AttributeModifier.Operation.MULTIPLY_BASE);

    public NuaosEliteEntity(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
        this.maxChargedDamage = 30.0f;
    }

    public static AttributeSupplier.Builder createEliteAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 120.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 0.8);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(2, (Goal)new NuaosMeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STORED_CHARGE_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7639_() instanceof IronGolem || DifficultRaidsUtil.isGuardVillagersLoaded() && pSource.m_7639_() instanceof Guard) {
            pAmount = (float)((double)pAmount * 0.4);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
        HashMap<Enchantment, Integer> generalEnchants = new HashMap<Enchantment, Integer>();
        generalEnchants.put(Enchantments.f_44965_, 3);
        generalEnchants.put(Enchantments.f_44963_, 1);
        ItemStack helm = new ItemStack((ItemLike)Items.f_42472_);
        ItemStack chest = new ItemStack((ItemLike)Items.f_42473_);
        ItemStack legs = new ItemStack((ItemLike)Items.f_42474_);
        ItemStack boots = new ItemStack((ItemLike)Items.f_42475_);
        EnchantmentHelper.m_44865_(generalEnchants, (ItemStack)helm);
        EnchantmentHelper.m_44865_(generalEnchants, (ItemStack)chest);
        EnchantmentHelper.m_44865_(generalEnchants, (ItemStack)legs);
        EnchantmentHelper.m_44865_(generalEnchants, (ItemStack)boots);
        this.m_8061_(EquipmentSlot.HEAD, helm);
        this.m_8061_(EquipmentSlot.CHEST, chest);
        this.m_8061_(EquipmentSlot.LEGS, legs);
        this.m_8061_(EquipmentSlot.FEET, boots);
        ItemStack sword = new ItemStack((ItemLike)Items.f_42388_);
        sword.m_41663_(Enchantments.f_44977_, 2);
        this.m_21008_(InteractionHand.MAIN_HAND, sword);
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        this.m_19983_(this.m_21120_(InteractionHand.MAIN_HAND));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        ItemStack sword = new ItemStack((ItemLike)(this.isInRaid() && this.getRaidDifficulty().is(RaidDifficulty.MASTER, RaidDifficulty.GRANDMASTER) ? Items.f_42393_ : Items.f_42388_));
        HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
        enchants.put(Enchantments.f_44977_, 3);
        EnchantmentHelper.m_44865_(enchants, (ItemStack)sword);
        this.m_8061_(EquipmentSlot.MAINHAND, sword);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void increaseChargedDamage(float amount) {
        ChargeState prevState = this.getChargeState();
        this.f_19804_.m_135381_(STORED_CHARGE_DAMAGE, (Object)Float.valueOf(this.getStoredChargeDamage() + amount));
        if (prevState != this.getChargeState()) {
            this.m_5496_(SoundEvents.f_12350_, 1.0f, 1.0f);
        }
    }

    public void resetChargedDamage() {
        this.f_19804_.m_135381_(STORED_CHARGE_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void resetLastDamageTakenTicks() {
        this.ticksLastDamageTaken = 0;
    }

    public float getStoredChargeDamage() {
        return ((Float)this.f_19804_.m_135370_(STORED_CHARGE_DAMAGE)).floatValue();
    }

    public ChargeState getChargeState() {
        double percentCharged = this.getStoredChargeDamage() / this.maxChargedDamage;
        if (percentCharged < 0.15) {
            return ChargeState.NO_CHARGE;
        }
        if (percentCharged < 0.5) {
            return ChargeState.LOW_CHARGE;
        }
        if (percentCharged < 0.9) {
            return ChargeState.HIGH_CHARGE;
        }
        return ChargeState.MAX_CHARGE;
    }

    protected void m_8024_() {
        super.m_8024_();
        this.ELITE_EVENT.m_142711_(this.m_21223_() / this.m_21233_());
        AttributeInstance attackDamageAttribute = this.m_21051_(Attributes.f_22281_);
        if (attackDamageAttribute != null) {
            boolean hasModifier = attackDamageAttribute.m_22109_(NUAOS_CHARGED_DAMAGE_BOOST);
            if (!this.getChargeState().equals((Object)ChargeState.NO_CHARGE) && !hasModifier) {
                attackDamageAttribute.m_22118_(NUAOS_CHARGED_DAMAGE_BOOST);
            } else if (hasModifier) {
                attackDamageAttribute.m_22130_(NUAOS_CHARGED_DAMAGE_BOOST);
            }
        }
        if (this.ticksLastDamageTaken++ > 100) {
            float decayPercent = this.f_19796_.nextFloat(0.1f) + 0.005f;
            float stored = this.getStoredChargeDamage() - this.maxChargedDamage * decayPercent;
            if (stored <= 0.0f) {
                this.resetChargedDamage();
            } else {
                this.f_19804_.m_135381_(STORED_CHARGE_DAMAGE, (Object)Float.valueOf(stored));
            }
        }
        if (this.getStoredChargeDamage() >= this.maxChargedDamage) {
            double shockwaveRadius;
            this.resetChargedDamage();
            this.m_5496_(SoundEvents.f_11913_, 0.8f, 0.8f);
            ArrayList<EntityType> canReceiveDamage = new ArrayList<EntityType>(List.of(EntityType.f_20492_, EntityType.f_20532_, EntityType.f_20460_));
            if (DifficultRaidsUtil.isGuardVillagersLoaded()) {
                canReceiveDamage.add((EntityType)GuardEntityType.GUARD.get());
            }
            if (this.isInRaid()) {
                shockwaveRadius = switch (this.getRaidDifficulty()) {
                    default -> throw new IncompatibleClassChangeError();
                    case RaidDifficulty.DEFAULT, RaidDifficulty.HERO, RaidDifficulty.LEGEND -> 4.0;
                    case RaidDifficulty.MASTER -> 5.0;
                    case RaidDifficulty.GRANDMASTER -> 7.0;
                };
            } else {
                shockwaveRadius = 4.0;
            }
            AABB shockwaveAABB = new AABB(this.m_142538_()).m_82400_(shockwaveRadius);
            List targets = this.f_19853_.m_6443_(LivingEntity.class, shockwaveAABB, entity -> canReceiveDamage.stream().anyMatch(type -> entity.m_6095_().equals(type)));
            if (!targets.isEmpty()) {
                float minDamage = this.maxChargedDamage * 0.25f;
                double falloffStart = shockwaveRadius * 0.1;
                for (LivingEntity t : targets) {
                    float damage;
                    double distance = this.m_20270_((Entity)t);
                    if (distance <= falloffStart) {
                        damage = this.maxChargedDamage;
                    } else {
                        float falloffDamage = (float)((1.0 - (distance - falloffStart) / shockwaveRadius) * (double)this.maxChargedDamage);
                        damage = Math.max(falloffDamage, minDamage);
                    }
                    t.m_6469_(DamageSource.m_19370_((LivingEntity)this), damage);
                }
            }
        }
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.ELITE_EVENT.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.ELITE_EVENT.m_6539_(pPlayer);
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        return this.m_5912_() ? AbstractIllager.IllagerArmPose.ATTACKING : super.m_6768_();
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12577_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12576_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12578_;
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return SoundEvents.f_12579_;
    }

    class NuaosMeleeAttackGoal
    extends MeleeAttackGoal {
        private NuaosMeleeAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            int attackTimes = NuaosEliteEntity.this.f_19796_.nextInt(2, 6);
            for (int i = 0; i < attackTimes; ++i) {
                super.m_6739_(pEnemy, pDistToEnemySqr);
            }
        }
    }

    public static enum ChargeState {
        NO_CHARGE,
        LOW_CHARGE,
        HIGH_CHARGE,
        MAX_CHARGE;

    }
}

