/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.component;

import com.calculusmaster.difficultraids.entity.DifficultRaidsEntityTypes;
import com.calculusmaster.difficultraids.entity.entities.core.AbstractPillagerVariant;
import com.calculusmaster.difficultraids.entity.entities.elite.VoldonEliteEntity;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import com.mojang.logging.LogUtils;
import java.util.EnumSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import tallestegg.guardvillagers.entities.Guard;

public class VoldonFamiliarEntity
extends AbstractPillagerVariant {
    private VoldonEliteEntity voldon;

    public VoldonFamiliarEntity(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
        this.voldon = null;
    }

    public VoldonFamiliarEntity(Level level, VoldonEliteEntity voldon) {
        super((EntityType<? extends AbstractIllager>)((EntityType)DifficultRaidsEntityTypes.VOLDON_FAMILIAR.get()), level);
        this.voldon = voldon;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.33f).m_22268_(Attributes.f_22277_, 7.0).m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22281_, 6.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal<Player>((PathfinderMob)this, Player.class, 8.0f, 0.5, 0.7){

            public boolean m_8036_() {
                return super.m_8036_() && VoldonFamiliarEntity.this.isInHideState();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal<IronGolem>((PathfinderMob)this, IronGolem.class, 8.0f, 0.5, 0.7){

            public boolean m_8036_() {
                return super.m_8036_() && VoldonFamiliarEntity.this.isInHideState();
            }
        });
        if (DifficultRaidsUtil.isGuardVillagersLoaded()) {
            this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal<Guard>((PathfinderMob)this, Guard.class, 8.0f, 0.5, 0.7){

                public boolean m_8036_() {
                    return super.m_8036_() && VoldonFamiliarEntity.this.isInHideState();
                }
            });
        }
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.7, true));
        this.f_21345_.m_25352_(5, (Goal)new VoldonFamiliarReturnGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        if (DifficultRaidsUtil.isGuardVillagersLoaded()) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Guard.class, true));
        }
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.voldon = pCompound.m_128451_("VoldonID") == -1 ? null : (VoldonEliteEntity)this.f_19853_.m_6815_(pCompound.m_128451_("VoldonID"));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("VoldonID", this.voldon == null ? -1 : this.voldon.m_142049_());
    }

    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        Entity entity = pCause.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (pCause.m_7639_() instanceof Player || DifficultRaidsUtil.isGuardVillagersLoaded() && pCause.m_7639_() instanceof Guard) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, 3));
            }
        }
        if (this.voldon != null) {
            this.voldon.removeFamiliar(this);
        }
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public boolean isInHideState() {
        return this.m_21223_() < this.m_21233_() / 4.0f;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.voldon != null && this.voldon.m_21224_()) {
            this.m_6469_(DamageSource.f_19313_, this.m_21223_() + 1.0f);
            return;
        }
        if (this.m_5448_() != null && !this.isInHideState()) {
            double distance = this.m_20270_((Entity)this.m_5448_());
            Vec3 targetPos = this.m_5448_().m_20182_();
            if (distance > 3.0 && this.f_19796_.nextInt(100) < 2) {
                this.m_20984_(targetPos.f_82479_, targetPos.f_82480_ + 0.2, targetPos.f_82481_, true);
            }
        }
        if (this.voldon != null) {
            double voldonDistance = this.m_20270_((Entity)this.voldon);
            if (voldonDistance > 15.0) {
                this.m_21573_().m_5624_((Entity)this.voldon, 0.9);
            }
        } else {
            LogUtils.getLogger().warn("Voldon Familiar (ID {%s}, Pos {%s}) has a null Voldon attribute!".formatted(this.m_142049_(), this.m_142538_()));
        }
    }

    private class VoldonFamiliarReturnGoal
    extends Goal {
        private VoldonFamiliarReturnGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        private boolean hasVoldon() {
            return VoldonFamiliarEntity.this.voldon != null && VoldonFamiliarEntity.this.voldon.m_6084_();
        }

        private double getDistanceToVoldon() {
            return VoldonFamiliarEntity.this.m_20270_((Entity)VoldonFamiliarEntity.this.voldon);
        }

        public boolean m_8036_() {
            return this.hasVoldon() && this.getDistanceToVoldon() > 15.0;
        }

        public boolean m_8045_() {
            return this.hasVoldon() && this.getDistanceToVoldon() > 5.0;
        }

        public void m_8056_() {
            VoldonFamiliarEntity.this.m_21573_().m_5624_((Entity)VoldonFamiliarEntity.this.voldon, 0.8);
        }

        public void m_8041_() {
            VoldonFamiliarEntity.this.m_21573_().m_26573_();
        }
    }
}

