/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.component;

import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import tallestegg.guardvillagers.entities.Guard;

public class ShamanDebuffBulletEntity
extends ShulkerBullet {
    private List<MobEffectInstance> debuffs = new ArrayList<MobEffectInstance>();

    public ShamanDebuffBulletEntity(EntityType<? extends ShulkerBullet> p_37319_, Level p_37320_) {
        super(p_37319_, p_37320_);
    }

    private ShamanDebuffBulletEntity(Level p_37330_, LivingEntity p_37331_, Entity p_37332_, Direction.Axis p_37333_) {
        super(p_37330_, p_37331_, p_37332_, p_37333_);
    }

    public static ShamanDebuffBulletEntity create(Level level, LivingEntity owner, Entity target, Direction.Axis axis) {
        return new ShamanDebuffBulletEntity(level, owner, target, axis);
    }

    public void loadDebuff(MobEffectInstance debuff) {
        this.debuffs.add(debuff);
    }

    public boolean m_7337_(Entity pEntity) {
        return super.m_7337_(pEntity) && !(pEntity instanceof Raider);
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity entity = this.m_37282_();
        if (entity instanceof LivingEntity) {
            LivingEntity hitEntity;
            LivingEntity owner = (LivingEntity)entity;
            entity = pResult.m_82443_();
            if (entity instanceof LivingEntity && !((hitEntity = (LivingEntity)entity) instanceof Raider)) {
                boolean hitSuccess = hitEntity.m_6469_(DamageSource.m_19340_((Entity)this, (LivingEntity)owner), 3.0f);
                if (hitSuccess) {
                    this.m_19970_(owner, (Entity)this);
                }
                this.getModifiedDebuffs(hitSuccess ? 1.0 : 0.5).forEach(d -> hitEntity.m_147207_(d, (Entity)this));
            }
        }
    }

    protected void m_8060_(BlockHitResult p_37343_) {
        BlockPos pos = p_37343_.m_82425_();
        AABB applyRange = new AABB(pos).m_82400_(2.0);
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123783_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0.0, 0.2, 0.0);
        }
        ArrayList targets = new ArrayList();
        targets.addAll(this.f_19853_.m_45976_(Player.class, applyRange));
        targets.addAll(this.f_19853_.m_45976_(IronGolem.class, applyRange));
        targets.addAll(this.f_19853_.m_45976_(AbstractVillager.class, applyRange));
        if (DifficultRaidsUtil.isGuardVillagersLoaded()) {
            targets.addAll(this.f_19853_.m_45976_(Guard.class, applyRange));
        }
        List<MobEffectInstance> debuffs = this.getModifiedDebuffs(0.75);
        targets.forEach(living -> debuffs.forEach(arg_0 -> ((LivingEntity)living).m_7292_(arg_0)));
    }

    private List<MobEffectInstance> getModifiedDebuffs(double durationModifier) {
        return this.debuffs.stream().map(i -> {
            int duration = (int)((double)i.m_19557_() * durationModifier);
            return new MobEffectInstance(i.m_19544_(), duration, i.m_19564_(), i.m_19571_(), i.m_19572_(), i.m_19575_());
        }).toList();
    }
}

