/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.world.structure;

import com.izofar.bygonenether.util.ModStructureUtils;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;

public class CatacombStructure
extends StructureFeature<JigsawConfiguration> {
    private static final int STRUCTURE_SEARCH_RADIUS = 8;

    public CatacombStructure(Codec<JigsawConfiguration> codec) {
        super(codec, CatacombStructure::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static boolean checkLocation(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        NoiseColumn blockReader = context.f_197352_().m_141914_(blockpos.m_123341_(), blockpos.m_123343_(), context.f_197357_());
        return !ModStructureUtils.isBuried(blockReader, 48, ModStructureUtils.getScaledNetherHeight(72)) && !ModStructureUtils.isLavaLake(blockReader) && !ModStructureUtils.isNearStructure(context.f_197352_(), context.f_197354_(), context.f_197355_(), 8, BuiltinStructureSets.f_209833_);
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (!CatacombStructure.checkLocation(context)) {
            return Optional.empty();
        }
        BlockPos blockpos = ModStructureUtils.getElevation(context, 56, ModStructureUtils.getScaledNetherHeight(84));
        return JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)blockpos, (boolean)true, (boolean)false);
    }
}

