/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.loot;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ReplaceItemLootModifier
extends LootModifier {
    private final Item target;
    private final Item replacement;
    private final String modDependency;
    private final UnaryOperator<ItemStack> conversion;

    protected ReplaceItemLootModifier(LootItemCondition[] conditions, Item target, Item replacement, String modDependency) {
        super(conditions);
        this.target = target;
        this.replacement = replacement;
        this.modDependency = modDependency;
        this.conversion = itemStack -> itemStack.m_41720_() == target ? new ItemStack((ItemLike)this.replacement, itemStack.m_41613_()) : itemStack;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (ModList.get().isLoaded(this.modDependency)) {
            generatedLoot.replaceAll(this.conversion);
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ReplaceItemLootModifier> {
        public ReplaceItemLootModifier read(ResourceLocation name, JsonObject object, LootItemCondition[] conditions) {
            Item target = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"target")));
            Item replacement = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"replacement")));
            String modDependency = GsonHelper.m_13906_((JsonObject)object, (String)"mod_dependency");
            return new ReplaceItemLootModifier(conditions, target, replacement, modDependency);
        }

        public JsonObject write(ReplaceItemLootModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("target", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.target).toString());
            json.addProperty("replacement", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.replacement).toString());
            json.addProperty("mod_dependency", instance.modDependency);
            return json;
        }
    }
}

