/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.entity;

import com.izofar.bygonenether.entity.IShieldedMob;
import com.izofar.bygonenether.entity.ai.goal.ShieldGoal;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WitherSkeletonKnight
extends WitherSkeleton
implements IShieldedMob {
    private static final EntityDataAccessor<Boolean> DATA_IS_SHIELDED = SynchedEntityData.m_135353_(WitherSkeletonKnight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SHIELD_HAND = SynchedEntityData.m_135353_(WitherSkeletonKnight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_SHIELD_COOLDOWN = SynchedEntityData.m_135353_(WitherSkeletonKnight.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("3520BCE0-D755-458F-944B-A528DB8EF9DC");
    private static final AttributeModifier SPEED_MODIFIER_BLOCKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Shielded speed penalty", -0.1, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Boolean> DATA_IS_DISARMORED = SynchedEntityData.m_135353_(WitherSkeletonKnight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final float BREAK_HEALTH = 20.0f;

    public WitherSkeletonKnight(EntityType<? extends WitherSkeleton> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, new ShieldGoal<WitherSkeletonKnight>(this, Player.class));
        super.m_8099_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.decrementShieldCooldown();
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22284_, 2.0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Disarmored", this.isDisarmored());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setDisarmored(tag.m_128471_("Disarmored"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_DISARMORED, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_SHIELDED, (Object)false);
        this.f_19804_.m_135372_(DATA_SHIELD_HAND, (Object)false);
        this.f_19804_.m_135372_(DATA_SHIELD_COOLDOWN, (Object)0);
    }

    public boolean isDisarmored() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_DISARMORED);
    }

    private void setDisarmored(boolean disarmored) {
        this.f_19804_.m_135381_(DATA_IS_DISARMORED, (Object)disarmored);
    }

    public void m_6851_(DifficultyInstance difficulty) {
        super.m_6851_(difficulty);
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
    }

    public boolean m_6469_(DamageSource source, float damage) {
        boolean result = super.m_6469_(source, damage);
        if (!this.isDisarmored() && this.m_21223_() < 20.0f) {
            this.setDisarmored(true);
            this.m_5496_(SoundEvents.f_12347_, 1.2f, 0.8f + this.f_19853_.f_46441_.nextFloat() * 0.4f);
            this.m_7910_(0.25f);
        }
        return result;
    }

    public void m_147240_(double x, double y, double z) {
        if (!this.isUsingShield()) {
            super.m_147240_(x, y, z);
        } else {
            this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.f_19853_.f_46441_.nextFloat() * 0.4f);
        }
    }

    protected void m_6728_(LivingEntity attacker) {
        super.m_6728_(attacker);
        if (attacker.m_21205_().canDisableShield(this.f_20935_, (LivingEntity)this, attacker)) {
            this.disableShield();
        }
    }

    private void disableShield() {
        this.setShieldCooldown(60);
        this.stopUsingShield();
        this.f_19853_.m_7605_((Entity)this, (byte)30);
        this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.f_19853_.f_46441_.nextFloat() * 0.4f);
    }

    @Override
    public boolean isShieldDisabled() {
        return this.getShieldCooldown() > 0;
    }

    @Override
    public void startUsingShield() {
        if (this.isUsingShield() || this.isShieldDisabled()) {
            return;
        }
        for (InteractionHand interactionhand : InteractionHand.values()) {
            if (!this.m_21120_(interactionhand).m_150930_(Items.f_42740_)) continue;
            this.m_6672_(interactionhand);
            this.setUsingShield(true);
            this.setShieldMainhand(interactionhand == InteractionHand.MAIN_HAND);
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            if (attributeinstance == null || attributeinstance.m_22109_(SPEED_MODIFIER_BLOCKING)) continue;
            attributeinstance.m_22118_(SPEED_MODIFIER_BLOCKING);
        }
    }

    @Override
    public void stopUsingShield() {
        if (!this.isUsingShield()) {
            return;
        }
        for (InteractionHand interactionhand : InteractionHand.values()) {
            if (!this.m_21120_(interactionhand).m_150930_(Items.f_42740_)) continue;
            this.m_5810_();
            this.setUsingShield(false);
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            if (attributeinstance == null) continue;
            attributeinstance.m_22130_(SPEED_MODIFIER_BLOCKING);
        }
    }

    public boolean isUsingShield() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_SHIELDED);
    }

    public void setUsingShield(boolean isShielded) {
        this.f_19804_.m_135381_(DATA_IS_SHIELDED, (Object)isShielded);
    }

    private boolean isShieldMainhand() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SHIELD_HAND);
    }

    private void setShieldMainhand(boolean isShieldedMainHand) {
        this.f_19804_.m_135381_(DATA_SHIELD_HAND, (Object)isShieldedMainHand);
    }

    private int getShieldCooldown() {
        return (Integer)this.f_19804_.m_135370_(DATA_SHIELD_COOLDOWN);
    }

    private void setShieldCooldown(int newShieldCooldown) {
        this.f_19804_.m_135381_(DATA_SHIELD_COOLDOWN, (Object)newShieldCooldown);
    }

    private void decrementShieldCooldown() {
        this.setShieldCooldown(Math.max(this.getShieldCooldown() - 1, 0));
    }

    public InteractionHand getShieldHand() {
        return this.isUsingShield() ? (this.isShieldMainhand() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND) : null;
    }
}

