/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.entity;

import com.google.common.collect.ImmutableList;
import com.izofar.bygonenether.entity.ai.PiglinPrisonerAi;
import com.izofar.bygonenether.init.ModItems;
import com.izofar.bygonenether.init.ModSensorTypes;
import com.izofar.bygonenether.util.ModLists;
import com.izofar.bygonenether.util.random.ModWeightedEntry;
import com.mojang.serialization.Dynamic;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinArmPose;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class PiglinPrisoner
extends AbstractPiglin
implements CrossbowAttackMob,
InventoryCarrier {
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(PiglinPrisoner.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_DANCING = SynchedEntityData.m_135353_(PiglinPrisoner.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(PiglinPrisoner.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final int RESCUE_TIME = 75;
    protected int timeBeingRescued;
    protected boolean isBeingRescued;
    protected boolean hasTempter;
    protected static final ImmutableList<SensorType<? extends Sensor<? super PiglinPrisoner>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26810_, (Object)SensorType.f_26814_, (Object)((SensorType)ModSensorTypes.PIGLIN_PRISONER_SPECIFIC_SENSOR.get()));
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26379_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_26347_, (Object)MemoryModuleType.f_26346_, (Object)MemoryModuleType.f_26332_, (Object)MemoryModuleType.f_26381_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26372_, MemoryModuleType.f_26373_, MemoryModuleType.f_26374_, MemoryModuleType.f_26377_, MemoryModuleType.f_26334_, MemoryModuleType.f_26383_, MemoryModuleType.f_26336_, MemoryModuleType.f_26337_, MemoryModuleType.f_26339_, MemoryModuleType.f_26338_, MemoryModuleType.f_26341_, MemoryModuleType.f_26342_, MemoryModuleType.f_26333_, MemoryModuleType.f_26351_, MemoryModuleType.f_26352_, MemoryModuleType.f_26354_, MemoryModuleType.f_26355_, MemoryModuleType.f_26356_, MemoryModuleType.f_148196_, MemoryModuleType.f_148198_});
    private final SimpleContainer inventory = new SimpleContainer(8);

    public PiglinPrisoner(EntityType<? extends AbstractPiglin> entitytype, Level world) {
        super(entitytype, world);
        this.f_21364_ = 5;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && !this.hasTempter && this.getTempter() != null) {
            this.hasTempter = true;
            this.spawnHeartParticles();
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.m_7927_());
        tag.m_128405_("TimeBeingRescued", this.timeBeingRescued);
        tag.m_128379_("IsBeingRescued", this.isBeingRescued);
        if (this.getTempterUUID() != null) {
            tag.m_128362_("Tempter", this.getTempterUUID());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.inventory.m_7797_(tag.m_128437_("Inventory", 10));
        this.timeBeingRescued = tag.m_128451_("TimeBeingRescued");
        this.isBeingRescued = tag.m_128471_("IsBeingRescued");
        if (tag.m_128403_("Tempter")) {
            UUID uuid = tag.m_128342_("Tempter");
            this.setTempterUUID(uuid);
            this.hasTempter = true;
            PiglinPrisonerAi.reloadAllegiance(this, this.getTempter());
        }
    }

    protected void m_8024_() {
        this.f_19853_.m_46473_().m_6180_("piglinBrain");
        this.m_6274_().m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        this.f_19853_.m_46473_().m_7238_();
        PiglinPrisonerAi.updateActivity(this);
        this.timeBeingRescued = this.isBeingRescued ? ++this.timeBeingRescued : 0;
        if (this.timeBeingRescued > 75) {
            this.m_7580_();
            this.finishRescue();
        }
        super.m_8024_();
    }

    protected void m_7472_(DamageSource source, int rand, boolean doDrop) {
        super.m_7472_(source, rand, doDrop);
        this.inventory.m_19195_().forEach(arg_0 -> ((PiglinPrisoner)this).m_19983_(arg_0));
    }

    public void addToInventory(ItemStack stack) {
        this.inventory.m_19173_(stack);
    }

    public boolean canAddToInventory(ItemStack stack) {
        return this.inventory.m_19183_(stack);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_CHARGING_CROSSBOW, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_DANCING, (Object)false);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22281_, 6.0);
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6785_(double distanceToPlayer) {
        return !this.m_21532_();
    }

    protected Brain.Provider<PiglinPrisoner> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return PiglinPrisonerAi.makeBrain(this, (Brain<PiglinPrisoner>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<PiglinPrisoner> m_6274_() {
        return super.m_6274_();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult interactionresult = super.m_6071_(player, hand);
        if (interactionresult.m_19077_()) {
            return interactionresult;
        }
        if (!this.f_19853_.f_46443_) {
            return PiglinPrisonerAi.mobInteract(this, player, hand);
        }
        boolean flag = PiglinPrisonerAi.canAdmire(this, player.m_21120_(hand)) && this.m_6389_() != PiglinArmPose.ADMIRING_ITEM;
        return flag ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return this.m_6162_() ? 0.93f : 1.74f;
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.92;
    }

    public boolean m_6162_() {
        return false;
    }

    protected int m_6552_(Player player) {
        return this.f_21364_;
    }

    protected void m_8063_(ServerLevel serverLevel) {
        PiglinPrisonerAi.cancelAdmiring(this);
        this.inventory.m_19195_().forEach(arg_0 -> ((PiglinPrisoner)this).m_19983_(arg_0));
        super.m_8063_(serverLevel);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean bool) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING_CROSSBOW, (Object)bool);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_6504_(LivingEntity entity, float vel) {
        this.m_32336_((LivingEntity)this, 1.6f);
    }

    public void m_5811_(LivingEntity piglin, ItemStack itemstack, Projectile projectile, float vel) {
        this.m_32322_((LivingEntity)this, piglin, projectile, vel, 1.6f);
    }

    public boolean m_5886_(ProjectileWeaponItem item) {
        return item == Items.f_42717_;
    }

    public Container m_141944_() {
        return this.inventory;
    }

    protected boolean m_7121_() {
        return false;
    }

    public PiglinArmPose m_6389_() {
        if (this.isDancing()) {
            return PiglinArmPose.DANCING;
        }
        if (PiglinPrisonerAi.isLovedItem(this.m_21206_())) {
            return PiglinArmPose.ADMIRING_ITEM;
        }
        if (this.m_5912_() && this.m_34668_()) {
            return PiglinArmPose.ATTACKING_WITH_MELEE_WEAPON;
        }
        if (this.isChargingCrossbow()) {
            return PiglinArmPose.CROSSBOW_CHARGE;
        }
        return this.m_5912_() && this.m_21093_(is -> is.m_41720_() instanceof CrossbowItem) ? PiglinArmPose.CROSSBOW_HOLD : PiglinArmPose.DEFAULT;
    }

    public boolean isDancing() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_DANCING);
    }

    public void setDancing(boolean isDancing) {
        this.f_19804_.m_135381_(DATA_IS_DANCING, (Object)isDancing);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean flag = super.m_6469_(source, amount);
        if (this.f_19853_.f_46443_) {
            return false;
        }
        if (flag && source.m_7639_() instanceof LivingEntity) {
            PiglinPrisonerAi.wasHurtBy(this, (LivingEntity)source.m_7639_());
        }
        return flag;
    }

    public void holdInMainHand(ItemStack stack) {
        this.m_21468_(EquipmentSlot.MAINHAND, stack);
    }

    public void holdInOffHand(ItemStack stack) {
        if (stack.isPiglinCurrency()) {
            this.m_8061_(EquipmentSlot.OFFHAND, stack);
            this.m_21508_(EquipmentSlot.OFFHAND);
        } else {
            this.m_21468_(EquipmentSlot.OFFHAND, stack);
        }
    }

    public boolean m_7243_(ItemStack itemstack) {
        return ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) && this.m_21531_() && PiglinPrisonerAi.wantsToPickup(this, itemstack);
    }

    public boolean canReplaceCurrentItem(ItemStack replacementStack) {
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)replacementStack);
        ItemStack itemstack = this.m_6844_(equipmentslot);
        return this.m_7808_(replacementStack, itemstack);
    }

    protected boolean m_7808_(ItemStack newStack, ItemStack oldStack) {
        boolean flag1;
        if (EnchantmentHelper.m_44920_((ItemStack)oldStack)) {
            return false;
        }
        boolean flag = PiglinPrisonerAi.isLovedItem(newStack) || newStack.m_150930_(Items.f_42717_);
        boolean bl = flag1 = PiglinPrisonerAi.isLovedItem(oldStack) || oldStack.m_150930_(Items.f_42717_);
        if (flag && !flag1) {
            return true;
        }
        if (!flag && flag1) {
            return false;
        }
        return (!this.m_34667_() || newStack.m_150930_(Items.f_42717_) || !oldStack.m_150930_(Items.f_42717_)) && super.m_7808_(newStack, oldStack);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        this.m_21053_(itemEntity);
        PiglinPrisonerAi.pickUpItem(this, itemEntity);
    }

    protected SoundEvent m_7515_() {
        return this.f_19853_.f_46443_ ? null : (SoundEvent)PiglinPrisonerAi.getSoundForCurrentActivity(this).orElse(null);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12244_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12242_;
    }

    protected void m_7355_(BlockPos blockpos, BlockState blockstate) {
        this.m_5496_(SoundEvents.f_12299_, 0.15f, 1.0f);
    }

    public void playSound(SoundEvent sound) {
        this.m_5496_(sound, this.m_6121_(), this.m_6100_());
    }

    protected void m_7580_() {
        this.playSound(SoundEvents.f_12300_);
    }

    @Nullable
    public Player getTempter() {
        try {
            UUID uuid = this.getTempterUUID();
            return uuid == null ? null : this.f_19853_.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getTempterUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setTempterUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnHeartParticles() {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public void rescue() {
        PiglinPrisonerAi.startDancing(this);
        PiglinPrisonerAi.broadcastBeingRescued(this);
        CriteriaTriggers.f_10580_.m_68256_((ServerPlayer)this.getTempter(), (Entity)this);
        this.isBeingRescued = true;
    }

    protected void finishRescue() {
        PiglinPrisonerAi.throwItems(this, Collections.singletonList(new ItemStack((ItemLike)ModItems.GILDED_NETHERITE_SHIELD.get())));
        AbstractPiglin piglin = (AbstractPiglin)this.m_21406_((EntityType)((Supplier)((ModWeightedEntry)ModLists.PIGLIN_PRISONER_CONVERSIONS.m_146335_(this.f_19796_).get()).getData()).get(), true);
        if (piglin != null) {
            piglin.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)piglin);
        }
    }
}

