/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.block;

import com.izofar.bygonenether.entity.NetheriteBellBlockEntity;
import com.izofar.bygonenether.init.ModEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NetheriteBellBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<BellAttachType> ATTACHMENT = BlockStateProperties.f_61377_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final VoxelShape NORTH_SOUTH_FLOOR_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape EAST_WEST_FLOOR_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    private static final VoxelShape BELL_TOP_SHAPE = Block.m_49796_((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0);
    private static final VoxelShape BELL_BOTTOM_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    private static final VoxelShape BELL_SHAPE = Shapes.m_83110_((VoxelShape)BELL_BOTTOM_SHAPE, (VoxelShape)BELL_TOP_SHAPE);
    private static final VoxelShape NORTH_SOUTH_BETWEEN = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)7.0, (double)13.0, (double)0.0, (double)9.0, (double)15.0, (double)16.0));
    private static final VoxelShape EAST_WEST_BETWEEN = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)13.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_WEST = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)13.0, (double)7.0, (double)13.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_EAST = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)3.0, (double)13.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_NORTH = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)7.0, (double)13.0, (double)0.0, (double)9.0, (double)15.0, (double)13.0));
    private static final VoxelShape TO_SOUTH = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)7.0, (double)13.0, (double)3.0, (double)9.0, (double)15.0, (double)16.0));
    private static final VoxelShape CEILING_SHAPE = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));

    public NetheriteBellBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(ATTACHMENT, (Comparable)BellAttachType.FLOOR)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ATTACHMENT, POWERED});
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean bl = level.m_46753_(pos);
        if (bl != (Boolean)state.m_61143_((Property)POWERED)) {
            if (bl) {
                this.attemptToRing(level, pos, null);
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(bl)), 3);
        }
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        Entity entity = projectile.m_37282_();
        Player player = entity instanceof Player ? (Player)entity : null;
        this.onHit(level, state, hit, player, true);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.onHit(level, state, hit, player, true) ? InteractionResult.m_19078_((boolean)level.f_46443_) : InteractionResult.PASS;
    }

    public boolean onHit(Level level, BlockState state, BlockHitResult result, @Nullable Player player, boolean canRingBell) {
        boolean bl;
        Direction direction = result.m_82434_();
        BlockPos blockPos = result.m_82425_();
        boolean bl2 = bl = !canRingBell || this.isProperHit(state, direction, result.m_82450_().f_82480_ - (double)blockPos.m_123342_());
        if (bl) {
            boolean bl22 = this.attemptToRing((Entity)player, level, blockPos, direction);
            if (bl22 && player != null) {
                player.m_36220_(Stats.f_12979_);
            }
            return true;
        }
        return false;
    }

    private boolean isProperHit(BlockState pos, Direction direction, double distanceY) {
        if (direction.m_122434_() != Direction.Axis.Y && !(distanceY > (double)0.8124f)) {
            Direction direction2 = (Direction)pos.m_61143_((Property)FACING);
            BellAttachType bellAttachType = (BellAttachType)pos.m_61143_(ATTACHMENT);
            return switch (bellAttachType) {
                case BellAttachType.FLOOR -> {
                    if (direction2.m_122434_() == direction.m_122434_()) {
                        yield true;
                    }
                    yield false;
                }
                case BellAttachType.SINGLE_WALL, BellAttachType.DOUBLE_WALL -> {
                    if (direction2.m_122434_() != direction.m_122434_()) {
                        yield true;
                    }
                    yield false;
                }
                case BellAttachType.CEILING -> true;
                default -> false;
            };
        }
        return false;
    }

    public boolean attemptToRing(Level level, BlockPos pos, @Nullable Direction direction) {
        return this.attemptToRing(null, level, pos, direction);
    }

    public boolean attemptToRing(@Nullable Entity entity, Level level, BlockPos pos, @Nullable Direction direction) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!level.f_46443_ && blockEntity instanceof NetheriteBellBlockEntity) {
            NetheriteBellBlockEntity bellBlockEntity = (NetheriteBellBlockEntity)blockEntity;
            if (direction == null) {
                direction = (Direction)level.m_8055_(pos).m_61143_((Property)FACING);
            }
            bellBlockEntity.onHit(direction);
            level.m_5594_(null, pos, SoundEvents.f_11699_, SoundSource.BLOCKS, 4.5f, 0.5f);
            level.m_142346_(entity, GameEvent.f_157792_, pos);
            return true;
        }
        return false;
    }

    private VoxelShape getVoxelShape(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BellAttachType bellAttachType = (BellAttachType)state.m_61143_(ATTACHMENT);
        if (bellAttachType == BellAttachType.FLOOR) {
            return direction != Direction.NORTH && direction != Direction.SOUTH ? EAST_WEST_FLOOR_SHAPE : NORTH_SOUTH_FLOOR_SHAPE;
        }
        if (bellAttachType == BellAttachType.CEILING) {
            return CEILING_SHAPE;
        }
        if (bellAttachType == BellAttachType.DOUBLE_WALL) {
            return direction != Direction.NORTH && direction != Direction.SOUTH ? EAST_WEST_BETWEEN : NORTH_SOUTH_BETWEEN;
        }
        if (direction == Direction.NORTH) {
            return TO_NORTH;
        }
        if (direction == Direction.SOUTH) {
            return TO_SOUTH;
        }
        return direction == Direction.EAST ? TO_EAST : TO_WEST;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        BlockPos blockPos = context.m_8083_();
        Level level = context.m_43725_();
        Direction.Axis axis = direction.m_122434_();
        if (axis == Direction.Axis.Y) {
            BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_(ATTACHMENT, (Comparable)(direction == Direction.DOWN ? BellAttachType.CEILING : BellAttachType.FLOOR))).m_61124_((Property)FACING, (Comparable)context.m_8125_());
            if (blockState.m_60710_((LevelReader)context.m_43725_(), blockPos)) {
                return blockState;
            }
        } else {
            boolean bl = axis == Direction.Axis.X && level.m_8055_(blockPos.m_142125_()).m_60783_((BlockGetter)level, blockPos.m_142125_(), Direction.EAST) && level.m_8055_(blockPos.m_142126_()).m_60783_((BlockGetter)level, blockPos.m_142126_(), Direction.WEST) || axis == Direction.Axis.Z && level.m_8055_(blockPos.m_142127_()).m_60783_((BlockGetter)level, blockPos.m_142127_(), Direction.SOUTH) && level.m_8055_(blockPos.m_142128_()).m_60783_((BlockGetter)level, blockPos.m_142128_(), Direction.NORTH);
            BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_61124_(ATTACHMENT, (Comparable)(bl ? BellAttachType.DOUBLE_WALL : BellAttachType.SINGLE_WALL));
            if (blockState.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) {
                return blockState;
            }
            boolean bl2 = level.m_8055_(blockPos.m_7495_()).m_60783_((BlockGetter)level, blockPos.m_7495_(), Direction.UP);
            if ((blockState = (BlockState)blockState.m_61124_(ATTACHMENT, (Comparable)(bl2 ? BellAttachType.FLOOR : BellAttachType.CEILING))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) {
                return blockState;
            }
        }
        return null;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        BellAttachType bellAttachType = (BellAttachType)state.m_61143_(ATTACHMENT);
        Direction direction2 = NetheriteBellBlock.getConnectedDirection(state).m_122424_();
        if (direction2 == direction && !state.m_60710_((LevelReader)level, currentPos) && bellAttachType != BellAttachType.DOUBLE_WALL) {
            return Blocks.f_50016_.m_49966_();
        }
        if (direction.m_122434_() == ((Direction)state.m_61143_((Property)FACING)).m_122434_()) {
            if (bellAttachType == BellAttachType.DOUBLE_WALL && !neighborState.m_60783_((BlockGetter)level, neighborPos, direction)) {
                return (BlockState)((BlockState)state.m_61124_(ATTACHMENT, (Comparable)BellAttachType.SINGLE_WALL)).m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            }
            if (bellAttachType == BellAttachType.SINGLE_WALL && direction2.m_122424_() == direction && neighborState.m_60783_((BlockGetter)level, neighborPos, (Direction)state.m_61143_((Property)FACING))) {
                return (BlockState)state.m_61124_(ATTACHMENT, (Comparable)BellAttachType.DOUBLE_WALL);
            }
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = NetheriteBellBlock.getConnectedDirection(state).m_122424_();
        return direction == Direction.UP ? Block.m_49863_((LevelReader)level, (BlockPos)pos.m_7494_(), (Direction)Direction.DOWN) : FaceAttachedHorizontalDirectionalBlock.m_53196_((LevelReader)level, (BlockPos)pos, (Direction)direction);
    }

    private static Direction getConnectedDirection(BlockState state) {
        return switch ((BellAttachType)state.m_61143_(ATTACHMENT)) {
            case BellAttachType.FLOOR -> Direction.UP;
            case BellAttachType.CEILING -> Direction.DOWN;
            default -> ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        };
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new NetheriteBellBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return NetheriteBellBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModEntityTypes.NETHERITE_BELL.get()), (BlockEntityTicker)(level.f_46443_ ? NetheriteBellBlockEntity::clientTick : NetheriteBellBlockEntity::serverTick));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

