/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.ConfiguredFeatureHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.MowzieStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.UmvuthanaGrovePieces;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class UmvuthanaGroveStructure
extends MowzieStructure<NoneFeatureConfiguration> {
    public UmvuthanaGroveStructure(Codec<NoneFeatureConfiguration> codec) {
        super(codec, ConfigHandler.COMMON.MOBS.UMVUTHI.generationConfig, ConfiguredFeatureHandler.UMVUTHI_BIOMES, UmvuthanaGroveStructure::generatePieces);
    }

    private static void generatePieces(StructurePiecesBuilder builder, PieceGenerator.Context<NoneFeatureConfiguration> pieceGenerator) {
        Rotation rotation = Rotation.values()[pieceGenerator.f_192708_().nextInt(Rotation.values().length)];
        int x = (pieceGenerator.f_192705_().f_45578_ << 4) + 7;
        int z = (pieceGenerator.f_192705_().f_45579_ << 4) + 7;
        BlockPos centerPos = new BlockPos(x, 1, z);
        ChunkGenerator generator = pieceGenerator.f_192703_();
        LevelHeightAccessor heightLimitView = pieceGenerator.f_192707_();
        WorldgenRandom random = pieceGenerator.f_192708_();
        int surfaceY = generator.m_142647_(centerPos.m_123341_(), centerPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        int oceanFloorY = generator.m_142647_(centerPos.m_123341_(), centerPos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, heightLimitView);
        if (oceanFloorY < surfaceY) {
            return;
        }
        BlockPos firepitPos = UmvuthanaGroveStructure.posToSurface(generator, centerPos, heightLimitView);
        builder.m_142679_((StructurePiece)new UmvuthanaGrovePieces.FirepitPiece(pieceGenerator.f_192704_(), Rotation.values()[random.nextInt(Rotation.values().length)], firepitPos));
        BlockPos offset = new BlockPos(0, 0, 9);
        offset = offset.m_7954_(rotation);
        BlockPos thronePos = UmvuthanaGroveStructure.posToSurface(generator, centerPos.m_141952_((Vec3i)offset), heightLimitView);
        UmvuthanaGrovePieces.addPiece(UmvuthanaGrovePieces.THRONE, pieceGenerator.f_192704_(), thronePos, rotation, (StructurePieceAccessor)builder, pieceGenerator.f_192708_());
        int numHouses = random.nextInt(2) + 2;
        block0: for (int i = 1; i <= numHouses; ++i) {
            for (int j = 0; j < 30; ++j) {
                float distance = random.nextInt(8) + 13;
                int angle = random.nextInt(360);
                BlockPos housePos = new BlockPos((double)centerPos.m_123341_() + (double)distance * Math.sin(Math.toRadians(angle)), 0.0, (double)centerPos.m_123343_() + (double)distance * Math.cos(Math.toRadians(angle)));
                int houseOceanFloorY = generator.m_142647_((housePos = UmvuthanaGroveStructure.posToSurface(generator, housePos, heightLimitView)).m_123341_(), housePos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, heightLimitView);
                if (houseOceanFloorY >= housePos.m_123342_() && UmvuthanaGroveStructure.startPlatform(generator, pieceGenerator.f_192704_(), builder, housePos, pieceGenerator.f_192708_())) continue block0;
            }
        }
        int numTrees = random.nextInt(3) + 2;
        block2: for (int i = 1; i <= numTrees; ++i) {
            for (int j = 0; j < 30; ++j) {
                int whichTree;
                StructurePiece tree;
                float distance = random.nextInt(14) + 13;
                int angle = random.nextInt(360);
                BlockPos treePos = new BlockPos((double)centerPos.m_123341_() + (double)distance * Math.sin(Math.toRadians(angle)), 0.0, (double)centerPos.m_123343_() + (double)distance * Math.cos(Math.toRadians(angle)));
                int treeOceanFloorY = generator.m_142647_((treePos = UmvuthanaGroveStructure.posToSurface(generator, treePos, heightLimitView)).m_123341_(), treePos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, heightLimitView);
                if (treeOceanFloorY >= treePos.m_123342_() && (tree = UmvuthanaGrovePieces.addPieceCheckBounds(UmvuthanaGrovePieces.TREES[whichTree = random.nextInt(UmvuthanaGrovePieces.TREES.length)], pieceGenerator.f_192704_(), treePos, Rotation.values()[random.nextInt(Rotation.values().length)], builder, pieceGenerator.f_192708_())) != null) continue block2;
            }
        }
        int numFirepits = random.nextInt(3) + 2;
        block4: for (int i = 1; i <= numFirepits; ++i) {
            for (int j = 1; j <= 10; ++j) {
                ResourceLocation whichPit;
                StructurePiece piece;
                int distance = random.nextInt(15) + 8;
                int angle = random.nextInt(360);
                BlockPos pitPos = new BlockPos((double)centerPos.m_123341_() + (double)distance * Math.sin(Math.toRadians(angle)), 0.0, (double)centerPos.m_123343_() + (double)distance * Math.cos(Math.toRadians(angle)));
                int pitOceanFloorY = generator.m_142647_((pitPos = UmvuthanaGroveStructure.posToSurface(generator, pitPos, heightLimitView)).m_123341_(), pitPos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, heightLimitView);
                if (pitOceanFloorY >= pitPos.m_123342_() && (piece = UmvuthanaGrovePieces.addPieceCheckBounds(whichPit = UmvuthanaGrovePieces.FIREPIT_SMALL[random.nextInt(UmvuthanaGrovePieces.FIREPIT_SMALL.length)], pieceGenerator.f_192704_(), pitPos, Rotation.values()[random.nextInt(Rotation.values().length)], builder, pieceGenerator.f_192708_())) != null) continue block4;
            }
        }
        int numStakes = random.nextInt(10) + 7;
        block6: for (int i = 1; i <= numStakes; ++i) {
            for (int j = 1; j <= 10; ++j) {
                ResourceLocation whichSpike;
                StructurePiece piece;
                int distance = random.nextInt(15) + 8;
                int angle = random.nextInt(360);
                BlockPos stakePos = new BlockPos((double)centerPos.m_123341_() + (double)distance * Math.sin(Math.toRadians(angle)), 0.0, (double)centerPos.m_123343_() + (double)distance * Math.cos(Math.toRadians(angle)));
                int stakeOceanFloorY = generator.m_142647_((stakePos = UmvuthanaGroveStructure.posToSurface(generator, stakePos, heightLimitView)).m_123341_(), stakePos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, heightLimitView);
                if (stakeOceanFloorY >= stakePos.m_123342_() && (piece = UmvuthanaGrovePieces.addPieceCheckBounds(whichSpike = UmvuthanaGrovePieces.SPIKES[random.nextInt(UmvuthanaGrovePieces.SPIKES.length)], pieceGenerator.f_192704_(), stakePos, Rotation.values()[random.nextInt(Rotation.values().length)], builder, pieceGenerator.f_192708_())) != null) continue block6;
            }
        }
    }

    private static boolean startPlatform(ChunkGenerator generator, StructureManager templateManagerIn, StructurePiecesBuilder builder, BlockPos housePos, WorldgenRandom random) {
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        StructurePiece newPlatform = UmvuthanaGrovePieces.addPlatform(templateManagerIn, housePos, rotation, builder, random);
        return newPlatform != null;
    }

    private static BlockPos posToSurface(ChunkGenerator generator, BlockPos pos, LevelHeightAccessor heightAccessor) {
        int surfaceY = generator.m_142647_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor);
        return new BlockPos(pos.m_123341_(), surfaceY - 1, pos.m_123343_());
    }
}

