/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.ConfiguredFeatureHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.MowzieStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.jigsaw.MowzieJigsawManager;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;
import org.apache.logging.log4j.Level;

public class MonasteryStructure
extends MowzieStructure<JigsawConfiguration> {
    public static final Set<String> MUST_CONNECT_POOLS = Set.of("mowziesmobs:monastery/path_pool", "mowziesmobs:monastery/path_connector_pool");
    public static final Set<String> REPLACE_POOLS = Set.of("mowziesmobs:monastery/path_pool");
    public static final String STRAIGHT_POOL = "mowziesmobs:monastery/dead_end_connect_pool";
    private static final Lazy<List<MobSpawnSettings.SpawnerData>> STRUCTURE_MONSTERS = Lazy.of(() -> ImmutableList.of((Object)new MobSpawnSettings.SpawnerData(EntityType.f_20459_, 100, 4, 9), (Object)new MobSpawnSettings.SpawnerData(EntityType.f_20493_, 100, 4, 9)));
    private static final Lazy<List<MobSpawnSettings.SpawnerData>> STRUCTURE_CREATURES = Lazy.of(() -> ImmutableList.of((Object)new MobSpawnSettings.SpawnerData(EntityType.f_20520_, 30, 10, 15), (Object)new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 100, 1, 2)));

    public MonasteryStructure(Codec<JigsawConfiguration> codec) {
        super(codec, ConfigHandler.COMMON.MOBS.SCULPTOR.generationConfig, context -> MonasteryStructure.createPiecesGenerator(c -> MowzieStructure.checkLocation(c, ConfigHandler.COMMON.MOBS.SCULPTOR.generationConfig, ConfiguredFeatureHandler.SCULPTOR_BIOMES, true, true, true), (PieceGeneratorSupplier.Context<JigsawConfiguration>)context));
    }

    @Override
    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_DECORATION;
    }

    public static void setupStructureSpawns(StructureSpawnListGatherEvent event) {
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(Predicate<PieceGeneratorSupplier.Context<JigsawConfiguration>> canGeneratePredicate, PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        BlockPos blockpos;
        if (!canGeneratePredicate.test(context)) {
            return Optional.empty();
        }
        JigsawConfiguration newConfig = new JigsawConfiguration(Holder.m_205709_((Object)((StructureTemplatePool)context.f_197360_().m_206191_(Registry.f_122884_).m_7745_(new ResourceLocation("mowziesmobs", "monastery/start_pool")))), 23);
        PieceGeneratorSupplier.Context newContext = new PieceGeneratorSupplier.Context(context.f_197352_(), context.f_197353_(), context.f_197354_(), context.f_197355_(), (FeatureConfiguration)newConfig, context.f_197357_(), context.f_197358_(), context.f_197359_(), context.f_197360_());
        Optional<PieceGenerator<JigsawConfiguration>> structurePiecesGenerator = MowzieJigsawManager.addPieces((PieceGeneratorSupplier.Context<JigsawConfiguration>)newContext, PoolElementStructurePiece::new, blockpos = context.f_197355_().m_151394_(0), false, true, 140, "mowziesmobs:monastery/path", "mowziesmobs:monastery/interior", MUST_CONNECT_POOLS, REPLACE_POOLS, STRAIGHT_POOL);
        if (structurePiecesGenerator.isPresent()) {
            MowziesMobs.LOGGER.log(Level.DEBUG, "Monastery at " + blockpos);
        }
        return structurePiecesGenerator;
    }
}

