/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.tag.TagHandler;
import com.bobmowzie.mowziesmobs.server.world.BiomeChecker;
import com.bobmowzie.mowziesmobs.server.world.feature.FeatureHandler;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfiguredFeatureHandler {
    public static Holder<ConfiguredStructureFeature<?, ?>> CONFIGURED_WROUGHT_CHAMBER;
    public static Holder<ConfiguredStructureFeature<?, ?>> CONFIGURED_UMVUTHANA_GROVE;
    public static Holder<ConfiguredStructureFeature<?, ?>> CONFIGURED_FROSTMAW;
    public static Holder<ConfiguredStructureFeature<?, ?>> CONFIGURED_MONASTERY;
    public static Holder<StructureSet> WROUGHT_CHAMBERS;
    public static Holder<StructureSet> UMVUTHANA_GROVES;
    public static Holder<StructureSet> FROSTMAWS;
    public static Holder<StructureSet> MONASTERIES;
    public static final Set<ResourceLocation> FERROUS_WROUGHTNAUT_BIOMES;
    public static final Set<ResourceLocation> UMVUTHI_BIOMES;
    public static final Set<ResourceLocation> FROSTMAW_BIOMES;
    public static final Set<ResourceLocation> SCULPTOR_BIOMES;

    private static ResourceKey<ConfiguredStructureFeature<?, ?>> createFeatureKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122882_, (ResourceLocation)new ResourceLocation("mowziesmobs", name));
    }

    private static ResourceKey<StructureSet> createSetKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_211073_, (ResourceLocation)new ResourceLocation("mowziesmobs", name));
    }

    private static <FC extends FeatureConfiguration, F extends StructureFeature<FC>> Holder<ConfiguredStructureFeature<?, ?>> register(ResourceKey<ConfiguredStructureFeature<?, ?>> key, ConfiguredStructureFeature<FC, F> feature) {
        return BuiltinRegistries.m_206384_((Registry)BuiltinRegistries.f_123862_, key, feature);
    }

    static Holder<StructureSet> register(ResourceKey<StructureSet> key, StructureSet set) {
        return BuiltinRegistries.m_206384_((Registry)BuiltinRegistries.f_211084_, key, (Object)set);
    }

    static Holder<StructureSet> register(ResourceKey<StructureSet> key, Holder<ConfiguredStructureFeature<?, ?>> configuredFeature, StructurePlacement placement) {
        return ConfiguredFeatureHandler.register(key, new StructureSet(configuredFeature, placement));
    }

    public static void registerConfiguredFeatures() {
        CONFIGURED_WROUGHT_CHAMBER = ConfiguredFeatureHandler.register(ConfiguredFeatureHandler.createFeatureKey("wrought_chamber"), ((StructureFeature)FeatureHandler.WROUGHTNAUT_CHAMBER.get()).m_209762_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_, TagHandler.HAS_MOWZIE_STRUCTURE));
        CONFIGURED_UMVUTHANA_GROVE = ConfiguredFeatureHandler.register(ConfiguredFeatureHandler.createFeatureKey("umvuthana_grove"), ((StructureFeature)FeatureHandler.UMVUTHANA_GROVE.get()).m_209762_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_, TagHandler.HAS_MOWZIE_STRUCTURE));
        CONFIGURED_FROSTMAW = ConfiguredFeatureHandler.register(ConfiguredFeatureHandler.createFeatureKey("frostmaw_spawn"), ((StructureFeature)FeatureHandler.FROSTMAW.get()).m_209769_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_, TagHandler.HAS_MOWZIE_STRUCTURE, true));
        WROUGHT_CHAMBERS = ConfiguredFeatureHandler.register(ConfiguredFeatureHandler.createSetKey("wrought_chambers"), CONFIGURED_WROUGHT_CHAMBER, (StructurePlacement)new RandomSpreadStructurePlacement(32, 8, RandomSpreadType.TRIANGULAR, 23217347));
        UMVUTHANA_GROVES = ConfiguredFeatureHandler.register(ConfiguredFeatureHandler.createSetKey("umvuthana_groves"), CONFIGURED_UMVUTHANA_GROVE, (StructurePlacement)new RandomSpreadStructurePlacement(32, 8, RandomSpreadType.TRIANGULAR, 23311138));
        FROSTMAWS = ConfiguredFeatureHandler.register(ConfiguredFeatureHandler.createSetKey("frostmaw_spawns"), CONFIGURED_FROSTMAW, (StructurePlacement)new RandomSpreadStructurePlacement(32, 8, RandomSpreadType.TRIANGULAR, 23317578));
    }

    public static void onBiomeLoading(BiomeLoadingEvent event) {
        ResourceLocation biomeName = event.getName();
        if (biomeName == null) {
            return;
        }
        ResourceKey biomeKey = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)biomeName);
        if ((Integer)ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig.generationDistance.get() >= 0 && BiomeChecker.isBiomeInConfig(ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig.biomeConfig, (ResourceKey<Biome>)biomeKey)) {
            FERROUS_WROUGHTNAUT_BIOMES.add(biomeName);
        }
        if ((Integer)ConfigHandler.COMMON.MOBS.UMVUTHI.generationConfig.generationDistance.get() >= 0 && BiomeChecker.isBiomeInConfig(ConfigHandler.COMMON.MOBS.UMVUTHI.generationConfig.biomeConfig, (ResourceKey<Biome>)biomeKey)) {
            UMVUTHI_BIOMES.add(biomeName);
        }
        if ((Integer)ConfigHandler.COMMON.MOBS.FROSTMAW.generationConfig.generationDistance.get() >= 0 && BiomeChecker.isBiomeInConfig(ConfigHandler.COMMON.MOBS.FROSTMAW.generationConfig.biomeConfig, (ResourceKey<Biome>)biomeKey)) {
            FROSTMAW_BIOMES.add(biomeName);
        }
    }

    static {
        FERROUS_WROUGHTNAUT_BIOMES = new HashSet<ResourceLocation>();
        UMVUTHI_BIOMES = new HashSet<ResourceLocation>();
        FROSTMAW_BIOMES = new HashSet<ResourceLocation>();
        SCULPTOR_BIOMES = new HashSet<ResourceLocation>();
    }
}

