/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleVanillaCloudExtended;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.entity.naga.EntityNaga;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityPoisonBall
extends EntityMagicEffect {
    private static final byte EXPLOSION_PARTICLES_ID = 69;
    public static float GRAVITY = 0.05f;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;

    public EntityPoisonBall(EntityType<? extends EntityPoisonBall> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityPoisonBall(EntityType<? extends EntityPoisonBall> type, Level worldIn, LivingEntity caster) {
        super(type, worldIn, caster);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        this.m_20334_(x * (double)velocity, y * (double)velocity, z * (double)velocity);
    }

    @Override
    public void m_8119_() {
        this.prevMotionX = this.m_20184_().f_82479_;
        this.prevMotionY = this.m_20184_().f_82480_;
        this.prevMotionZ = this.m_20184_().f_82481_;
        super.m_8119_();
        this.m_20256_(this.m_20184_().m_82492_(0.0, (double)GRAVITY, 0.0));
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_146922_(-((float)Mth.m_14136_((double)this.m_20184_().f_82479_, (double)this.m_20184_().f_82481_)) * 57.295776f);
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(1.0);
        if (!entitiesHit.isEmpty()) {
            for (LivingEntity entity : entitiesHit) {
                if (entity == this.caster || entity instanceof EntityNaga || !entity.m_6469_(DamageSource.m_19367_((Entity)this, (Entity)this.caster), 3.0f * ((Double)ConfigHandler.COMMON.MOBS.NAGA.combatConfig.attackMultiplier.get()).floatValue())) continue;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 80, 1, false, true));
            }
        }
        if (!this.f_19853_.m_45756_((Entity)this, this.m_142469_().m_82400_(0.1))) {
            this.explode();
        }
        if (this.f_19853_.f_46443_) {
            float scale = 1.0f;
            int steps = 4;
            double motionX = this.m_20184_().f_82479_;
            double motionY = this.m_20184_().f_82480_;
            double motionZ = this.m_20184_().f_82481_;
            for (int step = 0; step < steps; ++step) {
                double life;
                double value;
                double zSpeed;
                double ySpeed;
                double xSpeed;
                int i;
                double x = this.f_19854_ + (double)step * (this.m_20185_() - this.f_19854_) / (double)steps;
                double y = this.f_19855_ + (double)step * (this.m_20186_() - this.f_19855_) / (double)steps + (double)(this.m_20206_() / 2.0f);
                double z = this.f_19856_ + (double)step * (this.m_20189_() - this.f_19856_) / (double)steps;
                for (i = 0; i < 1; ++i) {
                    xSpeed = (double)scale * 0.02 * (double)(this.f_19796_.nextFloat() * 2.0f - 1.0f);
                    ySpeed = (double)scale * 0.02 * (double)(this.f_19796_.nextFloat() * 2.0f - 1.0f);
                    zSpeed = (double)scale * 0.02 * (double)(this.f_19796_.nextFloat() * 2.0f - 1.0f);
                    value = this.f_19796_.nextFloat() * 0.1f;
                    life = this.f_19796_.nextFloat() * 10.0f + 15.0f;
                    ParticleVanillaCloudExtended.spawnVanillaCloud(this.f_19853_, x - motionX * 0.5, y - motionY * 0.5, z - motionZ * 0.5, xSpeed, ySpeed, zSpeed, scale, 0.25 + value, 0.75 + value, 0.25 + value, 0.99, life);
                }
                for (i = 0; i < 2; ++i) {
                    xSpeed = (double)scale * 0.06 * (double)(this.f_19796_.nextFloat() * 2.0f - 1.0f);
                    ySpeed = (double)scale * 0.06 * (double)(this.f_19796_.nextFloat() * 2.0f - 1.0f);
                    zSpeed = (double)scale * 0.06 * (double)(this.f_19796_.nextFloat() * 2.0f - 1.0f);
                    value = this.f_19796_.nextFloat() * 0.1f;
                    life = this.f_19796_.nextFloat() * 5.0f + 10.0f;
                    AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.PIXEL.get()), x + xSpeed - motionX * 0.5, y + ySpeed - motionY * 0.5, z + zSpeed - motionZ * 0.5, xSpeed, ySpeed, zSpeed, true, 0.0, 0.0, 0.0, 0.0, scale * 3.0f, 0.07 + value, 0.25 + value, 0.07 + value, 1.0, 0.99, life * 0.9, false, true);
                }
                for (i = 0; i < 1; ++i) {
                    if (!(this.f_19796_.nextFloat() < 0.9f)) continue;
                    xSpeed = (double)scale * 0.06 * (double)(this.f_19796_.nextFloat() * 2.0f - 1.0f);
                    ySpeed = (double)scale * 0.06 * (double)(this.f_19796_.nextFloat() * 2.0f - 1.0f);
                    zSpeed = (double)scale * 0.06 * (double)(this.f_19796_.nextFloat() * 2.0f - 1.0f);
                    value = this.f_19796_.nextFloat() * 0.1f;
                    life = this.f_19796_.nextFloat() * 5.0f + 10.0f;
                    AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.BUBBLE.get()), x - motionX * 0.5, y - motionY * 0.5, z - motionZ * 0.5, xSpeed, ySpeed, zSpeed, true, 0.0, 0.0, 0.0, 0.0, 3.0, 0.25 + value, 0.75 + value, 0.25 + value, 1.0, 0.85, life, false, true);
                }
            }
        }
        if (this.f_19797_ > 50) {
            this.m_146870_();
        }
    }

    private void explode() {
        this.f_19853_.m_7605_((Entity)this, (byte)69);
        this.m_5496_((SoundEvent)MMSounds.ENTITY_NAGA_ACID_HIT.get(), 1.0f, 1.0f);
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(2.0);
        if (!entitiesHit.isEmpty()) {
            for (LivingEntity entity : entitiesHit) {
                if (entity == this.caster || entity instanceof EntityNaga || !entity.m_6469_(DamageSource.m_19367_((Entity)this, (Entity)this.caster), 3.0f * ((Double)ConfigHandler.COMMON.MOBS.NAGA.combatConfig.attackMultiplier.get()).floatValue())) continue;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 80, 0, false, true));
            }
        }
        this.m_146870_();
    }

    private void spawnExplosionParticles() {
        if (this.f_19853_.f_46443_) {
            double life;
            double value;
            Vec3 particlePos;
            int i;
            float explodeSpeed = 3.5f;
            for (i = 0; i < 26; ++i) {
                particlePos = new Vec3((double)this.f_19796_.nextFloat() * 0.25, 0.0, 0.0);
                particlePos = particlePos.m_82524_((float)((double)(this.f_19796_.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.m_82496_((float)((double)(this.f_19796_.nextFloat() * 2.0f) * Math.PI));
                value = this.f_19796_.nextFloat() * 0.1f;
                life = this.f_19796_.nextFloat() * 17.0f + 30.0f;
                ParticleVanillaCloudExtended.spawnVanillaCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), particlePos.f_82479_ * (double)explodeSpeed, particlePos.f_82480_ * (double)explodeSpeed, particlePos.f_82481_ * (double)explodeSpeed, 1.0, 0.25 + value, 0.75 + value, 0.25 + value, 0.6, life);
            }
            for (i = 0; i < 26; ++i) {
                particlePos = new Vec3((double)this.f_19796_.nextFloat() * 0.25, 0.0, 0.0);
                particlePos = particlePos.m_82524_((float)((double)(this.f_19796_.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.m_82496_((float)((double)(this.f_19796_.nextFloat() * 2.0f) * Math.PI));
                value = this.f_19796_.nextFloat() * 0.1f;
                life = this.f_19796_.nextFloat() * 5.0f + 10.0f;
                AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.PIXEL.get()), this.m_20185_() + particlePos.f_82479_, this.m_20186_() + particlePos.f_82480_, this.m_20189_() + particlePos.f_82481_, particlePos.f_82479_ * (double)explodeSpeed, particlePos.f_82480_ * (double)explodeSpeed, particlePos.f_82481_ * (double)explodeSpeed, true, 0.0, 0.0, 0.0, 0.0, 3.0, 0.07 + value, 0.25 + value, 0.07 + value, 1.0, 0.6, life * 0.95, false, true);
            }
            for (i = 0; i < 23; ++i) {
                particlePos = new Vec3((double)this.f_19796_.nextFloat() * 0.25, 0.0, 0.0);
                particlePos = particlePos.m_82524_((float)((double)(this.f_19796_.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.m_82496_((float)((double)(this.f_19796_.nextFloat() * 2.0f) * Math.PI));
                value = this.f_19796_.nextFloat() * 0.1f;
                life = this.f_19796_.nextFloat() * 10.0f + 20.0f;
                AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.BUBBLE.get()), this.m_20185_() + particlePos.f_82479_, this.m_20186_() + particlePos.f_82480_, this.m_20189_() + particlePos.f_82481_, particlePos.f_82479_ * (double)explodeSpeed, particlePos.f_82480_ * (double)explodeSpeed, particlePos.f_82481_ * (double)explodeSpeed, true, 0.0, 0.0, 0.0, 0.0, 3.0, 0.25 + value, 0.75 + value, 0.25 + value, 1.0, 0.6, life * 0.95, false, true);
            }
        }
    }

    public void m_7822_(byte id) {
        if (id == 69) {
            this.spawnExplosionParticles();
        } else {
            super.m_7822_(id);
        }
    }
}

