/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities.player.heliomancy;

import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoFirstPersonRenderer;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoRenderPlayer;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySuperNova;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthi;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class SupernovaAbility
extends PlayerAbility {
    private boolean leftClickDown;
    private boolean rightClickDown;
    private Vec3[] particleEmitter = new Vec3[1];

    public SupernovaAbility(AbilityType<Player, SupernovaAbility> abilityType, Player user) {
        super(abilityType, user, EntityUmvuthi.SupernovaAbility.SECTION_TRACK);
    }

    @Override
    public void start() {
        super.start();
        ((Player)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_SUPERNOVA_START.get(), 3.0f, 1.0f);
        this.playAnimation("supernova", false);
        if (this.getLevel().f_46443_) {
            this.heldItemMainHandVisualOverride = ItemStack.f_41583_;
            this.heldItemOffHandVisualOverride = ItemStack.f_41583_;
            this.firstPersonOffHandDisplay = PlayerAbility.HandDisplay.FORCE_RENDER;
            this.firstPersonMainHandDisplay = PlayerAbility.HandDisplay.FORCE_RENDER;
        }
    }

    @Override
    public boolean canUse() {
        if (this.getUser() != null && !((Player)this.getUser()).m_150109_().m_36056_().m_41619_()) {
            return false;
        }
        return ((Player)this.getUser()).m_21023_((MobEffect)EffectHandler.SUNS_BLESSING) && super.canUse();
    }

    @Override
    public void tickUsing() {
        super.tickUsing();
        if (this.getTicksInUse() < 84) {
            ((Player)this.getUser()).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 2, 4, false, false));
        }
        if (this.getTicksInUse() == 30) {
            ((Player)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_SUPERNOVA_BLACKHOLE.get(), 2.0f, 1.2f);
        }
        if (this.getTicksInUse() < 30) {
            List<LivingEntity> entities = this.getEntityLivingBaseNearby((LivingEntity)this.getUser(), 16.0, 16.0, 16.0, 16.0);
            for (LivingEntity inRange : entities) {
                if (inRange instanceof Player && ((Player)inRange).m_150110_().f_35934_) continue;
                Vec3 diff = inRange.m_20182_().m_82546_(((Player)this.getUser()).m_20182_().m_82520_(0.0, 3.0, 0.0));
                diff = diff.m_82541_().m_82490_(0.03);
                inRange.m_20256_(inRange.m_20184_().m_82546_(diff));
                if (!(inRange.m_20186_() < ((Player)this.getUser()).m_20186_() + 3.0)) continue;
                inRange.m_20256_(inRange.m_20184_().m_82520_(0.0, 0.075, 0.0));
            }
        }
        if (this.getLevel().f_46443_) {
            if (this.getUser() == Minecraft.m_91087_().f_91074_ && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
                geckoPlayer = GeckoPlayer.getGeckoPlayer((Player)this.getUser(), GeckoPlayer.Perspective.FIRST_PERSON);
                if (geckoPlayer != null) {
                    renderPlayer = (GeckoFirstPersonRenderer)geckoPlayer.getPlayerRenderer();
                    if (renderPlayer.particleEmitterRoot != null) {
                        this.particleEmitter[0] = renderPlayer.particleEmitterRoot;
                    }
                }
            } else {
                geckoPlayer = GeckoPlayer.getGeckoPlayer((Player)this.getUser(), GeckoPlayer.Perspective.THIRD_PERSON);
                if (geckoPlayer != null) {
                    renderPlayer = (GeckoRenderPlayer)geckoPlayer.getPlayerRenderer();
                    if (renderPlayer.particleEmitterRoot != null) {
                        this.particleEmitter[0] = ((Player)this.getUser()).m_20182_().m_82549_(renderPlayer.particleEmitterRoot).m_82520_(0.0, (double)(((Player)this.getUser()).m_20206_() / 2.0f + 0.3f), 0.0);
                    }
                }
            }
            EntityUmvuthi.SupernovaAbility.superNovaEffects(this, this.particleEmitter, this.getLevel());
        }
    }

    @Override
    protected void beginSection(AbilitySection section) {
        super.beginSection(section);
        if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE && !((Player)this.getUser()).f_19853_.f_46443_) {
            EntitySuperNova superNova = new EntitySuperNova((EntityType<? extends EntitySuperNova>)((EntityType)EntityHandler.SUPER_NOVA.get()), ((Player)this.getUser()).f_19853_, (LivingEntity)this.getUser(), ((Player)this.getUser()).m_20185_(), ((Player)this.getUser()).m_20186_() + (double)(((Player)this.getUser()).m_20206_() / 2.0f), ((Player)this.getUser()).m_20189_());
            ((Player)this.getUser()).f_19853_.m_7967_((Entity)superNova);
            MobEffectInstance sunsBlessingInstance = ((Player)this.getUser()).m_21124_((MobEffect)EffectHandler.SUNS_BLESSING);
            if (sunsBlessingInstance != null) {
                int duration = sunsBlessingInstance.m_19557_();
                ((Player)this.getUser()).m_21195_((MobEffect)EffectHandler.SUNS_BLESSING);
                int supernovaCost = (Integer)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SUNS_BLESSING.supernovaCost.get() * 60 * 20;
                if (duration - supernovaCost > 0) {
                    ((Player)this.getUser()).m_7292_(new MobEffectInstance((MobEffect)EffectHandler.SUNS_BLESSING, duration - supernovaCost, 0, false, false));
                }
            }
        }
    }

    @Override
    public void onLeftMouseDown(Player player) {
        super.onLeftMouseDown(player);
        if (player == this.getUser()) {
            this.leftClickDown = true;
        }
    }

    @Override
    public void onLeftMouseUp(Player player) {
        super.onLeftMouseUp(player);
        if (player == this.getUser()) {
            this.leftClickDown = false;
        }
    }

    @Override
    public void onRightMouseDown(Player player) {
        super.onRightMouseDown(player);
        if (player == this.getUser()) {
            this.rightClickDown = true;
        }
    }

    @Override
    public void onRightMouseUp(Player player) {
        super.onRightMouseUp(player);
        if (player == this.getUser()) {
            this.rightClickDown = false;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (((Player)this.getUser()).m_6144_() && this.rightClickDown && this.leftClickDown) {
            AbilityHandler.INSTANCE.sendAbilityMessage((Player)this.getUser(), AbilityHandler.SUPERNOVA_ABILITY);
        }
    }

    @Override
    public boolean canCancelActiveAbility() {
        Ability ability = this.getActiveAbility();
        return ability != null && (ability.getAbilityType() == AbilityHandler.SOLAR_FLARE_ABILITY || ability.getAbilityType() == AbilityHandler.SOLAR_BEAM_ABILITY) && ability.getTicksInUse() < 5;
    }
}

