/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderSunstrike
extends EntityRenderer<EntitySunstrike> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("mowziesmobs", "textures/effects/sunstrike.png");
    private static final Random RANDOMIZER = new Random(0L);
    private static final float TEXTURE_WIDTH = 256.0f;
    private static final float TEXTURE_HEIGHT = 32.0f;
    private static final float BEAM_MIN_U = 0.875f;
    private static final float BEAM_MAX_U = 1.0f;
    private static final float PIXEL_SCALE = 0.0625f;
    private static final int MAX_HEIGHT = 256;
    private static final float DRAW_FADE_IN_RATE = 2.0f;
    private static final float DRAW_FADE_IN_POINT = 0.5f;
    private static final float DRAW_OPACITY_MULTIPLER = 0.7f;
    private static final float RING_RADIUS = 1.6f;
    private static final int RING_FRAME_SIZE = 16;
    private static final int RING_FRAME_COUNT = 10;
    private static final int BREAM_FRAME_COUNT = 31;
    private static final float BEAM_DRAW_START_RADIUS = 2.0f;
    private static final float BEAM_DRAW_END_RADIUS = 0.25f;
    private static final float BEAM_STRIKE_RADIUS = 1.0f;
    private static final float LINGER_RADIUS = 1.2f;
    private static final float SCORCH_MIN_U = 0.75f;
    private static final float SCORCH_MAX_U = 0.8125f;
    private static final float SCORCH_MIN_V = 0.5f;
    private static final float SCORCH_MAX_V = 1.0f;

    public RenderSunstrike(EntityRendererProvider.Context mgr) {
        super(mgr);
    }

    public ResourceLocation getTextureLocation(EntitySunstrike entity) {
        return TEXTURE;
    }

    public void render(EntitySunstrike sunstrike, float entityYaw, float delta, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float maxY = (float)(256.0 - sunstrike.m_20186_());
        if (maxY < 0.0f) {
            return;
        }
        RANDOMIZER.setSeed(sunstrike.getVariant());
        boolean isLingering = sunstrike.isLingering(delta);
        boolean isStriking = sunstrike.isStriking(delta);
        matrixStackIn.m_85836_();
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(MMRenderType.getGlowingEffect(TEXTURE));
        if (isLingering) {
            this.drawScorch(sunstrike, delta, matrixStackIn, ivertexbuilder, packedLightIn);
        } else if (isStriking) {
            this.drawStrike(sunstrike, maxY, delta, matrixStackIn, ivertexbuilder, packedLightIn);
        }
        matrixStackIn.m_85849_();
    }

    private void drawScorch(EntitySunstrike sunstrike, float delta, PoseStack matrixStack, VertexConsumer builder, int packedLightIn) {
        Level world = sunstrike.m_20193_();
        double ex = sunstrike.f_19790_ + (sunstrike.m_20185_() - sunstrike.f_19790_) * (double)delta;
        double ey = sunstrike.f_19791_ + (sunstrike.m_20186_() - sunstrike.f_19791_) * (double)delta;
        double ez = sunstrike.f_19792_ + (sunstrike.m_20189_() - sunstrike.f_19792_) * (double)delta;
        int minX = Mth.m_14107_((double)(ex - (double)1.2f));
        int maxX = Mth.m_14107_((double)(ex + (double)1.2f));
        int minY = Mth.m_14107_((double)(ey - (double)1.2f));
        int maxY = Mth.m_14107_((double)ey);
        int minZ = Mth.m_14107_((double)(ez - (double)1.2f));
        int maxZ = Mth.m_14107_((double)(ez + (double)1.2f));
        float opacityMultiplier = (0.6f + RANDOMIZER.nextFloat() * 0.2f) * (float)world.m_46803_(new BlockPos(ex, ey, ez));
        byte mirrorX = (byte)(RANDOMIZER.nextBoolean() ? -1 : 1);
        byte mirrorZ = (byte)(RANDOMIZER.nextBoolean() ? -1 : 1);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)new BlockPos(minX, minY, minZ), (BlockPos)new BlockPos(maxX, maxY, maxZ))) {
            BlockState block = world.m_8055_(pos.m_7495_());
            if (block.m_60767_() == Material.f_76296_ || world.m_46803_(pos) <= 3) continue;
            this.drawScorchBlock(world, block, pos, ex, ey, ez, opacityMultiplier, mirrorX, mirrorZ, matrixStack, builder, packedLightIn);
        }
    }

    private void drawScorchBlock(Level world, BlockState block, BlockPos pos, double ex, double ey, double ez, float opacityMultiplier, byte mirrorX, byte mirrorZ, PoseStack matrixStack, VertexConsumer builder, int packedLightIn) {
        PoseStack.Pose matrixstack$entry = matrixStack.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_85861_();
        Matrix3f matrix3f = matrixstack$entry.m_85864_();
        if (block.m_60796_((BlockGetter)world, pos)) {
            int bx = pos.m_123341_();
            int by = pos.m_123342_();
            int bz = pos.m_123343_();
            float opacity = (float)((1.0 - (ey - (double)by) / 2.0) * (double)opacityMultiplier);
            if (opacity >= 0.0f) {
                if (opacity > 1.0f) {
                    opacity = 1.0f;
                }
                AABB aabb = block.m_60816_((BlockGetter)world, pos).m_83215_();
                float minX = (float)((double)bx + aabb.f_82288_ - ex);
                float maxX = (float)((double)bx + aabb.f_82291_ - ex);
                float y = (float)((double)by + aabb.f_82289_ - ey + 0.015625);
                float minZ = (float)((double)bz + aabb.f_82290_ - ez);
                float maxZ = (float)((double)bz + aabb.f_82293_ - ez);
                float minU = ((float)mirrorX * minX / 2.0f / 1.2f + 0.5f) * 0.0625f + 0.75f;
                float maxU = ((float)mirrorX * maxX / 2.0f / 1.2f + 0.5f) * 0.0625f + 0.75f;
                float minV = ((float)mirrorZ * minZ / 2.0f / 1.2f + 0.5f) * 0.5f + 0.5f;
                float maxV = ((float)mirrorZ * maxZ / 2.0f / 1.2f + 0.5f) * 0.5f + 0.5f;
                this.drawVertex(matrix4f, matrix3f, builder, minX, y, minZ, minU, minV, opacity, packedLightIn);
                this.drawVertex(matrix4f, matrix3f, builder, minX, y, maxZ, minU, maxV, opacity, packedLightIn);
                this.drawVertex(matrix4f, matrix3f, builder, maxX, y, maxZ, maxU, maxV, opacity, packedLightIn);
                this.drawVertex(matrix4f, matrix3f, builder, maxX, y, minZ, maxU, minV, opacity, packedLightIn);
            }
        }
    }

    private void drawStrike(EntitySunstrike sunstrike, float maxY, float delta, PoseStack matrixStack, VertexConsumer builder, int packedLightIn) {
        float opacity;
        float drawTime = sunstrike.getStrikeDrawTime(delta);
        float strikeTime = sunstrike.getStrikeDamageTime(delta);
        boolean drawing = sunstrike.isStrikeDrawing(delta);
        float f = opacity = drawing && drawTime < 0.5f ? drawTime * 2.0f : 1.0f;
        if (drawing) {
            opacity *= 0.7f;
        }
        this.drawRing(drawing, drawTime, strikeTime, opacity, matrixStack, builder, packedLightIn);
        matrixStack.m_85845_(new Quaternion(0.0f, -Minecraft.m_91087_().f_91063_.m_109153_().m_90590_(), 0.0f, true));
        this.drawBeam(drawing, drawTime, strikeTime, opacity, maxY, matrixStack, builder, packedLightIn);
    }

    private void drawRing(boolean drawing, float drawTime, float strikeTime, float opacity, PoseStack matrixStack, VertexConsumer builder, int packedLightIn) {
        int frame = (int)((drawing ? drawTime : strikeTime) * 11.0f);
        if (frame > 10) {
            frame = 10;
        }
        float minU = (float)(frame * 16) / 256.0f;
        float maxU = minU + 0.0625f;
        float minV = drawing ? 0.0f : 0.5f;
        float maxV = minV + 0.5f;
        float offset = 0.1f * (float)(frame % 2);
        PoseStack.Pose matrixstack$entry = matrixStack.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_85861_();
        Matrix3f matrix3f = matrixstack$entry.m_85864_();
        this.drawVertex(matrix4f, matrix3f, builder, -1.6f + offset, 0.0f, -1.6f + offset, minU, minV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -1.6f + offset, 0.0f, 1.6f + offset, minU, maxV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 1.6f + offset, 0.0f, 1.6f + offset, maxU, maxV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 1.6f + offset, 0.0f, -1.6f + offset, maxU, minV, opacity, packedLightIn);
    }

    private void drawBeam(boolean drawing, float drawTime, float strikeTime, float opacity, float maxY, PoseStack matrixStack, VertexConsumer builder, int packedLightIn) {
        int frame;
        int n = frame = drawing ? 0 : (int)(strikeTime * 32.0f);
        if (frame > 31) {
            frame = 31;
        }
        float radius = 1.0f;
        if (drawing) {
            radius = -1.75f * drawTime + 2.0f;
        }
        float minV = (float)frame / 32.0f;
        float maxV = (float)(frame + 1) / 32.0f;
        PoseStack.Pose matrixstack$entry = matrixStack.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_85861_();
        Matrix3f matrix3f = matrixstack$entry.m_85864_();
        this.drawVertex(matrix4f, matrix3f, builder, -radius, 0.0f, 0.0f, 0.875f, minV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -radius, maxY, 0.0f, 0.875f, maxV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, radius, maxY, 0.0f, 1.0f, maxV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, radius, 0.0f, 0.0f, 1.0f, minV, opacity, packedLightIn);
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        vertexBuilder.m_85982_(matrix, offsetX, offsetY, offsetZ).m_85950_(1.0f, 1.0f, 1.0f, 1.0f * alpha).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normals, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

