/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.screens.popup;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class YesNoPopup
extends Popup {
    private List<String> text;
    private AdvancedButton confirmButton;
    private AdvancedButton cancelButton;
    private int width;
    private Color color = new Color(76, 0, 128);
    private Consumer<Boolean> callback;

    public YesNoPopup(int width, @Nullable Color color, int backgroundAlpha, @Nullable Consumer<Boolean> callback, String ... text) {
        super(backgroundAlpha);
        this.setNotificationText(text);
        this.width = width;
        this.confirmButton = new AdvancedButton(0, 0, 100, 20, Locals.localize("popup.yesno.confirm", new String[0]), true, press -> {
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.accept(true);
            }
        });
        this.addButton(this.confirmButton);
        this.cancelButton = new AdvancedButton(0, 0, 100, 20, Locals.localize("popup.yesno.cancel", new String[0]), true, press -> {
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.accept(false);
            }
        });
        this.addButton(this.cancelButton);
        if (color != null) {
            this.color = color;
        }
        this.callback = callback;
        KeyboardHandler.addKeyPressedListener(this::onEnterPressed);
        KeyboardHandler.addKeyPressedListener(this::onEscapePressed);
    }

    @Override
    public void render(PoseStack matrix, int mouseX, int mouseY, Screen renderIn) {
        super.render(matrix, mouseX, mouseY, renderIn);
        if (this.isDisplayed()) {
            int i;
            int height = 50;
            for (i = 0; i < this.text.size(); ++i) {
                height += 10;
            }
            RenderSystem.m_69478_();
            YesNoPopup.m_93172_((PoseStack)matrix, (int)(renderIn.f_96543_ / 2 - this.width / 2), (int)(renderIn.f_96544_ / 2 - height / 2), (int)(renderIn.f_96543_ / 2 + this.width / 2), (int)(renderIn.f_96544_ / 2 + height / 2), (int)this.color.getRGB());
            RenderSystem.m_69461_();
            i = 0;
            for (String s : this.text) {
                YesNoPopup.m_93215_((PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (Component)new TextComponent(s), (int)(renderIn.f_96543_ / 2), (int)(renderIn.f_96544_ / 2 - height / 2 + 10 + i), (int)Color.WHITE.getRGB());
                i += 10;
            }
            this.confirmButton.setX(renderIn.f_96543_ / 2 - this.confirmButton.m_5711_() - 20);
            this.confirmButton.setY(renderIn.f_96544_ / 2 + height / 2 - this.confirmButton.m_93694_() - 5);
            this.cancelButton.setX(renderIn.f_96543_ / 2 + 20);
            this.cancelButton.setY(renderIn.f_96544_ / 2 + height / 2 - this.cancelButton.m_93694_() - 5);
            this.renderButtons(matrix, mouseX, mouseY);
        }
    }

    public void setNotificationText(String ... text) {
        if (text != null) {
            ArrayList<String> l = new ArrayList<String>();
            for (String s : text) {
                if (s.contains("%n%")) {
                    for (String s2 : s.split("%n%")) {
                        l.add(s2);
                    }
                    continue;
                }
                l.add(s);
            }
            this.text = l;
        }
    }

    public void onEnterPressed(KeyboardData d) {
        if (d.keycode == 257 && this.isDisplayed()) {
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.accept(true);
            }
        }
    }

    public void onEscapePressed(KeyboardData d) {
        if (d.keycode == 256 && this.isDisplayed()) {
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.accept(false);
            }
        }
    }
}

