/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.enchantlimiter;

import jackiecrazy.enchantlimiter.EnchantLimiter;
import jackiecrazy.enchantlimiter.LimiterConfig;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enchantlimiter", value={Dist.CLIENT})
public class ItemTooltipHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void tooltip(ItemTooltipEvent e) {
        if (e.getItemStack().m_41793_() || e.getItemStack().m_41792_() || e.getItemStack().m_41720_() instanceof EnchantedBookItem) {
            double used = EnchantLimiter.getUsedEnchantPoints(e.getItemStack());
            double total = EnchantLimiter.getTotalEnchantPoints(e.getItemStack());
            e.getToolTip().add(new TranslatableComponent("enchantlimiter.points", new Object[]{(Serializable)(used > total ? ChatFormatting.RED : "") + used + ChatFormatting.RESET + "/" + total}));
        }
        if (e.getItemStack().m_41720_() instanceof EnchantedBookItem) {
            if (Screen.m_96638_()) {
                ItemTooltipHandler.insertDescriptionTooltips(e.getToolTip(), e.getItemStack());
            } else {
                e.getToolTip().add(new TranslatableComponent("enchantlimiter.shift"));
            }
        }
    }

    private static void insertDescriptionTooltips(List<Component> tips, ItemStack stack) {
        Iterator enchants = EnchantmentHelper.m_44831_((ItemStack)stack).entrySet().iterator();
        block0: while (enchants.hasNext()) {
            Map.Entry entry = enchants.next();
            Enchantment enchant = (Enchantment)entry.getKey();
            ListIterator<Component> tooltips = tips.listIterator();
            while (tooltips.hasNext()) {
                Component component = tooltips.next();
                if (!(component instanceof TranslatableComponent) || !((TranslatableComponent)component).m_131328_().equals(enchant.m_44704_())) continue;
                LimiterConfig.EnchantInfo info = LimiterConfig.map.getOrDefault(enchant, LimiterConfig.DEFAULT);
                tooltips.add((Component)new TranslatableComponent("enchantlimiter.tip", new Object[]{info.getBase(), info.getIncrement(), entry.getValue(), EnchantLimiter.getRequiredEnchantPoints(enchant, (Integer)entry.getValue())}));
                if (!enchants.hasNext()) continue block0;
                tooltips.add((Component)new TextComponent(""));
                continue block0;
            }
        }
    }
}

