/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.enchantlimiter;

import jackiecrazy.enchantlimiter.LimiterConfig;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="enchantlimiter")
public class EnchantLimiter {
    public static final String MODID = "enchantlimiter";
    public static final String VERSION = "1.0.0";
    public static final Logger LOGGER = LogManager.getLogger((String)"enchantlimiter");

    public EnchantLimiter() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)LimiterConfig.CONFIG_SPEC);
    }

    public static double getTotalEnchantPoints(ItemStack stack) {
        double ret = (double)stack.getItemEnchantability() * LimiterConfig.pointsPerEnchantability + (double)LimiterConfig.basePoint;
        if (LimiterConfig.customItems.containsKey(stack.m_41720_())) {
            ret = LimiterConfig.customItems.get(stack.m_41720_()).getBase();
            ret += (double)stack.getItemEnchantability() * LimiterConfig.customItems.get(stack.m_41720_()).getIncrement();
        }
        if (stack.m_41782_()) {
            ret += stack.m_41783_().m_128459_("extraEnchantPoints");
        }
        return ret;
    }

    public static double getUsedEnchantPoints(ItemStack stack) {
        int ret = 0;
        for (Map.Entry e : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
            ret = (int)((double)ret + EnchantLimiter.getRequiredEnchantPoints((Enchantment)e.getKey(), (Integer)e.getValue()));
        }
        if ((double)Math.abs(ret - Math.round(ret)) < LimiterConfig.grain) {
            ret = Math.round(ret);
        }
        return ret;
    }

    public static double getRequiredEnchantPoints(Enchantment e, int i) {
        LimiterConfig.EnchantInfo ei = LimiterConfig.map.getOrDefault(e, LimiterConfig.DEFAULT);
        double ret = ei.getBase() + ei.getIncrement() * (double)i;
        if (Math.abs(ret - (double)Math.round(ret)) < LimiterConfig.grain) {
            ret = Math.round(ret);
        }
        return ret;
    }
}

