/*
 * Decompiled with CFR 0.152.
 */
package io.github.settingdust.dawncraftfixes.core;

import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.MethodRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ObscureTooltipsAPI10Transformer
implements ITransformer<MethodNode> {
    private static final Map<String, String> REMAPPER = new HashMap<String, String>(){
        {
            this.put("com/obscuria/obscureapi/ObscureAPI.addMod(Ljava/lang/String;Ljava/lang/String;)V", "collectionMod");
            this.put("com/obscuria/obscureapi/classes/IClassItem", "com/obscuria/obscureapi/world/classes/IClassItem");
            this.put("com/obscuria/obscureapi/classes/ObscureClass", "com/obscuria/obscureapi/world/classes/ObscureClass");
        }
    };

    @NotNull
    public MethodNode transform(MethodNode input, ITransformerVotingContext context) {
        if (input.name.equals("drawTooltip")) {
            for (AbstractInsnNode instruction : input.instructions) {
                if (!(instruction instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)instruction;
                if (!methodInsnNode.owner.equals("com/obscuria/obscureapi/utils/TextHelper") || !methodInsnNode.name.equals("component")) continue;
                methodInsnNode.desc = "(Ljava/lang/String;)Lnet/minecraft/network/chat/MutableComponent;";
            }
        }
        SimpleRemapper remapper = new SimpleRemapper(REMAPPER);
        MethodNode node = new MethodNode(input.access, input.name, input.desc, input.signature, (String[])input.exceptions.toArray(String[]::new));
        MethodRemapper methodRemapper = new MethodRemapper((MethodVisitor)node, (Remapper)remapper);
        input.accept((MethodVisitor)methodRemapper);
        return node;
    }

    @NotNull
    public TransformerVoteResult castVote(ITransformerVotingContext context) {
        return TransformerVoteResult.YES;
    }

    @NotNull
    public Set<ITransformer.Target> targets() {
        return Set.of(ITransformer.Target.targetMethod((String)"com.obscuria.obscuretooltips.ObscureTooltipsMod", (String)"<init>", (String)"()V"), ITransformer.Target.targetMethod((String)"com.obscuria.obscuretooltips.Resources", (String)"getType", (String)"(Lnet/minecraft/world/item/ItemStack;Lcom/obscuria/obscuretooltips/tooltips/Override;)Ljava/lang/String;"), ITransformer.Target.targetMethod((String)"com/obscuria/obscuretooltips/tooltips/TooltipRenderer", (String)"drawTooltip", (String)"(Lcom/mojang/blaze3d/vertex/PoseStack;Ljava/util/List;Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;II)V"));
    }
}

