/*
 * Decompiled with CFR 0.152.
 */
package io.github.settingdust.dawncraftfixes.core;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.util.CheckClassAdapter;
import org.slf4j.Logger;

public class HexereiBufferSourceTransformer
implements ITransformer<ClassNode> {
    public static final Logger LOGGER = LogUtils.getLogger();

    @NotNull
    public ClassNode transform(ClassNode input, ITransformerVotingContext context) {
        MethodNode method2;
        int i;
        String name = input.name;
        Set<String> methods = Set.of("renderItem", "drawPage", "drawLivingEntity", "lambda$drawLivingEntity$4", "drawEntity", "lambda$drawEntity$5", "drawPages", "drawBaseButtons", "drawItemInSlot", "drawSlot", "drawFluidInSlot", "drawFluid", "drawTiledSprite", "drawTextureWithMasking", "drawTooltipImage", "drawTooltipText", "drawBookmark", "drawImage", "drawTitle", "drawCharacter", "drawString");
        if (name.equals("net/joefoxe/hexerei/item/custom/HexereiBookItemRenderer")) {
            for (i = 0; i < input.methods.size(); ++i) {
                method2 = (MethodNode)input.methods.get(i);
                if (!method2.name.equals("renderTileStuff")) continue;
                HexereiBufferSourceTransformer.replaceCasts(method2, name);
                for (AbstractInsnNode instruction : method2.instructions) {
                    HexereiBufferSourceTransformer.replaceMethodInsnNode(method2, instruction, methods, name);
                }
            }
        }
        if (name.equals("net/joefoxe/hexerei/data/books/PageDrawing")) {
            for (i = 0; i < input.methods.size(); ++i) {
                method2 = (MethodNode)input.methods.get(i);
                method2.desc = method2.desc.replace("net/minecraft/client/renderer/MultiBufferSource$BufferSource", "net/minecraft/client/renderer/MultiBufferSource");
                for (LocalVariableNode localVariable : method2.localVariables) {
                    if (!localVariable.desc.equals("Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;")) continue;
                    localVariable.desc = "Lnet/minecraft/client/renderer/MultiBufferSource;";
                    LOGGER.debug("Replaced MultiBufferSource$BufferSource to MultiBufferSource for {} {} of {}#{}", new Object[]{localVariable.name, localVariable.desc, name, method2.name});
                }
                for (AbstractInsnNode instruction : method2.instructions) {
                    HexereiBufferSourceTransformer.replaceMethodInsnNode(method2, instruction, methods, name);
                    HexereiBufferSourceTransformer.replaceLambdaCalls(instruction, methods);
                }
            }
            ClassWriter writer = new ClassWriter(0);
            input.accept((ClassVisitor)writer);
            writer.visitSource(".transformer.out" + name + ".class", null);
        }
        if (name.equals("net/joefoxe/hexerei/tileentity/renderer/BookOfShadowsAltarRenderer")) {
            for (MethodNode method2 : input.methods) {
                if (!method2.name.equals("render")) continue;
                HexereiBufferSourceTransformer.replaceCasts(method2, name);
                for (AbstractInsnNode instruction : method2.instructions) {
                    HexereiBufferSourceTransformer.replaceMethodInsnNode(method2, instruction, methods, name);
                }
            }
        }
        CheckClassAdapter checkClassAdapter = new CheckClassAdapter(null);
        input.accept((ClassVisitor)checkClassAdapter);
        return input;
    }

    private static void replaceLambdaCalls(AbstractInsnNode instruction, Set<String> methods) {
        if (instruction instanceof InvokeDynamicInsnNode) {
            InvokeDynamicInsnNode dynamicInsnNode = (InvokeDynamicInsnNode)instruction;
            if (dynamicInsnNode.desc.contains("MultiBufferSource$BufferSource")) {
                Handle lambdaHandle;
                Object object;
                dynamicInsnNode.desc = dynamicInsnNode.desc.replace("MultiBufferSource$BufferSource", "MultiBufferSource");
                Handle bsm = dynamicInsnNode.bsm;
                if (bsm.getOwner().equals("java/lang/invoke/LambdaMetafactory") && (object = dynamicInsnNode.bsmArgs[1]) instanceof Handle && methods.contains((lambdaHandle = (Handle)object).getName())) {
                    dynamicInsnNode.bsmArgs[1] = new Handle(lambdaHandle.getTag(), lambdaHandle.getOwner(), lambdaHandle.getName(), lambdaHandle.getDesc().replace("MultiBufferSource$BufferSource", "MultiBufferSource"), lambdaHandle.isInterface());
                }
            }
        }
    }

    private static void replaceMethodInsnNode(MethodNode method, AbstractInsnNode instruction, Set<String> methods, String name) {
        if (instruction instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)instruction;
            HexereiBufferSourceTransformer.replaceMethodsDesc(methodInsnNode, methods, name, method);
            HexereiBufferSourceTransformer.replaceMethodsCalls(methodInsnNode);
        }
    }

    private static void replaceCasts(MethodNode method, String name) {
        for (AbstractInsnNode instruction : method.instructions) {
            TypeInsnNode typeInsnNode;
            if (!(instruction instanceof TypeInsnNode) || (typeInsnNode = (TypeInsnNode)instruction).getOpcode() != 192 || !typeInsnNode.desc.equals("net/minecraft/client/renderer/MultiBufferSource$BufferSource")) continue;
            method.instructions.remove(instruction);
            LOGGER.debug("Removed CHECKCAST of {} in {}#{}", new Object[]{typeInsnNode.desc, name, method.name});
        }
    }

    private static void replaceMethodsDesc(MethodInsnNode methodInsnNode, Set<String> methods, String name, MethodNode method) {
        if (methods.contains(methodInsnNode.name)) {
            methodInsnNode.desc = methodInsnNode.desc.replace("net/minecraft/client/renderer/MultiBufferSource$BufferSource", "net/minecraft/client/renderer/MultiBufferSource");
            LOGGER.debug("Replaced MultiBufferSource$BufferSource to MultiBufferSource for {}#{} {}{}", new Object[]{name, method.name, methodInsnNode.name, methodInsnNode.desc});
        }
    }

    private static void replaceMethodsCalls(MethodInsnNode methodInsnNode) {
        if (methodInsnNode.owner.equals("net/minecraft/client/renderer/MultiBufferSource$BufferSource") && methodInsnNode.name.equals("m_6299_")) {
            methodInsnNode.setOpcode(185);
            methodInsnNode.owner = "net/minecraft/client/renderer/MultiBufferSource";
            methodInsnNode.itf = true;
        }
    }

    @NotNull
    public TransformerVoteResult castVote(ITransformerVotingContext context) {
        return TransformerVoteResult.YES;
    }

    @NotNull
    public Set<ITransformer.Target> targets() {
        return Set.of(ITransformer.Target.targetClass((String)"net.joefoxe.hexerei.data.books.PageDrawing"), ITransformer.Target.targetClass((String)"net.joefoxe.hexerei.item.custom.HexereiBookItemRenderer"), ITransformer.Target.targetClass((String)"net.joefoxe.hexerei.tileentity.renderer.BookOfShadowsAltarRenderer"));
    }
}

