/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import tschipp.callablehorses.common.HorseManager;

public class PressKeyPacket {
    private int key;

    public PressKeyPacket() {
    }

    public PressKeyPacket(int key) {
        this.key = key;
    }

    public PressKeyPacket(FriendlyByteBuf buf) {
        this.key = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.key);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.setPacketHandled(true);
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                if (player != null) {
                    switch (this.key) {
                        case 0: {
                            HorseManager.callHorse((Player)player);
                            break;
                        }
                        case 1: {
                            HorseManager.setHorse((Player)player);
                            break;
                        }
                        case 2: {
                            HorseManager.showHorseStats(player);
                        }
                    }
                }
            });
        }
    }
}

