/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.network;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import tschipp.callablehorses.CallableHorses;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;
import tschipp.callablehorses.common.capabilities.storedhorse.StoredHorse;
import tschipp.callablehorses.common.helper.HorseHelper;

public class HorseCapSyncPacket {
    private int entityID = 0;
    private CompoundTag horseNBT = null;

    public HorseCapSyncPacket() {
    }

    public HorseCapSyncPacket(int entityID, IStoredHorse horse) {
        this.entityID = entityID;
        this.horseNBT = StoredHorse.writeNBT(horse);
    }

    public HorseCapSyncPacket(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.horseNBT = buf.m_130260_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.m_130079_(this.horseNBT);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.setPacketHandled(true);
            context.enqueueWork(() -> {
                Level world = CallableHorses.proxy.getWorld();
                Entity e = world.m_6815_(this.entityID);
                if (e != null) {
                    IStoredHorse horse = HorseHelper.getHorseCap(e);
                    StoredHorse.readNBT(horse, this.horseNBT);
                }
            });
        }
    }
}

