/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.loot;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;
import tschipp.callablehorses.common.helper.HorseHelper;

public class HorseDropModifier
extends LootModifier {
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> GLM = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.LOOT_MODIFIER_SERIALIZERS, (String)"callablehorses");
    public static final RegistryObject<Serializer> HORSE_DROP = GLM.register("horse_drop", Serializer::new);
    private LootItemCondition[] conditions;

    protected HorseDropModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
        this.conditions = conditionsIn;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        IStoredHorse horse;
        Entity entity;
        if (context.m_78936_(LootContextParams.f_81455_) && (entity = (Entity)context.m_78953_(LootContextParams.f_81455_)) instanceof AbstractHorse && (horse = HorseHelper.getHorseCap(entity)) != null && horse.isOwned()) {
            generatedLoot.clear();
        }
        return generatedLoot;
    }

    private static class Serializer
    extends GlobalLootModifierSerializer<HorseDropModifier> {
        private Serializer() {
        }

        public HorseDropModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] ailootcondition) {
            return new HorseDropModifier(ailootcondition);
        }

        public JsonObject write(HorseDropModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

