/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.events;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tschipp.callablehorses.CallableHorses;
import tschipp.callablehorses.common.HorseManager;
import tschipp.callablehorses.common.capabilities.horseowner.HorseOwner;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;
import tschipp.callablehorses.common.capabilities.storedhorse.StoredHorse;
import tschipp.callablehorses.common.config.Configs;
import tschipp.callablehorses.common.helper.HorseHelper;
import tschipp.callablehorses.common.worlddata.StoredHorsesWorldData;

@Mod.EventBusSubscriber(modid="callablehorses")
public class EntityEvents {
    @SubscribeEvent
    public static void onAttachCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("callablehorses", "horse_owner"), (ICapabilityProvider)new HorseOwner());
        }
        if (event.getObject() instanceof AbstractHorse) {
            event.addCapability(new ResourceLocation("callablehorses", "stored_horse"), (ICapabilityProvider)new StoredHorse());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity joiningEntity = event.getEntity();
        Level world = event.getWorld();
        if (!world.f_46443_) {
            IStoredHorse horse;
            if (joiningEntity instanceof Player) {
                Player player = (Player)joiningEntity;
                IHorseOwner owner = HorseHelper.getOwnerCap(player);
                String ownedHorse = owner.getStorageUUID();
                if (!ownedHorse.isEmpty()) {
                    StoredHorsesWorldData data = HorseHelper.getWorldData((ServerLevel)world);
                    if (data.wasKilled(ownedHorse)) {
                        data.clearKilled(ownedHorse);
                        if (((Boolean)Configs.SERVER.deathIsPermanent.get()).booleanValue()) {
                            owner.clearHorse();
                            player.m_5661_((Component)new TranslatableComponent("callablehorses.alert.offlinedeath").m_130940_(ChatFormatting.RED), false);
                        } else {
                            AbstractHorse deadHorse = owner.createHorseEntity(world);
                            HorseManager.prepDeadHorseForRespawning((Entity)deadHorse);
                            owner.setHorseNBT(deadHorse.serializeNBT());
                            owner.setLastSeenPosition(Vec3.f_82478_);
                        }
                    }
                    if (data.wasOfflineSaved(ownedHorse)) {
                        CompoundTag newNBT = data.getOfflineSavedHorse(ownedHorse);
                        owner.setHorseNBT(newNBT);
                        data.clearOfflineSavedHorse(ownedHorse);
                    }
                }
            } else if (joiningEntity instanceof AbstractHorse && (horse = HorseHelper.getHorseCap(joiningEntity)).isOwned()) {
                StoredHorsesWorldData data = HorseHelper.getWorldData((ServerLevel)world);
                int globalNum = HorseHelper.getHorseNum((ServerLevel)joiningEntity.f_19853_, horse.getStorageUUID());
                if (globalNum > horse.getHorseNum()) {
                    event.setCanceled(true);
                    CallableHorses.LOGGER.debug(joiningEntity + " was instantly despawned because its number is " + horse.getHorseNum() + " and the global num is " + globalNum);
                } else if (data.isDisbanded(horse.getStorageUUID())) {
                    HorseManager.clearHorse(horse);
                    data.clearDisbanded(horse.getStorageUUID());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player newPlayer = event.getPlayer();
        original.reviveCaps();
        IHorseOwner oldHorse = HorseHelper.getOwnerCap(original);
        IHorseOwner newHorse = HorseHelper.getOwnerCap(newPlayer);
        original.invalidateCaps();
        newHorse.setHorseNBT(oldHorse.getHorseNBT());
        newHorse.setHorseNum(oldHorse.getHorseNum());
        newHorse.setStorageUUID(oldHorse.getStorageUUID());
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
    }

    @SubscribeEvent
    public static void onEntityLeaveWorld(EntityLeaveWorldEvent event) {
        Level world = event.getWorld();
        if (!world.m_5776_()) {
            HorseManager.saveHorse(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onStopTracking(PlayerEvent.StopTracking event) {
        Player player = event.getPlayer();
        Level world = player.f_19853_;
        Entity e = event.getTarget();
        if (!world.f_46443_ && e.m_6084_()) {
            HorseManager.saveHorse(e);
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity target;
        Player player = event.getPlayer();
        if (!player.f_19853_.f_46443_ && (target = event.getTarget()) instanceof AbstractHorse) {
            HorseHelper.sendHorseUpdateToClient(target, player);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity e = event.getEntityLiving();
        if (e instanceof AbstractHorse && !e.f_19853_.f_46443_ && (((Boolean)Configs.SERVER.enableDebug.get()).booleanValue() || ((Boolean)Configs.SERVER.continuousAntiDupeChecking.get()).booleanValue())) {
            IStoredHorse horse = HorseHelper.getHorseCap((Entity)e);
            if (((Boolean)Configs.SERVER.enableDebug.get()).booleanValue()) {
                e.m_6593_((Component)new TextComponent("Is Owned: " + horse.isOwned() + ", Storage UUID: " + horse.getStorageUUID() + ", Horse Number: " + horse.getHorseNum() + ", Horse UUID: " + e.m_142081_()));
            }
            if (((Boolean)Configs.SERVER.continuousAntiDupeChecking.get()).booleanValue()) {
                int thisNum = horse.getHorseNum();
                int globalNum = HorseHelper.getHorseNum((ServerLevel)e.f_19853_, horse.getStorageUUID());
                if (globalNum > thisNum) {
                    e.m_146870_();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        IStoredHorse horse;
        Entity e = event.getEntity();
        if (!e.f_19853_.f_46443_ && e instanceof AbstractHorse && (horse = HorseHelper.getHorseCap(e)).isOwned()) {
            Player owner = HorseHelper.getPlayerFromUUID(horse.getOwnerUUID(), e.f_19853_);
            if (owner != null) {
                IHorseOwner horseOwner = HorseHelper.getOwnerCap(owner);
                if (((Boolean)Configs.SERVER.deathIsPermanent.get()).booleanValue()) {
                    horseOwner.clearHorse();
                    owner.m_5661_((Component)new TranslatableComponent("callablehorses.alert.death").m_130940_(ChatFormatting.RED), false);
                } else {
                    HorseManager.saveHorse(e);
                    AbstractHorse deadHorse = horseOwner.createHorseEntity(owner.f_19853_);
                    HorseManager.prepDeadHorseForRespawning((Entity)deadHorse);
                    horseOwner.setHorseNBT(deadHorse.serializeNBT());
                    horseOwner.setLastSeenPosition(Vec3.f_82478_);
                }
            } else {
                CallableHorses.LOGGER.debug(e + " was marked as killed.");
                e.f_19853_.m_142572_().m_129785_().forEach(serverworld -> HorseHelper.getWorldData(serverworld).markKilled(horse.getStorageUUID()));
            }
        }
    }
}

