/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.config;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Configs {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.BooleanValue enableDebug;
        public final ForgeConfigSpec.BooleanValue deathIsPermanent;
        public final ForgeConfigSpec.BooleanValue callableInEveryDimension;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> callableDimsWhitelist;
        public final ForgeConfigSpec.IntValue maxCallingDistance;
        public final ForgeConfigSpec.BooleanValue enableStatsViewer;
        public final ForgeConfigSpec.DoubleValue horseWalkRange;
        public final ForgeConfigSpec.DoubleValue horseWalkSpeed;
        public final ForgeConfigSpec.BooleanValue continuousAntiDupeChecking;
        public final ForgeConfigSpec.BooleanValue disableHorseDrops;
        public final ForgeConfigSpec.BooleanValue checkForSpace;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("settings");
            this.enableDebug = builder.comment("Enable debug mode (Developers only) WARNING! Will override all horse names!").define("enableDebug", false);
            this.deathIsPermanent = builder.comment("Personal Horses get deleted if they're killed").define("deathIsPermanent", true);
            this.callableInEveryDimension = builder.comment("If the horse can be called in every dimension").define("callableInEveryDimension", true);
            this.callableDimsWhitelist = builder.comment("Whitelist for dimensions where horses can be called. callableInEveryDimension needs to be false!").defineList("callableDimsWhitelist", List.of("minecraft:overworld"), obj -> obj instanceof String);
            this.maxCallingDistance = builder.comment("Maximum block distance from last horse where new horse can be called. Set to -1 to disable range.").defineInRange("maxCallingDistance", -1, -1, 30000000);
            this.enableStatsViewer = builder.comment("Enable/disable the horse stat viewer GUI").define("enableStatsViewer", true);
            this.horseWalkRange = builder.comment("Range in which the horse will not teleport, but walk to you. Set to 0 to force the horse to always teleport.").defineInRange("horseWalkRange", 30.0, 0.0, 64.0);
            this.horseWalkSpeed = builder.comment("Speed with which the horse walks when you call it. Vanilla horse walk speed is 1.2").defineInRange("horseWalkSpeed", 1.8, 0.0, 10.0);
            this.continuousAntiDupeChecking = builder.comment("Check against duplicate horses every game tick (20 times per second) instead of only on load. Only use this if you're experiencing problem with duplicate horses! THIS COULD CAUSE LAG!").define("continuousAntiDupeChecking", false);
            this.disableHorseDrops = builder.comment("Prevents personal horses from dropping items (like leather). This won't prevent armor or saddles from dropping. If this is disabled in combination with deathIsPermanent, it can become a really easy way to farm/duplicate leather, so keep that in mind.").define("disableHorseDrops", true);
            this.checkForSpace = builder.comment("If you need a 3x3x3 space to call your horse").define("checkForSpace", true);
            builder.pop();
        }
    }
}

