/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.helper.HorseHelper;

public class GuiStatViewer
extends Screen {
    private int xSize = 176;
    private int ySize = 138;
    private static final ResourceLocation TEXTURE = new ResourceLocation("callablehorses", "textures/gui/horse_stat_viewer.png");
    private IHorseOwner owner;
    private AbstractHorse horse;
    private float speed;
    private float jumpHeight;
    private float health;
    private float maxHealth;
    private Vec3 lastPos;
    private ResourceKey<Level> lastDim;
    private static Method setColor = ObfuscationReflectionHelper.findMethod(Llama.class, (String)"setSwag", (Class[])new Class[]{DyeColor.class});
    private Minecraft mc = Minecraft.m_91087_();

    public GuiStatViewer(Player player) {
        super((Component)new TextComponent("Horse Stat Viewer"));
        this.owner = HorseHelper.getOwnerCap(player);
        this.horse = this.owner.createHorseEntity(player.f_19853_);
        this.horse.m_21204_().m_22168_(this.owner.getHorseNBT().m_128437_("Attributes", 10));
        this.horse.m_20258_(this.owner.getHorseNBT());
        LazyOptional cap = this.horse.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        cap.ifPresent(horseInventory -> {
            if (horseInventory.getStackInSlot(0).m_41619_() && this.horse.m_6741_()) {
                this.horse.m_5853_(null);
            }
            if (this.horse instanceof Llama && setColor != null) {
                try {
                    ItemStack stack = horseInventory.getStackInSlot(1);
                    if (this.horse.m_6010_(stack)) {
                        BlockItem blockItem;
                        Block patt3104$temp;
                        Item item = stack.m_41720_();
                        if (item instanceof BlockItem && (patt3104$temp = (blockItem = (BlockItem)item).m_40614_()) instanceof WoolCarpetBlock) {
                            WoolCarpetBlock carpet = (WoolCarpetBlock)patt3104$temp;
                            setColor.invoke((Object)this.horse, carpet.m_58309_());
                        }
                    } else {
                        setColor.invoke((Object)this.horse, new Object[]{null});
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
        this.health = (float)Math.floor(this.horse.m_21223_());
        this.maxHealth = (float)(Math.floor(this.horse.m_21233_() * 10.0f) / 10.0);
        this.speed = (float)(Math.floor(this.horse.m_21051_(Attributes.f_22279_).m_22135_() * 100.0) / 10.0);
        this.jumpHeight = (float)(Math.floor(this.horse.m_30626_() * 100.0) / 10.0);
        this.lastPos = this.owner.getLastSeenPosition();
        this.lastDim = this.owner.getLastSeenDim();
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int i = (this.f_96543_ - this.xSize) / 2;
        int j = (this.f_96544_ - this.ySize) / 2;
        GuiComponent.m_93133_((PoseStack)stack, (int)i, (int)j, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)256, (int)256);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        InventoryScreen.m_98850_((int)(i + 43), (int)(j + 68), (int)25, (float)((float)(i + 51) - (float)mouseX), (float)((float)(j + 75 - 50) - (float)mouseY), (LivingEntity)this.horse);
        GuiComponent.m_93243_((PoseStack)stack, (Font)this.mc.f_91062_, (Component)this.horse.m_7755_(), (int)(i + 84), (int)(j + 10), (int)DyeColor.WHITE.m_41071_());
        GuiComponent.m_93236_((PoseStack)stack, (Font)this.mc.f_91062_, (String)"Health:", (int)(i + 84), (int)(j + 30), (int)DyeColor.LIGHT_GRAY.m_41071_());
        GuiComponent.m_93236_((PoseStack)stack, (Font)this.mc.f_91062_, (String)(this.health + "/" + this.maxHealth), (int)(i + 120), (int)(j + 30), (int)DyeColor.WHITE.m_41071_());
        GuiComponent.m_93236_((PoseStack)stack, (Font)this.mc.f_91062_, (String)"Speed:", (int)(i + 84), (int)(j + 45), (int)DyeColor.LIGHT_GRAY.m_41071_());
        GuiComponent.m_93236_((PoseStack)stack, (Font)this.mc.f_91062_, (String)("" + this.speed), (int)(i + 120), (int)(j + 45), (int)DyeColor.WHITE.m_41071_());
        GuiComponent.m_93236_((PoseStack)stack, (Font)this.mc.f_91062_, (String)"Jump Height:", (int)(i + 84), (int)(j + 60), (int)DyeColor.LIGHT_GRAY.m_41071_());
        GuiComponent.m_93236_((PoseStack)stack, (Font)this.mc.f_91062_, (String)("" + this.jumpHeight), (int)(i + 148), (int)(j + 60), (int)DyeColor.WHITE.m_41071_());
        GuiComponent.m_93236_((PoseStack)stack, (Font)this.mc.f_91062_, (String)"Last known position:", (int)(i + 8), (int)(j + 84), (int)DyeColor.LIGHT_GRAY.m_41071_());
        GuiComponent.m_93236_((PoseStack)stack, (Font)this.mc.f_91062_, (String)(this.lastPos.equals((Object)Vec3.f_82478_) ? "Unknown" : "xyz = " + this.lastPos.m_7096_() + " " + this.lastPos.m_7098_() + " " + this.lastPos.m_7094_()), (int)(i + 8), (int)(j + 94), (int)DyeColor.WHITE.m_41071_());
        GuiComponent.m_93236_((PoseStack)stack, (Font)this.mc.f_91062_, (String)"Last known dimension:", (int)(i + 8), (int)(j + 110), (int)DyeColor.LIGHT_GRAY.m_41071_());
        GuiComponent.m_93236_((PoseStack)stack, (Font)this.mc.f_91062_, (String)this.lastDim.m_135782_().toString(), (int)(i + 8), (int)(j + 120), (int)DyeColor.WHITE.m_41071_());
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6913_() {
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.mc.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)modifiers))) {
            this.mc.f_91074_.m_6915_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

