/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.mixin.client;

import io.github.bumblesoftware.fastload.client.FLClientEvents;
import io.github.bumblesoftware.fastload.common.FLCommonEvents;
import io.github.bumblesoftware.fastload.util.obj_holders.MutableObjectHolder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    public abstract void m_91152_(@Nullable Screen var1);

    @Shadow
    protected abstract void m_91362_(Screen var1);

    @Inject(method={"setScreen"}, at={@At(value="HEAD")}, cancellable=true)
    private void setScreenEvent(Screen screen, CallbackInfo ci) {
        if (FLClientEvents.Events.SET_SCREEN_EVENT.isNotEmpty()) {
            FLClientEvents.Events.SET_SCREEN_EVENT.execute(new FLClientEvents.Contexts.SetScreenEventContext(screen, ci));
        }
    }

    @Inject(method={"runTick"}, at={@At(value="HEAD")})
    private void renderEvent(boolean tick, CallbackInfo ci) {
        if (FLCommonEvents.Events.BOOLEAN_EVENT.isNotEmpty("minecraft_client;render_tick;")) {
            FLCommonEvents.Events.BOOLEAN_EVENT.execute(List.of("minecraft_client;render_tick;"), new MutableObjectHolder<Boolean>(tick));
        }
    }

    @Redirect(method={"doLoadLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"))
    private void handle441Loading(Minecraft client, @Nullable Screen screen) {
        if (FLClientEvents.Events.SET_SCREEN_EVENT.isNotEmpty("level_loading_screen;441;redirect;")) {
            FLClientEvents.Events.SET_SCREEN_EVENT.execute(List.of("level_loading_screen;441;redirect;"), new FLClientEvents.Contexts.SetScreenEventContext(screen, null));
        } else {
            this.m_91152_(screen);
        }
    }

    @Redirect(method={"doLoadLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/server/IntegratedServer;isReady()Z"))
    private boolean handleServerWait(IntegratedServer integratedServer) {
        MutableObjectHolder<Boolean> returnValue = new MutableObjectHolder<Boolean>(integratedServer.m_129920_());
        if (FLCommonEvents.Events.SERVER_EVENT.isNotEmpty("minecraft_server;prepare_start_region;is_loading;redirect")) {
            FLCommonEvents.Events.SERVER_EVENT.execute(List.of("minecraft_server;prepare_start_region;is_loading;redirect"), new FLCommonEvents.Contexts.ServerContext<Boolean>((MinecraftServer)integratedServer, returnValue));
        }
        return (Boolean)returnValue.getHeldObj();
    }

    @Redirect(method={"setLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;updateScreenAndTick(Lnet/minecraft/client/gui/screens/Screen;)V"))
    private void handleProgressScreen(Minecraft client, Screen screen) {
        if (FLClientEvents.Events.SET_SCREEN_EVENT.isNotEmpty("minecraft_client;join_world;progress_screen;redirect")) {
            FLClientEvents.Events.SET_SCREEN_EVENT.execute(List.of("minecraft_client;join_world;progress_screen;redirect"), new FLClientEvents.Contexts.SetScreenEventContext(screen, null));
        } else {
            this.m_91362_(screen);
        }
    }
}

