/*
 * Decompiled with CFR 0.152.
 */
package reascer.infernal.skill.weaponpassive;

import java.util.Random;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import reascer.infernal.gameasset.InfernalAnimations;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class InfernalGainerPassiveSkill
extends PassiveSkill {
    public static final SkillDataManager.SkillDataKey<Integer> COMBO = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    public static final SkillDataManager.SkillDataKey<Boolean> FIRE_TRAIL = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    private static final UUID EVENT_UUID = UUID.fromString("bc38699e-0de8-11ed-861d-0242ac120002");

    public InfernalGainerPassiveSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getDataManager().registerData(COMBO);
        container.getDataManager().registerData(FIRE_TRAIL);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            StaticAnimation[] resetAnimations;
            for (StaticAnimation staticAnimation : resetAnimations = new StaticAnimation[]{InfernalAnimations.INFERNAL_AUTO_3_B, InfernalAnimations.INFERNAL_AUTO_3_B_CONTINUE_1, InfernalAnimations.INFERNAL_AUTO_3_B_CONTINUE_2, InfernalAnimations.INFERNAL_AUTO_3_B_CONTINUE_3, InfernalAnimations.INFERNAL_AUTO_3_B_CONTINUE_4, Animations.BIPED_HIT_LONG}) {
                if (event.getAnimation().equals((Object)staticAnimation)) continue;
                container.getDataManager().setDataSync(COMBO, (Object)0, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID, event -> {
            if (Math.abs(new Random().nextInt() % 100) < ((Boolean)container.getDataManager().getDataValue(FIRE_TRAIL) != false ? 70 : 10)) {
                event.getTarget().m_7311_(100);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.COMBO_COUNTER_HANDLE_EVENT, EVENT_UUID, event -> {
            if (event.getAnimation() != null && event.getAnimation().equals((Object)InfernalAnimations.INFERNAL_AUTO_4_B)) {
                event.setNextValue(0);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (event.getAnimation() != null && !event.getAnimation().equals((Object)InfernalAnimations.INFERNAL_FULLHOUSE)) {
                container.getDataManager().setDataSync(FIRE_TRAIL, (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.COMBO_COUNTER_HANDLE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    public boolean shouldDeactivateAutomatically(PlayerPatch<?> executer) {
        return true;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (((Boolean)container.getDataManager().getDataValue(FIRE_TRAIL)).booleanValue()) {
            for (int i = 0; i < 5; ++i) {
                ((Player)container.getExecuter().getOriginal()).m_183503_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, ((Player)container.getExecuter().getOriginal()).m_20185_() + (double)new Random().nextFloat(), ((Player)container.getExecuter().getOriginal()).m_20186_() + 1.0 + (double)new Random().nextFloat(), ((Player)container.getExecuter().getOriginal()).m_20189_() + (double)new Random().nextFloat(), 0.0, 0.0, 0.0);
            }
        }
    }
}

