/*
 * Decompiled with CFR 0.152.
 */
package reascer.infernal.gameasset;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import reascer.infernal.animation.BasicMultipleAttackAnimation;
import reascer.infernal.animation.PoopThrowingAttackAnimation;
import reascer.infernal.animation.SpecialAttackAnimation;
import reascer.infernal.gameasset.InfernalColliders;
import reascer.infernal.skill.weaponpassive.InfernalGainerPassiveSkill;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.GuardAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.forgeevent.AnimationRegistryEvent;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.TimePairList;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.skill.BasicAttack;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.ComboCounterHandleEvent;

@Mod.EventBusSubscriber(modid="infernal", bus=Mod.EventBusSubscriber.Bus.MOD)
public class InfernalAnimations {
    public static StaticAnimation INFERNAL_AUTO_1;
    public static StaticAnimation INFERNAL_AUTO_2;
    public static StaticAnimation INFERNAL_AUTO_3_A;
    public static StaticAnimation INFERNAL_AUTO_4_A;
    public static StaticAnimation INFERNAL_AUTO_3_B;
    public static StaticAnimation INFERNAL_AUTO_3_B_CONTINUE_1;
    public static StaticAnimation INFERNAL_AUTO_3_B_CONTINUE_2;
    public static StaticAnimation INFERNAL_AUTO_3_B_CONTINUE_3;
    public static StaticAnimation INFERNAL_AUTO_3_B_CONTINUE_4;
    public static StaticAnimation INFERNAL_AUTO_4_B;
    public static StaticAnimation INFERNAL_KCIK13;
    public static StaticAnimation INFERNAL_FULLHOUSE;
    public static StaticAnimation INFERNAL_SHORYUKEN;
    public static StaticAnimation INFERNAL_MAGMADOOKIE;
    public static StaticAnimation INFERNAL_IDLE;
    public static StaticAnimation INFERNAL_GUARD;
    public static StaticAnimation INFERNAL_GUARD_HIT;
    public static StaticAnimation INFERNAL_GUARD_PARRY;
    public static StaticAnimation INFERNAL_STRAIGHT_FLUSH;

    @SubscribeEvent
    public static void registerAnimations(AnimationRegistryEvent event) {
        event.getRegistryMap().put("infernal", InfernalAnimations::build);
    }

    private static void build() {
        HumanoidArmature biped = Armatures.BIPED;
        INFERNAL_AUTO_1 = new BasicMultipleAttackAnimation(0.1f, 0.3f, 0.4f, 0.5f, InfernalColliders.INFERNAL_PUNCH, biped.toolL, "biped/combat/infernal_auto_1", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)1.0f)).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)EpicFightParticles.HIT_BLUNT).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.4f));
        INFERNAL_AUTO_2 = new BasicMultipleAttackAnimation(0.2f, 0.1f, 0.2f, 0.25f, InfernalColliders.INFERNAL_PUNCH, biped.toolR, "biped/combat/infernal_auto_2", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)1.0f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)1.5f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)EpicFightParticles.HIT_BLUNT).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.4f)).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.45f, (entitypatch, self, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ((ServerPlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync(InfernalGainerPassiveSkill.COMBO, (Object)1, (ServerPlayer)entitypatch.getOriginal());
                ((ServerPlayerPatch)entitypatch).modifyLivingMotionByCurrentItem();
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
        INFERNAL_AUTO_3_A = new BasicMultipleAttackAnimation(0.05f, 0.35f, 0.45f, 0.5f, InfernalColliders.KICK_HUGE, biped.legL, "biped/combat/infernal_auto_3", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)1.0f)).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)EpicFightParticles.HIT_BLUNT).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.4f));
        INFERNAL_AUTO_4_A = new BasicMultipleAttackAnimation(0.25f, 0.3f, 0.4f, 0.75f, InfernalColliders.KICK_HUGE, biped.legR, "biped/combat/infernal_auto_4", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)1.0f)).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)EpicFightParticles.HIT_BLUNT).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.LONG).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.4f));
        INFERNAL_AUTO_3_B = new BasicMultipleAttackAnimation(0.05f, "biped/combat/infernal_auto_3_b", (Armature)biped, new AttackAnimation.Phase(0.0f, 0.4f, 0.45f, 0.49f, 0.49f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.49f, 0.5f, 0.55f, 0.59f, 0.59f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.59f, 0.6f, 0.65f, 0.69f, 0.69f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.69f, 0.7f, 0.75f, 0.79f, 0.79f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.79f, 0.8f, 0.85f, 0.85f, Float.MAX_VALUE, biped.legL, InfernalColliders.KICK_HUGE)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)0.3f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.3f), 1).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.3f), 2).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.3f), 3).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.3f), 4).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 1).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 2).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 3).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 4).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH, 1).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH, 2).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH, 3).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH, 4).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.8f)).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.4f, (entitypatch, self, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ((ServerPlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync(InfernalGainerPassiveSkill.COMBO, (Object)2, (ServerPlayer)entitypatch.getOriginal());
                ((ServerPlayerPatch)entitypatch).modifyLivingMotionByCurrentItem();
                BasicAttack.setComboCounterWithEvent((ComboCounterHandleEvent.Causal)ComboCounterHandleEvent.Causal.ACTION_ANIMATION_RESET, (ServerPlayerPatch)((ServerPlayerPatch)entitypatch), (SkillContainer)((ServerPlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.BASIC_ATTACK), (StaticAnimation)self, (int)0);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)1.0f, (entitypatch, self, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entitypatch;
                serverPlayerPatch.playAnimationSynchronized(INFERNAL_AUTO_4_B, 0.0f);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
        INFERNAL_AUTO_3_B_CONTINUE_1 = new BasicMultipleAttackAnimation(0.05f, "biped/combat/infernal_auto_3_b_continue", (Armature)biped, new AttackAnimation.Phase(0.0f, 0.0f, 0.05f, 0.09f, 0.09f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.09f, 0.1f, 0.15f, 0.19f, 0.19f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.19f, 0.2f, 0.25f, 0.25f, Float.MAX_VALUE, biped.legL, InfernalColliders.KICK_HUGE)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)0.3f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.3f), 1).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.3f), 2).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 1).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 2).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH, 1).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH, 2).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.8f)).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.0f, (entitypatch, self, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ((ServerPlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync(InfernalGainerPassiveSkill.COMBO, (Object)2, (ServerPlayer)entitypatch.getOriginal());
                ((ServerPlayerPatch)entitypatch).modifyLivingMotionByCurrentItem();
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)0.4f, (entitypatch, self, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entitypatch;
                serverPlayerPatch.playAnimationSynchronized(INFERNAL_AUTO_4_B, 0.0f);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
        INFERNAL_AUTO_3_B_CONTINUE_2 = new BasicMultipleAttackAnimation(0.05f, "biped/combat/infernal_auto_3_b_continue", (Armature)biped, new AttackAnimation.Phase(0.0f, 0.0f, 0.05f, 0.09f, 0.09f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.09f, 0.1f, 0.15f, 0.19f, 0.19f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.19f, 0.2f, 0.25f, 0.25f, Float.MAX_VALUE, biped.legL, InfernalColliders.KICK_HUGE)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)0.3f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.3f), 1).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.3f), 2).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 1).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 2).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH, 1).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH, 2).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.8f)).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.0f, (entitypatch, self, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ((ServerPlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync(InfernalGainerPassiveSkill.COMBO, (Object)2, (ServerPlayer)entitypatch.getOriginal());
                ((ServerPlayerPatch)entitypatch).modifyLivingMotionByCurrentItem();
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)0.4f, (entitypatch, self, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entitypatch;
                serverPlayerPatch.playAnimationSynchronized(INFERNAL_AUTO_4_B, 0.0f);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
        INFERNAL_AUTO_3_B_CONTINUE_3 = new BasicMultipleAttackAnimation(0.05f, "biped/combat/infernal_auto_3_b_continue", (Armature)biped, new AttackAnimation.Phase(0.0f, 0.0f, 0.05f, 0.09f, 0.09f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.09f, 0.1f, 0.15f, 0.19f, 0.19f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.19f, 0.2f, 0.25f, 0.25f, Float.MAX_VALUE, biped.legL, InfernalColliders.KICK_HUGE)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)0.3f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.3f), 1).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.3f), 2).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 1).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 2).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH, 1).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH, 2).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.8f)).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.0f, (entitypatch, self, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ((ServerPlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync(InfernalGainerPassiveSkill.COMBO, (Object)2, (ServerPlayer)entitypatch.getOriginal());
                ((ServerPlayerPatch)entitypatch).modifyLivingMotionByCurrentItem();
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)0.4f, (entitypatch, self, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entitypatch;
                serverPlayerPatch.playAnimationSynchronized(INFERNAL_AUTO_4_B, 0.0f);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
        INFERNAL_AUTO_3_B_CONTINUE_4 = new BasicMultipleAttackAnimation(0.05f, "biped/combat/infernal_auto_3_b_continue", (Armature)biped, new AttackAnimation.Phase(0.0f, 0.0f, 0.05f, 0.09f, 0.09f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.09f, 0.1f, 0.15f, 0.19f, 0.19f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.19f, 0.2f, 0.25f, 0.29f, 0.69f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.29f, 0.3f, 0.35f, 0.39f, 0.39f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.39f, 0.4f, 0.45f, 0.45f, Float.MAX_VALUE, biped.legL, InfernalColliders.KICK_HUGE)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)0.3f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.3f), 1).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.3f), 2).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.3f), 3).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.3f), 4).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 1).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 2).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 3).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 4).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH, 1).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH, 2).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH, 3).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH, 4).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.8f)).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.0f, (entitypatch, self, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ((ServerPlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync(InfernalGainerPassiveSkill.COMBO, (Object)2, (ServerPlayer)entitypatch.getOriginal());
                ((ServerPlayerPatch)entitypatch).modifyLivingMotionByCurrentItem();
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)0.45f, (entitypatch, self, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entitypatch;
                serverPlayerPatch.playAnimationSynchronized(INFERNAL_AUTO_4_B, 0.0f);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
        INFERNAL_AUTO_4_B = new BasicMultipleAttackAnimation(0.05f, "biped/combat/infernal_auto_4_b", (Armature)biped, new AttackAnimation.Phase(0.0f, 0.1f, 0.25f, 0.29f, 0.29f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.29f, 0.3f, 0.45f, 0.95f, Float.MAX_VALUE, biped.legR, InfernalColliders.KICK_HUGE)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, StunType.HOLD).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.LONG, 1).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)2.5f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)1.5f), 1).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)EpicFightSounds.WHOOSH, 1).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.8f)).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.05f, (entitypatch, self, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                ((ServerPlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync(InfernalGainerPassiveSkill.COMBO, (Object)0, (ServerPlayer)entitypatch.getOriginal());
                ((ServerPlayerPatch)entitypatch).modifyLivingMotionByCurrentItem();
                BasicAttack.setComboCounterWithEvent((ComboCounterHandleEvent.Causal)ComboCounterHandleEvent.Causal.ACTION_ANIMATION_RESET, (ServerPlayerPatch)((ServerPlayerPatch)entitypatch), (SkillContainer)((ServerPlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.BASIC_ATTACK), (StaticAnimation)self, (int)0);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
        INFERNAL_KCIK13 = new BasicMultipleAttackAnimation(0.05f, "biped/combat/infernal_kick13", (Armature)biped, new AttackAnimation.Phase(0.0f, 0.15f, 0.25f, 0.3f, 0.3f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.3f, 0.35f, 0.45f, 0.5f, 0.5f, biped.legR, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.5f, 0.55f, 0.65f, 0.7f, 0.7f, biped.legL, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.7f, 0.75f, 0.85f, 0.9f, 0.9f, biped.legR, InfernalColliders.KICK_HUGE), new AttackAnimation.Phase(0.9f, 1.05f, 1.15f, 1.8f, Float.MAX_VALUE, biped.legR, InfernalColliders.KICK_HUGE)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)0.25f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.25f), 1).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.25f), 2).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.25f), 3).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.5f), 4).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)0.8f), 4).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 1).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 2).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 3).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.LONG, 4).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.6f)).addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, (self, entitypatch, transformSheet) -> {
            LivingEntity attackTarget = entitypatch.getTarget();
            if (!self.getRealAnimation().getProperty((AnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE).orElse(false).booleanValue() && attackTarget != null) {
                TransformSheet transform = ((TransformSheet)self.getTransfroms().get("Root")).copyAll();
                Keyframe[] keyframes = transform.getKeyframes();
                int startFrame = 0;
                int endFrame = transform.getKeyframes().length - 1;
                Vec3f keyLast = keyframes[endFrame].transform().translation();
                Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).m_146892_();
                Vec3 targetpos = attackTarget.m_20182_();
                float horizontalDistance = Math.max((float)targetpos.m_82546_(pos).m_165924_() * 5.0f - (attackTarget.m_20205_() + ((LivingEntity)entitypatch.getOriginal()).m_20205_()) * 0.75f, 0.0f);
                Vec3f worldPosition = new Vec3f(keyLast.x, 0.0f, -horizontalDistance);
                float scale = Math.min(worldPosition.length() / keyLast.length(), 2.0f);
                for (int i = startFrame; i <= endFrame; ++i) {
                    Vec3f translation = keyframes[i].transform().translation();
                    translation.z *= scale * 1.2f;
                }
                transformSheet.readFrom(transform);
            } else {
                transformSheet.readFrom((TransformSheet)self.getTransfroms().get("Root"));
            }
        }).addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, (self, entitypatch, transformSheet) -> {
            LivingEntity attackTarget = entitypatch.getTarget();
            if (!self.getRealAnimation().getProperty((AnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE).orElse(false).booleanValue() && attackTarget != null) {
                TransformSheet transform = ((TransformSheet)self.getTransfroms().get("Root")).copyAll();
                Keyframe[] keyframes = transform.getKeyframes();
                int startFrame = 0;
                int endFrame = transform.getKeyframes().length - 1;
                Vec3f keyLast = keyframes[endFrame].transform().translation();
                Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).m_146892_();
                Vec3 targetpos = attackTarget.m_20182_();
                float horizontalDistance = Math.max((float)targetpos.m_82546_(pos).m_165924_() * 5.0f - (attackTarget.m_20205_() + ((LivingEntity)entitypatch.getOriginal()).m_20205_()) * 0.75f, 0.0f);
                Vec3f worldPosition = new Vec3f(keyLast.x, 0.0f, -horizontalDistance);
                float scale = Math.min(worldPosition.length() / keyLast.length(), 2.0f);
                for (int i = startFrame; i <= endFrame; ++i) {
                    Vec3f translation = keyframes[i].transform().translation();
                    translation.z *= scale * 1.2f;
                }
                transformSheet.readFrom(transform);
            } else {
                transformSheet.readFrom((TransformSheet)self.getTransfroms().get("Root"));
            }
        });
        INFERNAL_FULLHOUSE = new BasicMultipleAttackAnimation(0.05f, 0.3f, 0.5f, 0.65f, InfernalColliders.KICK_HUGE, biped.legR, "biped/combat/infernal_full_house", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)0.65f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)2.2f)).addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER, (Object)ValueModifier.multiplier((float)4.0f)).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)EpicFightParticles.HIT_BLUNT).addProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND, (Object)EpicFightSounds.BLUNT_HIT).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackAnimationProperty.EXTRA_COLLIDERS, (Object)20).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(2.0f)).addProperty(AnimationProperty.AttackAnimationProperty.ATTACK_SPEED_FACTOR, (Object)Float.valueOf(1.0f)).addProperty(AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE, (Object)true).addProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL, (Object)true).addProperty(AnimationProperty.ActionAnimationProperty.STOP_MOVEMENT, (Object)false).addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, (Object)false).addProperty(AnimationProperty.ActionAnimationProperty.NO_GRAVITY_TIME, (Object)TimePairList.create((float[])new float[]{0.0f, 0.3f})).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (self, entitypatch, speed, elapsedTime) -> {
            if (elapsedTime >= 0.35f && elapsedTime < 0.45f) {
                float dpx = (float)((LivingEntity)entitypatch.getOriginal()).m_20185_();
                float dpy = (float)((LivingEntity)entitypatch.getOriginal()).m_20186_();
                float dpz = (float)((LivingEntity)entitypatch.getOriginal()).m_20189_();
                BlockState block = ((LivingEntity)entitypatch.getOriginal()).f_19853_.m_8055_((BlockPos)new BlockPos.MutableBlockPos((double)dpx, (double)dpy, (double)dpz));
                while ((block.m_60734_() instanceof BushBlock || block.m_60795_()) && !block.m_60713_(Blocks.f_50626_)) {
                    block = ((LivingEntity)entitypatch.getOriginal()).f_19853_.m_8055_((BlockPos)new BlockPos.MutableBlockPos((double)dpx, (double)(dpy -= 1.0f), (double)dpz));
                }
                float distanceToGround = (float)Math.max(Math.abs(((LivingEntity)entitypatch.getOriginal()).m_20186_() - (double)dpy) - 1.0, 0.0);
                LivingEntity livingentity = (LivingEntity)entitypatch.getOriginal();
                Vec3f direction = new Vec3f(2.5f, -0.25f, 0.0f);
                OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(((LivingEntity)entitypatch.getOriginal()).f_20884_ + 90.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                AABB box = AABB.m_165882_((Vec3)((LivingEntity)entitypatch.getOriginal()).m_20318_(1.0f), (double)3.0, (double)3.0, (double)3.0);
                List list = ((LivingEntity)entitypatch.getOriginal()).f_19853_.m_45933_(entitypatch.getOriginal(), box);
                if (distanceToGround > 0.5f && list.size() == 0) {
                    livingentity.m_6478_(MoverType.SELF, direction.toDoubleVector());
                    return 0.05f;
                }
                return 1.0f;
            }
            return 1.0f;
        }).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.0f, (entitypatch, self, params) -> {
            if (entitypatch instanceof PlayerPatch) {
                ((PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync(InfernalGainerPassiveSkill.FIRE_TRAIL, (Object)true, (ServerPlayer)entitypatch.getOriginal());
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)0.5f, (entitypatch, self, params) -> {
            if (entitypatch instanceof PlayerPatch) {
                ((PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync(InfernalGainerPassiveSkill.FIRE_TRAIL, (Object)false, (ServerPlayer)entitypatch.getOriginal());
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)0.5f, (AnimationEvent.AnimationEventConsumer)ReuseableEvents.GROUND_BODYSCRAPE_LAND, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)});
        INFERNAL_MAGMADOOKIE = new PoopThrowingAttackAnimation(0.1f, 1.7f, 1.75f, 2.0f, InfernalColliders.INFERNAL_PUNCH, biped.toolR, "biped/skill/infernal_magmadookie", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.setter((float)18.0f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)1.5f)).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)EpicFightParticles.HIT_BLUNT).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.4f));
        INFERNAL_SHORYUKEN = new SpecialAttackAnimation(0.1f, 0.3f, 0.65f, 0.95f, InfernalColliders.INFERNAL_SHORYUKEN, biped.toolR, "biped/skill/infernal_shoryuken", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)2.0f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)1.25f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.FALL).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)EpicFightParticles.HIT_BLUNT).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.7f)).addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, (self, entitypatch, transformSheet) -> {
            LivingEntity attackTarget = entitypatch.getTarget();
            if (!self.getRealAnimation().getProperty((AnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE).orElse(false).booleanValue() && attackTarget != null) {
                TransformSheet transform = ((TransformSheet)self.getTransfroms().get("Root")).copyAll();
                Keyframe[] keyframes = transform.getKeyframes();
                int startFrame = 0;
                int endFrame = transform.getKeyframes().length - 1;
                Vec3f keyLast = keyframes[endFrame].transform().translation();
                Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).m_146892_();
                Vec3 targetpos = attackTarget.m_20182_();
                float horizontalDistance = Math.max((float)targetpos.m_82546_(pos).m_165924_() * 5.0f - (attackTarget.m_20205_() + ((LivingEntity)entitypatch.getOriginal()).m_20205_()) * 0.75f, 0.0f);
                Vec3f worldPosition = new Vec3f(keyLast.x, 0.0f, -horizontalDistance);
                float scale = Math.min(worldPosition.length() / keyLast.length(), 2.0f);
                for (int i = startFrame; i <= endFrame; ++i) {
                    Vec3f translation = keyframes[i].transform().translation();
                    translation.z *= scale * 1.2f;
                }
                transformSheet.readFrom(transform);
            } else {
                transformSheet.readFrom((TransformSheet)self.getTransfroms().get("Root"));
            }
        }).addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, (self, entitypatch, transformSheet) -> {
            LivingEntity attackTarget = entitypatch.getTarget();
            if (!self.getRealAnimation().getProperty((AnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE).orElse(false).booleanValue() && attackTarget != null) {
                TransformSheet transform = ((TransformSheet)self.getTransfroms().get("Root")).copyAll();
                Keyframe[] keyframes = transform.getKeyframes();
                int startFrame = 0;
                int endFrame = transform.getKeyframes().length - 1;
                Vec3f keyLast = keyframes[endFrame].transform().translation();
                Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).m_146892_();
                Vec3 targetpos = attackTarget.m_20182_();
                float horizontalDistance = Math.max((float)targetpos.m_82546_(pos).m_165924_() * 5.0f - (attackTarget.m_20205_() + ((LivingEntity)entitypatch.getOriginal()).m_20205_()) * 0.75f, 0.0f);
                Vec3f worldPosition = new Vec3f(keyLast.x, 0.0f, -horizontalDistance);
                float scale = Math.min(worldPosition.length() / keyLast.length(), 2.0f);
                for (int i = startFrame; i <= endFrame; ++i) {
                    Vec3f translation = keyframes[i].transform().translation();
                    translation.z *= scale * 1.2f;
                }
                transformSheet.readFrom(transform);
            } else {
                transformSheet.readFrom((TransformSheet)self.getTransfroms().get("Root"));
            }
        });
        INFERNAL_IDLE = new StaticAnimation(0.5f, true, "biped/living/infernal_idle", (Armature)biped);
        INFERNAL_GUARD = new StaticAnimation(0.05f, true, "biped/skill/infernal_guard", (Armature)biped);
        INFERNAL_GUARD_HIT = new GuardAnimation(0.05f, 0.2f, "biped/skill/infernal_guard_hit", (Armature)biped);
        INFERNAL_GUARD_PARRY = new GuardAnimation(0.05f, 0.0f, "biped/skill/infernal_guard_parry", (Armature)biped);
        INFERNAL_STRAIGHT_FLUSH = new BasicMultipleAttackAnimation(0.05f, 0.05f, 0.15f, 0.25f, InfernalColliders.INFERNAL_PUNCH, biped.toolR, "biped/skill/infernal_straight_flush", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)2.0f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)6.0f)).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)EpicFightParticles.HIT_BLUNT).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.KNOCKDOWN).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.4f));
    }

    public static Vec3 getfloor(LivingEntityPatch<?> entitypatch, StaticAnimation self, Vec3f WeaponOffset, Joint joint) {
        OpenMatrix4f transformMatrix = entitypatch.getArmature().getBindedTransformFor(entitypatch.getArmature().getPose(1.0f), joint);
        transformMatrix.translate(WeaponOffset);
        OpenMatrix4f CORRECTION = new OpenMatrix4f().rotate(-((float)Math.toRadians(((LivingEntity)entitypatch.getOriginal()).f_19859_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
        OpenMatrix4f.mul((OpenMatrix4f)CORRECTION, (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
        float dpx = transformMatrix.m30 + (float)((LivingEntity)entitypatch.getOriginal()).m_20185_();
        float dpy = transformMatrix.m31 + (float)((LivingEntity)entitypatch.getOriginal()).m_20186_();
        float dpz = transformMatrix.m32 + (float)((LivingEntity)entitypatch.getOriginal()).m_20189_();
        BlockState block = ((LivingEntity)entitypatch.getOriginal()).f_19853_.m_8055_(new BlockPos(new Vec3((double)dpx, (double)dpy, (double)dpz)));
        while ((block.m_60734_() instanceof BushBlock || block.m_60795_()) && !block.m_60713_(Blocks.f_50626_)) {
            block = ((LivingEntity)entitypatch.getOriginal()).f_19853_.m_8055_(new BlockPos(new Vec3((double)dpx, (double)(dpy -= 1.0f), (double)dpz)));
        }
        return new Vec3((double)dpx, (double)dpy, (double)dpz);
    }

    public static class ReuseableEvents {
        private static final AnimationEvent.AnimationEventConsumer GROUND_BODYSCRAPE_LAND = (entitypatch, self, params) -> {
            if (entitypatch instanceof PlayerPatch) {
                ((LivingEntity)entitypatch.getOriginal()).f_19853_.m_6269_((Player)entitypatch.getOriginal(), entitypatch.getOriginal(), EpicFightSounds.GROUND_SLAM, SoundSource.PLAYERS, 1.0f, 1.8f - (new Random().nextFloat() - 0.5f) * 0.2f);
            }
            Vec3 floorPos = InfernalAnimations.getfloor(entitypatch, self, new Vec3f(0.0f, 0.0f, 0.4f), Armatures.BIPED.rootJoint);
            ((LivingEntity)entitypatch.getOriginal()).f_19853_.m_7106_((ParticleOptions)EpicFightParticles.GROUND_SLAM.get(), floorPos.f_82479_, (double)((int)floorPos.f_82480_ + 1), floorPos.f_82481_, 0.5, 35.0, 0.5);
        };
    }
}

