/*
 * Decompiled with CFR 0.152.
 */
package com.command_block.libraryferret.conf;

import com.command_block.libraryferret.LibraryFerret;
import com.command_block.libraryferret.conf.Props;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraftforge.fml.loading.FMLPaths;

public class Configuration {
    private static final Map<String, Configuration> INSTANCES = new HashMap<String, Configuration>();
    private final String identifier;
    private final Properties properties;
    private final String propertiesPath;
    private final Map<String, Props> propsRegistre;

    private Configuration(String mod_id) {
        this.identifier = mod_id;
        this.propsRegistre = new HashMap<String, Props>();
        this.propertiesPath = FMLPaths.CONFIGDIR.get().toString() + "/" + mod_id + ".properties";
        this.properties = new Properties();
        this.load();
    }

    public static Configuration get(String mod_id) {
        if (!INSTANCES.containsKey(mod_id)) {
            INSTANCES.put(mod_id, new Configuration(mod_id));
        }
        return INSTANCES.get(mod_id);
    }

    public static void registry(String mod_id, Props ... props) {
        Configuration instance = Configuration.get(mod_id);
        for (Props v : props) {
            if (instance.propsRegistre.containsKey(v.getKey())) {
                throw new IllegalArgumentException("Duplicate keys in map, register Props is not possible for " + mod_id + ", Props.key: " + v.getKey());
            }
            instance.propsRegistre.put(v.getKey(), v);
        }
        instance.save();
    }

    public void load() {
        try {
            FileInputStream fs = new FileInputStream(this.propertiesPath);
            this.properties.load(fs);
            fs.close();
        }
        catch (FileNotFoundException e1) {
            LibraryFerret.LOGGER.warn("libraryferret - > Failed to load properties properties file not found");
            LibraryFerret.LOGGER.error(e1.getMessage());
        }
        catch (IOException e2) {
            LibraryFerret.LOGGER.warn("libraryferret - > Failed to load properties");
            LibraryFerret.LOGGER.error(e2.getMessage());
        }
    }

    public void save() {
        this.propsRegistre.forEach((k, v) -> this.properties.setProperty((String)k, this.properties.getProperty((String)k, v.getDefaultValue())));
        try {
            FileWriter fw = new FileWriter(this.propertiesPath);
            this.properties.store(fw, "need help ? ask on discord or dm curseforge <3 (ps: it is possible that this file contains nothing it's normal)");
            fw.close();
        }
        catch (IOException e) {
            LibraryFerret.LOGGER.warn("libraryferret - > Failed to store properties");
            LibraryFerret.LOGGER.error(e.getMessage());
        }
    }

    public void reset(Props props) {
        this.set(props, props.getDefaultValue());
    }

    public void set(Props props, String newValue) {
        this.properties.setProperty(props.getKey(), newValue);
    }

    public void set(Props props, char newValue) {
        this.set(props, "" + newValue);
    }

    public void set(Props props, boolean newValue) {
        this.set(props, newValue ? "true" : "false");
    }

    public void set(Props props, int newValue) {
        this.set(props, Integer.toString(newValue));
    }

    public void set(Props props, double newValue) {
        this.set(props, Double.toString(newValue));
    }

    public void set(Props props, float newValue) {
        this.set(props, Float.toString(newValue));
    }

    public void set(Props props, long newValue) {
        this.set(props, Long.toString(newValue));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Map<String, Props> getPropsRegistre() {
        return this.propsRegistre;
    }

    public String getPropertiesPath() {
        return this.propertiesPath;
    }

    public String getStringOrDefault(Props props) {
        return this.properties.getProperty(props.getKey(), props.getDefaultValue());
    }

    public char getCharOrDefault(Props props) {
        return this.getStringOrDefault(props).charAt(0);
    }

    public boolean getBoolOrDefault(Props props) {
        return "true".equalsIgnoreCase(this.getStringOrDefault(props));
    }

    public int getIntOrDefault(Props props) {
        try {
            return Integer.parseInt(this.getStringOrDefault(props));
        }
        catch (Exception unused) {
            try {
                return Integer.parseInt(props.getDefaultValue());
            }
            catch (Exception e) {
                LibraryFerret.LOGGER.warn("libraryferret - > Failed to get properties (int):" + props.getKey());
                LibraryFerret.LOGGER.error((Object)e);
                return 0;
            }
        }
    }

    public double getDoubleOrDefault(Props props) {
        try {
            return Double.parseDouble(this.getStringOrDefault(props));
        }
        catch (Exception unused) {
            try {
                return Double.parseDouble(props.getDefaultValue());
            }
            catch (Exception e) {
                LibraryFerret.LOGGER.warn("libraryferret - > Failed to get properties (double):" + props.getKey());
                LibraryFerret.LOGGER.error((Object)e);
                return 0.0;
            }
        }
    }

    public float getFloatOrDefault(Props props) {
        try {
            return Float.parseFloat(this.getStringOrDefault(props));
        }
        catch (Exception unused) {
            try {
                return Float.parseFloat(props.getDefaultValue());
            }
            catch (Exception e) {
                LibraryFerret.LOGGER.warn("libraryferret - > Failed to get properties (float):" + props.getKey());
                LibraryFerret.LOGGER.error((Object)e);
                return 0.0f;
            }
        }
    }

    public long getLongOrDefault(Props props) {
        try {
            return Long.parseLong(this.getStringOrDefault(props));
        }
        catch (Exception unused) {
            try {
                return Long.parseLong(props.getDefaultValue());
            }
            catch (Exception e) {
                LibraryFerret.LOGGER.warn("libraryferret - > Failed to get properties (long):" + props.getKey());
                LibraryFerret.LOGGER.error((Object)e);
                return 0L;
            }
        }
    }
}

