/*
 * Decompiled with CFR 0.152.
 */
package com.command_block.libraryferret;

import com.command_block.libraryferret.LibraryFerretClient;
import com.command_block.libraryferret.blocks.Blocks;
import com.command_block.libraryferret.conf.Configuration;
import com.command_block.libraryferret.conf.Props;
import com.command_block.libraryferret.effect.StatusEffects;
import com.command_block.libraryferret.items.Items;
import java.util.Optional;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="libraryferret")
public class LibraryFerret {
    public static boolean isLOADED = false;
    public static final String MOD_ID = "libraryferret";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Props ENABLED_FERRET_ITEM_GROUP = Props.create("boolean", "creative", "enable_item_group_ferret", "false");
    public static Optional<CreativeModeTab> FERRET_ITEM_GROUP = Optional.empty();

    public LibraryFerret() {
        isLOADED = false;
        LOGGER.info("libraryferret - > Initialize library");
        this.setupOptionalFieldByConfiguration(Configuration.get(MOD_ID));
        IEventBus e = FMLJavaModLoadingContext.get().getModEventBus();
        StatusEffects.registerEffect(e);
        Items.registerItems(e);
        Blocks.registerBlocks(e);
        e.addListener(this::doCommonStuff);
        e.addListener(this::doClientStuff);
        isLOADED = true;
        LOGGER.info("libraryferret - > Initialized library");
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> LibraryFerretClient::register);
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Blocks.UNBREAKABLE_IRON_BEACON.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Blocks.UNBREAKABLE_GOLD_BEACON.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Blocks.UNBREAKABLE_EMERALD_BEACON.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Blocks.UNBREAKABLE_DIAMOND_BEACON.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Blocks.UNBREAKABLE_NETHERITE_BEACON.get()), (RenderType)RenderType.m_110463_());
        });
    }

    public static boolean isLoaded() {
        return isLOADED;
    }

    private void setupOptionalFieldByConfiguration(Configuration config) {
        if (config.getBoolOrDefault(ENABLED_FERRET_ITEM_GROUP)) {
            FERRET_ITEM_GROUP = Optional.of(new CreativeModeTab("libraryferret.libraryferret"){

                public ItemStack m_6976_() {
                    return new ItemStack((ItemLike)net.minecraft.world.level.block.Blocks.f_50087_);
                }
            });
        }
    }

    static {
        Configuration.registry(MOD_ID, ENABLED_FERRET_ITEM_GROUP);
    }
}

