/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.aquamirae.world.events;

import com.obscuria.aquamirae.AquamiraeMod;
import com.obscuria.aquamirae.registry.AquamiraeMobEffects;
import com.obscuria.aquamirae.world.entities.IShipGraveyardEntity;
import com.obscuria.aquamirae.world.items.armor.AbyssalArmorItem;
import com.obscuria.aquamirae.world.items.armor.TerribleArmorItem;
import com.obscuria.aquamirae.world.items.armor.ThreeBoltArmorItem;
import com.obscuria.aquamirae.world.items.weapon.CoralLanceItem;
import com.obscuria.aquamirae.world.items.weapon.FinCutterItem;
import com.obscuria.aquamirae.world.items.weapon.RemnantsSaberItem;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class AquamiraeEvents {
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.f_19853_.f_46443_ || event.player.m_7500_() || event.player.m_5833_()) {
            return;
        }
        if (event.player.f_19853_.m_204166_(event.player.m_142538_()).m_203656_(AquamiraeMod.ICE_MAZE) && event.player.m_20072_() && event.player.m_146888_() <= event.player.m_146891_() * 3 && AquamiraeEvents.countArmor((LivingEntity)event.player, ThreeBoltArmorItem.class) < 4) {
            event.player.m_146917_(event.player.m_146888_() + 4);
        }
    }

    public static void onEntityAttacked(LivingHurtEvent event) {
        Player player;
        int TOTAL;
        Object item;
        LivingEntity source;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && (entity = (source = (LivingEntity)entity).m_21205_().m_41720_()) instanceof FinCutterItem) {
            item = (FinCutterItem)entity;
            int emptyHP = (int)Math.floor((source.m_21233_() - source.m_21223_()) / 2.0f);
            event.setAmount(event.getAmount() + event.getAmount() * Math.min((float)item.ABILITY.getAmount(source, 1) * 0.01f, (float)(emptyHP * item.ABILITY.getAmount(source, 0)) * 0.01f));
        }
        if ((item = event.getEntity()) instanceof Player && (TOTAL = AquamiraeEvents.countArmor((LivingEntity)(player = (Player)item), TerribleArmorItem.class)) >= 2) {
            Entity entity2;
            Item item2;
            ItemStack piece = AquamiraeEvents.getArmor((LivingEntity)player, TerribleArmorItem.class);
            if (player.m_20069_() && !player.m_36335_().m_41519_(piece.m_41720_()) && (item2 = piece.m_41720_()) instanceof TerribleArmorItem) {
                TerribleArmorItem item3 = (TerribleArmorItem)item2;
                player.m_7292_(new MobEffectInstance((MobEffect)AquamiraeMobEffects.SWIM_SPEED.get(), 20 * item3.ABILITY_HALFSET.getAmount((LivingEntity)player, 1), Math.min(19, item3.ABILITY_HALFSET.getAmount((LivingEntity)player, 0) / 10 - 1), false, false));
                int cooldown = 20 * item3.ABILITY_HALFSET.getCost((LivingEntity)player);
                AquamiraeEvents.cooldown(player, TerribleArmorItem.class, cooldown);
            }
            if (TOTAL >= 4 && (entity2 = event.getSource().m_7639_()) instanceof LivingEntity) {
                LivingEntity source2 = (LivingEntity)entity2;
                entity2 = piece.m_41720_();
                if (entity2 instanceof TerribleArmorItem) {
                    TerribleArmorItem item4 = (TerribleArmorItem)entity2;
                    source2.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 20 * item4.ABILITY_FULLSET.getAmount((LivingEntity)player, 0), 1, false, false));
                }
            }
        }
    }

    public static void onEntityHurt(LivingHurtEvent event) {
        SwordItem item;
        LivingEntity source;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && (source = (LivingEntity)entity).m_20069_() && (entity = source.m_21205_().m_41720_()) instanceof RemnantsSaberItem) {
            item = (RemnantsSaberItem)entity;
            event.setAmount(event.getAmount() * (1.0f + (float)item.ABILITY.getAmount(source, 0) * 0.01f));
        }
        if ((entity = event.getSource().m_7639_()) instanceof LivingEntity && (entity = (source = (LivingEntity)entity).m_21205_().m_41720_()) instanceof CoralLanceItem) {
            item = (CoralLanceItem)entity;
            if (event.getEntity() instanceof IShipGraveyardEntity) {
                event.setAmount(event.getAmount() * (1.0f + (float)((CoralLanceItem)item).ABILITY.getAmount(source, 0) * 0.01f));
            }
        }
    }

    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity entity;
        int TOTAL;
        if (event != null && event.getEntity() != null && (TOTAL = AquamiraeEvents.countArmor(entity = event.getEntityLiving(), AbyssalArmorItem.class)) >= 4 && !entity.m_21023_((MobEffect)AquamiraeMobEffects.CRYSTALLIZATION.get())) {
            AbyssalArmorItem item = (AbyssalArmorItem)AquamiraeEvents.getArmor(entity, AbyssalArmorItem.class).m_41720_();
            if (!entity.getPersistentData().m_128471_("crystallization")) {
                event.setCanceled(true);
                entity.m_7292_(new MobEffectInstance((MobEffect)AquamiraeMobEffects.CRYSTALLIZATION.get(), 20 * item.ABILITY_FULLSET_1.getAmount(entity, 0), 0, true, true));
                entity.m_21153_(entity.m_21233_());
                Level level = entity.m_183503_();
                if (level instanceof ServerLevel) {
                    ServerLevel level2 = (ServerLevel)level;
                    level2.m_5594_(null, new BlockPos(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_()), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                ItemStack head = entity.m_6844_(EquipmentSlot.HEAD);
                ItemStack chest = entity.m_6844_(EquipmentSlot.CHEST);
                ItemStack legs = entity.m_6844_(EquipmentSlot.LEGS);
                ItemStack feet = entity.m_6844_(EquipmentSlot.FEET);
                if (head.m_41629_(50, entity.m_21187_(), null)) {
                    head.m_41774_(1);
                    head.m_41721_(0);
                }
                if (chest.m_41629_(50, entity.m_21187_(), null)) {
                    chest.m_41774_(1);
                    chest.m_41721_(0);
                }
                if (legs.m_41629_(50, entity.m_21187_(), null)) {
                    legs.m_41774_(1);
                    legs.m_41721_(0);
                }
                if (feet.m_41629_(50, entity.m_21187_(), null)) {
                    feet.m_41774_(1);
                    feet.m_41721_(0);
                }
            }
        }
    }

    private static int countArmor(LivingEntity entity, Class<?> armor) {
        boolean HEAD = armor.isAssignableFrom(entity.m_6844_(EquipmentSlot.HEAD).m_41720_().getClass());
        boolean CHEST = armor.isAssignableFrom(entity.m_6844_(EquipmentSlot.CHEST).m_41720_().getClass());
        boolean LEGS = armor.isAssignableFrom(entity.m_6844_(EquipmentSlot.LEGS).m_41720_().getClass());
        boolean FEET = armor.isAssignableFrom(entity.m_6844_(EquipmentSlot.FEET).m_41720_().getClass());
        return (HEAD ? 1 : 0) + (CHEST ? 1 : 0) + (LEGS ? 1 : 0) + (FEET ? 1 : 0);
    }

    private static ItemStack getArmor(LivingEntity entity, Class<?> armor) {
        return armor.isAssignableFrom(entity.m_6844_(EquipmentSlot.HEAD).m_41720_().getClass()) ? entity.m_6844_(EquipmentSlot.HEAD) : (armor.isAssignableFrom(entity.m_6844_(EquipmentSlot.CHEST).m_41720_().getClass()) ? entity.m_6844_(EquipmentSlot.CHEST) : (armor.isAssignableFrom(entity.m_6844_(EquipmentSlot.LEGS).m_41720_().getClass()) ? entity.m_6844_(EquipmentSlot.LEGS) : (armor.isAssignableFrom(entity.m_6844_(EquipmentSlot.FEET).m_41720_().getClass()) ? entity.m_6844_(EquipmentSlot.FEET) : ItemStack.f_41583_)));
    }

    private static void cooldown(Player player, Class<?> armor, int cooldown) {
        if (armor.isAssignableFrom(player.m_6844_(EquipmentSlot.HEAD).m_41720_().getClass())) {
            player.m_36335_().m_41524_(player.m_6844_(EquipmentSlot.HEAD).m_41720_(), cooldown);
        }
        if (armor.isAssignableFrom(player.m_6844_(EquipmentSlot.CHEST).m_41720_().getClass())) {
            player.m_36335_().m_41524_(player.m_6844_(EquipmentSlot.CHEST).m_41720_(), cooldown);
        }
        if (armor.isAssignableFrom(player.m_6844_(EquipmentSlot.LEGS).m_41720_().getClass())) {
            player.m_36335_().m_41524_(player.m_6844_(EquipmentSlot.LEGS).m_41720_(), cooldown);
        }
        if (armor.isAssignableFrom(player.m_6844_(EquipmentSlot.FEET).m_41720_().getClass())) {
            player.m_36335_().m_41524_(player.m_6844_(EquipmentSlot.FEET).m_41720_(), cooldown);
        }
    }
}

