/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.aquamirae.world.entities;

import com.obscuria.aquamirae.AquamiraeConfig;
import com.obscuria.aquamirae.AquamiraeMod;
import com.obscuria.aquamirae.registry.AquamiraeEntities;
import com.obscuria.aquamirae.registry.AquamiraeSounds;
import com.obscuria.aquamirae.world.entities.IShipGraveyardEntity;
import com.obscuria.obscureapi.client.animations.HekateLib;
import com.obscuria.obscureapi.client.animations.HekateProvider;
import com.obscuria.obscureapi.client.animations.IHekateProvider;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;

public class Eel
extends Monster
implements IShipGraveyardEntity,
IHekateProvider {
    private final HekateProvider ANIMATIONS = new HekateProvider((Entity)this);
    private static final EntityDataAccessor<Integer> MOVE_COOLDOWN = SynchedEntityData.m_135353_(Eel.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> POS_X = SynchedEntityData.m_135353_(Eel.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> POS_Y = SynchedEntityData.m_135353_(Eel.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> POS_Z = SynchedEntityData.m_135353_(Eel.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> HIT_SERIES = SynchedEntityData.m_135353_(Eel.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(Eel.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SCALE_SPEED = SynchedEntityData.m_135353_(Eel.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public Eel(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<Eel>)((EntityType)AquamiraeEntities.EEL.get()), world);
    }

    public Eel(EntityType<Eel> type, Level world) {
        super(type, world);
        this.f_21364_ = 120;
        this.m_21530_();
    }

    @NotNull
    public AABB m_6921_() {
        return super.m_6921_().m_82400_(2.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractIllager.class, false, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(MOVE_COOLDOWN, (Object)200);
        this.m_20088_().m_135372_(POS_X, (Object)Float.valueOf((float)this.m_20185_()));
        this.m_20088_().m_135372_(POS_Y, (Object)Float.valueOf((float)this.m_20186_()));
        this.m_20088_().m_135372_(POS_Z, (Object)Float.valueOf((float)this.m_20189_()));
        this.m_20088_().m_135372_(HIT_SERIES, (Object)0);
        this.m_20088_().m_135372_(SCALE, (Object)Float.valueOf(1.0f));
        this.m_20088_().m_135372_(SCALE_SPEED, (Object)Float.valueOf(0.1f));
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        CompoundTag data = new CompoundTag();
        data.m_128405_("MoveCooldown", ((Integer)this.m_20088_().m_135370_(MOVE_COOLDOWN)).intValue());
        data.m_128405_("Hits", ((Integer)this.m_20088_().m_135370_(HIT_SERIES)).intValue());
        data.m_128350_("Scale", ((Float)this.m_20088_().m_135370_(SCALE)).floatValue());
        data.m_128350_("ScaleSpeed", ((Float)this.m_20088_().m_135370_(SCALE_SPEED)).floatValue());
        data.m_128350_("x", ((Float)this.m_20088_().m_135370_(POS_X)).floatValue());
        data.m_128350_("y", ((Float)this.m_20088_().m_135370_(POS_Y)).floatValue());
        data.m_128350_("z", ((Float)this.m_20088_().m_135370_(POS_Z)).floatValue());
        tag.m_128365_("EelData", (Tag)data);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        CompoundTag data = tag.m_128469_("EelData");
        this.m_20088_().m_135381_(MOVE_COOLDOWN, (Object)data.m_128451_("MoveCooldown"));
        this.m_20088_().m_135381_(HIT_SERIES, (Object)data.m_128451_("Hits"));
        this.m_20088_().m_135381_(SCALE, (Object)Float.valueOf(data.m_128457_("Scale")));
        this.m_20088_().m_135381_(SCALE_SPEED, (Object)Float.valueOf(data.m_128457_("ScaleSpeed")));
        this.m_20088_().m_135381_(POS_X, (Object)Float.valueOf(data.m_128457_("x")));
        this.m_20088_().m_135381_(POS_Y, (Object)Float.valueOf(data.m_128457_("y")));
        this.m_20088_().m_135381_(POS_Z, (Object)Float.valueOf(data.m_128457_("z")));
    }

    public HekateProvider getHekateProvider() {
        return this.ANIMATIONS;
    }

    public void m_6075_() {
        HekateLib.updateScale((Entity)this, (float)((Float)this.m_20088_().m_135370_(SCALE)).floatValue(), (float)((Float)this.m_20088_().m_135370_(SCALE_SPEED)).floatValue());
        int moveCooldown = (Integer)this.m_20088_().m_135370_(MOVE_COOLDOWN);
        int hitSeries = (Integer)this.m_20088_().m_135370_(HIT_SERIES);
        this.m_20088_().m_135381_(MOVE_COOLDOWN, (Object)(moveCooldown - 1));
        if (this.ANIMATIONS.isPlaying("move")) {
            if (this.ANIMATIONS.getTick("move") == 25) {
                this.m_6021_(((Float)this.m_20088_().m_135370_(POS_X)).floatValue(), ((Float)this.m_20088_().m_135370_(POS_Y)).floatValue(), ((Float)this.m_20088_().m_135370_(POS_Z)).floatValue());
            }
            if (this.ANIMATIONS.getTick("move") >= 20 && this.ANIMATIONS.getTick("move") <= 27) {
                this.m_20088_().m_135381_(SCALE, (Object)Float.valueOf(0.0f));
                this.m_20088_().m_135381_(SCALE_SPEED, (Object)Float.valueOf(1.0f));
            } else if (this.ANIMATIONS.getTick("move") >= 17 && this.ANIMATIONS.getTick("move") <= 19) {
                this.m_20088_().m_135381_(SCALE, (Object)Float.valueOf(1.0f));
                this.m_20088_().m_135381_(SCALE_SPEED, (Object)Float.valueOf(1.0f));
            } else if (this.ANIMATIONS.getTick("move") == 16) {
                this.m_20088_().m_135381_(SCALE_SPEED, (Object)Float.valueOf(0.1f));
            }
        } else {
            if (this.m_5448_() != null) {
                LivingEntity target = this.m_5448_();
                double distance = this.m_20280_((Entity)target);
                this.f_21365_.m_148051_((Entity)target);
                if ((Integer)this.m_20088_().m_135370_(HIT_SERIES) <= 0 && distance <= 30.0 && this.f_19796_.nextInt(60) == 1) {
                    this.m_20088_().m_135381_(HIT_SERIES, (Object)new Random().nextInt(1, 3));
                } else if ((Integer)this.m_20088_().m_135370_(HIT_SERIES) > 0 && !this.ANIMATIONS.isPlaying("attack") && !this.ANIMATIONS.isPlaying("roar")) {
                    this.m_20088_().m_135381_(HIT_SERIES, (Object)(hitSeries - 1));
                    this.ANIMATIONS.play("attack", 20);
                }
                if (!this.ANIMATIONS.isPlaying("attack") && !this.ANIMATIONS.isPlaying("roar") && this.f_19796_.nextInt(100) == 1) {
                    this.ANIMATIONS.play("roar", 52);
                }
                if (distance <= 24.0 && this.ANIMATIONS.getTick("attack") == 6) {
                    float hp = target.m_21223_();
                    this.m_7327_((Entity)target);
                    if (target.m_21223_() < hp) {
                        this.m_5634_((hp - target.m_21223_()) * 2.0f);
                    }
                }
                if (!target.m_183503_().m_5776_() && this.ANIMATIONS.isPlaying("roar") && this.ANIMATIONS.getTick("roar") <= 40) {
                    if (distance < 150.0) {
                        Vec3 thisVec = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
                        Vec3 targetVec = new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_());
                        Vec3 targetDelta = target.m_20184_();
                        Vec3 roarVec = thisVec.m_82505_(targetVec).m_82490_(0.07).m_82490_(Math.max(0.0, 1.0 - distance / 150.0));
                        target.m_20334_(targetDelta.f_82479_ + roarVec.f_82479_, targetDelta.f_82480_, targetDelta.f_82481_ + roarVec.f_82481_);
                        if (target instanceof Player) {
                            Player player = (Player)target;
                            player.f_19864_ = true;
                        }
                    }
                    if (target instanceof Mob) {
                        Mob mob = (Mob)target;
                        mob.m_6710_((LivingEntity)this);
                    }
                }
            }
            if (!this.ANIMATIONS.isPlaying("attack") && !this.ANIMATIONS.isPlaying("roar") && moveCooldown < 0) {
                Vec3 pos;
                Vec3 vec3 = pos = this.m_5448_() != null && this.m_20280_((Entity)this.m_5448_()) > 40.0 ? this.targetEelMove() : this.randomEelMove();
                if (pos.m_7098_() == 0.0) {
                    this.m_20088_().m_135381_(MOVE_COOLDOWN, (Object)2);
                } else {
                    this.m_20088_().m_135381_(POS_X, (Object)Float.valueOf((float)pos.m_7096_()));
                    this.m_20088_().m_135381_(POS_Y, (Object)Float.valueOf((float)pos.m_7098_()));
                    this.m_20088_().m_135381_(POS_Z, (Object)Float.valueOf((float)pos.m_7094_()));
                    this.m_20088_().m_135381_(MOVE_COOLDOWN, (Object)400);
                    this.ANIMATIONS.play("move", 50);
                    this.ANIMATIONS.play("moveMain", 50);
                }
            }
            if (!this.ANIMATIONS.isPlaying("rareIdle") && this.f_19796_.nextInt(80) == 1) {
                this.ANIMATIONS.play("rareIdle", this.f_19796_.nextInt(80, 160));
            }
        }
        this.ANIMATIONS.playSound("attack", 20, "aquamirae:entity.eel.bite", SoundSource.HOSTILE, 2.0f, 1.0f);
        this.ANIMATIONS.playSound("roar", 52, "aquamirae:entity.eel.roar", SoundSource.HOSTILE, 2.0f, 1.0f);
        super.m_6075_();
    }

    public Vec3 randomEelMove() {
        int x = this.m_146903_() + this.f_19796_.nextInt(5, 16) * (Math.random() > 0.5 ? -1 : 1);
        int z = this.m_146907_() + this.f_19796_.nextInt(5, 16) * (Math.random() > 0.5 ? -1 : 1);
        for (int i = -8; i < 8; ++i) {
            if (!this.checkGround(x, this.m_146904_() - i, z) || !this.checkSpace(x, this.m_146904_() - i + 1, z) || !this.checkSpace(x, this.m_146904_() - i + 2, z) || !this.checkSpace(x, this.m_146904_() - i + 3, z) || !this.checkSpace(x, this.m_146904_() - i + 4, z)) continue;
            return new Vec3((double)x + 0.5, (double)(this.m_146904_() - i) + 1.0, (double)z + 0.5);
        }
        return Vec3.f_82478_;
    }

    public Vec3 targetEelMove() {
        if (this.m_5448_() == null) {
            return Vec3.f_82478_;
        }
        int x = this.m_5448_().m_146903_() + this.f_19796_.nextInt(-3, 3);
        int z = this.m_5448_().m_146907_() + this.f_19796_.nextInt(-3, 3);
        for (int i = -4; i < 4; ++i) {
            if (!this.checkGround(x, this.m_146904_() - i, z) || !this.checkSpace(x, this.m_146904_() - i + 1, z) || !this.checkSpace(x, this.m_146904_() - i + 2, z) || !this.checkSpace(x, this.m_146904_() - i + 3, z) || !this.checkSpace(x, this.m_146904_() - i + 4, z)) continue;
            return new Vec3((double)x + 0.5, (double)(this.m_146904_() - i) + 1.0, (double)z + 0.5);
        }
        return Vec3.f_82478_;
    }

    public boolean checkGround(int x, int y, int z) {
        return this.m_183503_().m_8055_(new BlockPos(x, y, z)).m_204336_(AquamiraeMod.EEL_MOVE) && this.m_183503_().m_8055_(new BlockPos(x + 1, y, z)).m_204336_(AquamiraeMod.EEL_MOVE) && this.m_183503_().m_8055_(new BlockPos(x - 1, y, z)).m_204336_(AquamiraeMod.EEL_MOVE) && this.m_183503_().m_8055_(new BlockPos(x, y, z + 1)).m_204336_(AquamiraeMod.EEL_MOVE) && this.m_183503_().m_8055_(new BlockPos(x, y, z - 1)).m_204336_(AquamiraeMod.EEL_MOVE);
    }

    public boolean checkSpace(int x, int y, int z) {
        return this.m_183503_().m_46859_(new BlockPos(x, y, z)) && this.m_183503_().m_46859_(new BlockPos(x + 1, y, z)) && this.m_183503_().m_46859_(new BlockPos(x - 1, y, z)) && this.m_183503_().m_46859_(new BlockPos(x, y, z + 1)) && this.m_183503_().m_46859_(new BlockPos(x, y, z - 1)) && this.m_183503_().m_46859_(new BlockPos(x + 1, y, z + 1)) && this.m_183503_().m_46859_(new BlockPos(x - 1, y, z - 1)) && this.m_183503_().m_46859_(new BlockPos(x + 1, y, z - 1)) && this.m_183503_().m_46859_(new BlockPos(x - 1, y, z + 1));
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        AquamiraeMod.loadFromConfig((LivingEntity)this, Attributes.f_22276_, (Double)AquamiraeConfig.Common.eelMaxHealth.get());
        AquamiraeMod.loadFromConfig((LivingEntity)this, Attributes.f_22284_, (Double)AquamiraeConfig.Common.eelArmor.get());
        AquamiraeMod.loadFromConfig((LivingEntity)this, Attributes.f_22281_, (Double)AquamiraeConfig.Common.eelAttackDamage.get());
        AquamiraeMod.loadFromConfig((LivingEntity)this, Attributes.f_22277_, (Double)AquamiraeConfig.Common.eelFollowRange.get());
        AquamiraeMod.loadFromConfig((LivingEntity)this, Attributes.f_22282_, (Double)AquamiraeConfig.Common.eelAttackKnockback.get());
        return super.m_6518_(world, difficulty, reason, livingdata, tag);
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_5997_(double d1, double d2, double d3) {
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)AquamiraeSounds.ENTITY_DEEP_AMBIENT.get();
    }

    public SoundEvent m_7975_(@NotNull DamageSource source) {
        return (SoundEvent)AquamiraeSounds.ENTITY_DEEP_HURT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)AquamiraeSounds.ENTITY_DEEP_DEATH.get();
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (this.ANIMATIONS.isPlaying("move")) {
            return false;
        }
        if (source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source == DamageSource.f_19315_ || source == DamageSource.f_19314_ || source == DamageSource.f_19312_) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6072_() {
        return false;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 180.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22282_, 2.0);
    }
}

