/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.aquamirae.world.blocks;

import com.obscuria.aquamirae.registry.AquamiraeItems;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LuminescentBubbleBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public LuminescentBubbleBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76301_, (MaterialColor)MaterialColor.f_76362_).m_60918_(SoundType.f_56753_).m_60913_(0.1f, 0.5f).m_60953_(s -> 14).m_60910_().m_60956_(0.8f).m_60967_(0.8f).m_60955_().m_60982_((bs, br, bp) -> true).m_60991_((bs, br, bp) -> true).m_60924_((bs, br, bp) -> false).m_60988_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XYZ;
    }

    public void m_6807_(@NotNull BlockState blockstate, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
        world.m_186460_(pos, (Block)this, 20);
    }

    public void m_7458_(@NotNull BlockState blockstate, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull Random random) {
        super.m_7458_(blockstate, world, pos, random);
        world.m_186460_(pos, (Block)this, 20);
        Vec3 center = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        List<Player> list = world.m_6443_(Player.class, new AABB(center, center).m_82400_(8.0), e -> true).stream().sorted(Comparator.comparingDouble(ent -> ent.m_20238_(center))).toList();
        list.forEach(player -> {
            if (player.m_20069_()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19593_, 80, 1, false, true));
            }
        });
    }

    public boolean m_7420_(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public int m_7753_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        return 0;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Vec3 offset = state.m_60824_(world, pos);
        return LuminescentBubbleBlock.m_49796_((double)3.3, (double)1.0, (double)3.3, (double)12.7, (double)15.0, (double)12.7).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor world, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return ((Item)AquamiraeItems.LUMINESCENT_BUBBLE.get()).m_7968_();
    }

    @Nullable
    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob entity) {
        return BlockPathTypes.OPEN;
    }

    @NotNull
    public List<ItemStack> m_7381_(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootContext.Builder builder) {
        return Collections.singletonList(((Item)AquamiraeItems.LUMINESCENT_BUBBLE.get()).m_7968_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(@NotNull BlockState blockstate, @NotNull Level world, @NotNull BlockPos pos, @NotNull Random random) {
        super.m_7100_(blockstate, world, pos, random);
        for (int l = 0; l < 3; ++l) {
            double x0 = (float)pos.m_123341_() + random.nextFloat();
            double y0 = (float)pos.m_123342_() + random.nextFloat();
            double z0 = (float)pos.m_123343_() + random.nextFloat();
            double dx = ((double)random.nextFloat() - 0.5) * 0.16;
            double dy = ((double)random.nextFloat() - 0.5) * 0.16;
            double dz = ((double)random.nextFloat() - 0.5) * 0.16;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, x0, y0, z0, dx, dy, dz);
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockstate, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player entity, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        super.m_6227_(blockstate, world, pos, entity, hand, hit);
        world.m_46961_(pos, false);
        ItemStack stack = new ItemStack((ItemLike)AquamiraeItems.LUMINESCENT_BUBBLE.get(), 1);
        ItemHandlerHelper.giveItemToPlayer((Player)entity, (ItemStack)stack);
        return InteractionResult.SUCCESS;
    }
}

