/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.aquamirae;

import com.obscuria.aquamirae.AquamiraeConfig;
import com.obscuria.aquamirae.registry.AquamiraeBlocks;
import com.obscuria.aquamirae.registry.AquamiraeEntities;
import com.obscuria.aquamirae.registry.AquamiraeFeatures;
import com.obscuria.aquamirae.registry.AquamiraeItems;
import com.obscuria.aquamirae.registry.AquamiraeMobEffects;
import com.obscuria.aquamirae.registry.AquamiraeParticleTypes;
import com.obscuria.aquamirae.registry.AquamiraePotions;
import com.obscuria.aquamirae.registry.AquamiraeSounds;
import com.obscuria.aquamirae.registry.AquamiraeStructureFeatures;
import com.obscuria.aquamirae.world.events.AquamiraeEvents;
import com.obscuria.obscureapi.ObscureAPI;
import com.obscuria.obscureapi.registry.ObscureAPIAttributes;
import com.obscuria.obscureapi.world.classes.ObscureClass;
import com.obscuria.obscureapi.world.classes.TooltipHandler;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="aquamirae")
public class AquamiraeMod {
    public static final Logger LOGGER = LogManager.getLogger(AquamiraeMod.class);
    public static final String MODID = "aquamirae";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("aquamirae", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final IEventBus MOD_EVENT_BUS = FMLJavaModLoadingContext.get().getModEventBus();
    private static final IEventBus EVENT_BUS = MinecraftForge.EVENT_BUS;
    public static final ObscureClass SEA_WOLF = ObscureAPI.Classes.register((ObscureClass)new ObscureClass("aquamirae", "sea_wolf"));
    public static final TagKey<Biome> ICE_MAZE = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("aquamirae", "ice_maze"));
    public static final ResourceLocation BIOME = new ResourceLocation("minecraft:deep_frozen_ocean");
    public static final TagKey<Block> EEL_MOVE = BlockTags.create((ResourceLocation)new ResourceLocation("aquamirae", "eel_move"));
    public static final TagKey<Block> MAZE_MOTHER_DESTROY = BlockTags.create((ResourceLocation)new ResourceLocation("aquamirae", "maze_mother_destroy"));
    public static final TagKey<Block> SCROLL_DESTROY = BlockTags.create((ResourceLocation)new ResourceLocation("aquamirae", "scroll_destroy"));
    public static final CreativeModeTab TAB = new CreativeModeTab("aquamirae"){

        @NotNull
        public ItemStack m_6976_() {
            return ((Item)AquamiraeItems.RUNE_OF_THE_STORM.get()).m_7968_();
        }

        public boolean hasSearchBar() {
            return false;
        }
    };

    public AquamiraeMod() {
        EVENT_BUS.register((Object)this);
        AquamiraeConfig.load();
        AquamiraeFeatures.REGISTRY.register(MOD_EVENT_BUS);
        AquamiraeSounds.REGISTRY.register(MOD_EVENT_BUS);
        AquamiraeBlocks.REGISTRY.register(MOD_EVENT_BUS);
        AquamiraeEntities.REGISTRY.register(MOD_EVENT_BUS);
        AquamiraeItems.REGISTRY.register(MOD_EVENT_BUS);
        AquamiraeMobEffects.REGISTRY.register(MOD_EVENT_BUS);
        AquamiraePotions.REGISTRY.register(MOD_EVENT_BUS);
        AquamiraeParticleTypes.REGISTRY.register(MOD_EVENT_BUS);
        AquamiraeStructureFeatures.REGISTRY.register(MOD_EVENT_BUS);
        MOD_EVENT_BUS.addListener(this::commonSetup);
        EVENT_BUS.addListener(AquamiraeEvents::onPlayerTick);
        EVENT_BUS.addListener(AquamiraeEvents::onEntityAttacked);
        EVENT_BUS.addListener(AquamiraeEvents::onEntityHurt);
        EVENT_BUS.addListener(AquamiraeEvents::onEntityDeath);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ObscureAPI.collectionMod((String)MODID, (String)"ob-aquamirae");
        TooltipHandler.Lore.add((String)"aquamirae:sea_casserole");
        TooltipHandler.Lore.add((String)"aquamirae:sea_stew");
        TooltipHandler.Lore.add((String)"aquamirae:poseidons_breakfast");
        TooltipHandler.Lore.add((String)"aquamirae:ship_graveyard_echo");
        TooltipHandler.Lore.add((String)"aquamirae:pirate_pouch");
        TooltipHandler.Lore.add((String)"aquamirae:treasure_pouch");
        TooltipHandler.Lore.add((String)"aquamirae:luminescent_bubble");
        TooltipHandler.Lore.add((String)"aquamirae:luminescent_lamp");
        TooltipHandler.Lore.add((String)"aquamirae:shell_horn");
        TooltipHandler.Lore.add((String)"aquamirae:dead_sea_scroll");
        TooltipHandler.Lore.add((String)"aquamirae:frozen_key");
        TooltipHandler.Lore.add((String)"aquamirae:wisteria_niveis");
        TooltipHandler.Lore.add((String)"aquamirae:golden_moth_in_a_jar");
        TooltipHandler.Lore.add((String)"aquamirae:rune_of_the_storm");
        TooltipHandler.Lore.add((String)"aquamirae:oxygelium");
    }

    public static void loadFromConfig(LivingEntity entity, Attribute attribute, double amount) {
        AttributeInstance attributeInstance = entity.m_21051_(attribute);
        if (attributeInstance != null) {
            attributeInstance.m_22100_(amount);
        }
        if (attribute == Attributes.f_22276_) {
            entity.m_21153_(entity.m_21233_());
        }
    }

    public static boolean winterEvent() {
        return Calendar.getInstance().get(2) == 11 || Calendar.getInstance().get(2) == 0;
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static class LootBuilder {
        public static List<ItemStack> common() {
            int c1 = LootBuilder.getColor(10, 220, 160);
            int c2 = LootBuilder.getColor(10, 190, 220);
            int c3 = LootBuilder.getColor(10, 130, 220);
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            LootBuilder.add(list, Items.f_42407_, EquipmentSlot.HEAD, 1, 1, c1, "dead_sea_hat", Attributes.f_22281_);
            LootBuilder.add(list, Items.f_42407_, EquipmentSlot.HEAD, 1, 1, c2, "twilight_grotto_hat", (Attribute)ObscureAPIAttributes.PENETRATION.get());
            LootBuilder.add(list, Items.f_42407_, EquipmentSlot.HEAD, 1, 1, c3, "sea_tramps_hat", (Attribute)ObscureAPIAttributes.CRITICAL_HIT.get());
            LootBuilder.add(list, Items.f_42408_, EquipmentSlot.CHEST, 1, 3, c1, "dead_sea_doublet", Attributes.f_22281_);
            LootBuilder.add(list, Items.f_42408_, EquipmentSlot.CHEST, 1, 3, c2, "twilight_grotto_doublet", (Attribute)ObscureAPIAttributes.PENETRATION.get());
            LootBuilder.add(list, Items.f_42408_, EquipmentSlot.CHEST, 1, 3, c3, "sea_tramps_doublet", (Attribute)ObscureAPIAttributes.CRITICAL_HIT.get());
            LootBuilder.add(list, Items.f_42462_, EquipmentSlot.LEGS, 1, 2, c1, "dead_sea_pants", Attributes.f_22281_);
            LootBuilder.add(list, Items.f_42462_, EquipmentSlot.LEGS, 1, 2, c2, "twilight_grotto_pants", (Attribute)ObscureAPIAttributes.PENETRATION.get());
            LootBuilder.add(list, Items.f_42462_, EquipmentSlot.LEGS, 1, 2, c3, "sea_tramps_pants", (Attribute)ObscureAPIAttributes.CRITICAL_HIT.get());
            LootBuilder.add(list, Items.f_42463_, EquipmentSlot.FEET, 1, 1, c1, "dead_sea_boots", Attributes.f_22281_);
            LootBuilder.add(list, Items.f_42463_, EquipmentSlot.FEET, 1, 1, c2, "twilight_grotto_boots", (Attribute)ObscureAPIAttributes.PENETRATION.get());
            LootBuilder.add(list, Items.f_42463_, EquipmentSlot.FEET, 1, 1, c3, "sea_tramps_boots", (Attribute)ObscureAPIAttributes.CRITICAL_HIT.get());
            return list;
        }

        public static List<ItemStack> rare() {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            LootBuilder.add(list, Items.f_42468_, EquipmentSlot.HEAD, 2, 2, 0, "dead_sea_helmet", Attributes.f_22281_);
            LootBuilder.add(list, Items.f_42468_, EquipmentSlot.HEAD, 2, 2, 0, "twilight_grotto_helmet", (Attribute)ObscureAPIAttributes.PENETRATION.get());
            LootBuilder.add(list, Items.f_42468_, EquipmentSlot.HEAD, 2, 2, 0, "sea_tramps_helmet", (Attribute)ObscureAPIAttributes.CRITICAL_HIT.get());
            LootBuilder.add(list, Items.f_42469_, EquipmentSlot.CHEST, 2, 6, 0, "dead_sea_chestplate", Attributes.f_22281_);
            LootBuilder.add(list, Items.f_42469_, EquipmentSlot.CHEST, 2, 6, 0, "twilight_grotto_chestplate", (Attribute)ObscureAPIAttributes.PENETRATION.get());
            LootBuilder.add(list, Items.f_42469_, EquipmentSlot.CHEST, 2, 6, 0, "sea_tramps_chestplate", (Attribute)ObscureAPIAttributes.CRITICAL_HIT.get());
            LootBuilder.add(list, Items.f_42470_, EquipmentSlot.LEGS, 2, 5, 0, "dead_sea_leggings", Attributes.f_22281_);
            LootBuilder.add(list, Items.f_42470_, EquipmentSlot.LEGS, 2, 5, 0, "twilight_grotto_leggings", (Attribute)ObscureAPIAttributes.PENETRATION.get());
            LootBuilder.add(list, Items.f_42470_, EquipmentSlot.LEGS, 2, 5, 0, "sea_tramps_leggings", (Attribute)ObscureAPIAttributes.CRITICAL_HIT.get());
            LootBuilder.add(list, Items.f_42471_, EquipmentSlot.FEET, 2, 2, 0, "dead_sea_boots", Attributes.f_22281_);
            LootBuilder.add(list, Items.f_42471_, EquipmentSlot.FEET, 2, 2, 0, "twilight_grotto_boots", (Attribute)ObscureAPIAttributes.PENETRATION.get());
            LootBuilder.add(list, Items.f_42471_, EquipmentSlot.FEET, 2, 2, 0, "sea_tramps_boots", (Attribute)ObscureAPIAttributes.CRITICAL_HIT.get());
            return list;
        }

        public static void add(List<ItemStack> list, Item item, EquipmentSlot slot, int mod, int armor, int color, String name, Attribute attribute) {
            for (int i = 1; i <= 5; ++i) {
                ItemStack stack = new ItemStack((ItemLike)item);
                stack.m_41643_(Attributes.f_22284_, new AttributeModifier("base_armor", (double)armor, AttributeModifier.Operation.ADDITION), slot);
                stack.m_41643_(attribute, new AttributeModifier("base_bonus", (double)(mod * i) * 0.01, AttributeModifier.Operation.MULTIPLY_TOTAL), slot);
                stack.m_41698_("display").m_128359_("Name", Component.Serializer.m_130703_((Component)new TranslatableComponent("set.aquamirae." + name)));
                if (i == 5) {
                    stack.m_41663_(Enchantments.f_44986_, mod);
                }
                if (color > 0) {
                    stack.m_41698_("display").m_128405_("color", color);
                }
                list.add(stack);
            }
        }

        public static int getColor(int r, int g, int b) {
            return r * 65536 + g * 256 + b;
        }
    }
}

