/*
 * Decompiled with CFR 0.152.
 */
package com.duke.orcz.init;

import com.duke.orcz.world.features.CampFeature;
import com.duke.orcz.world.features.CampTheOtherFeature;
import com.duke.orcz.world.features.FaketreeFeature;
import com.duke.orcz.world.features.ores.FakeleafFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class OrczModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"orcz");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> CAMP = OrczModFeatures.register("camp", CampFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, CampFeature.GENERATE_BIOMES, CampFeature::placedFeature));
    public static final RegistryObject<Feature<?>> CAMP_THE_OTHER = OrczModFeatures.register("camp_the_other", CampTheOtherFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, CampTheOtherFeature.GENERATE_BIOMES, CampTheOtherFeature::placedFeature));
    public static final RegistryObject<Feature<?>> FAKELEAF = OrczModFeatures.register("fakeleaf", FakeleafFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, FakeleafFeature.GENERATE_BIOMES, FakeleafFeature::placedFeature));
    public static final RegistryObject<Feature<?>> FAKETREE = OrczModFeatures.register("faketree", FaketreeFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, FaketreeFeature.GENERATE_BIOMES, FaketreeFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

