/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.enlightened_end.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.enlightened_end.world.features.EndBiomesFeature;
import net.mcreator.enlightened_end.world.features.MagnetiteCrystalFeature;
import net.mcreator.enlightened_end.world.features.NullstoneLayerFeature;
import net.mcreator.enlightened_end.world.features.OozePoolFeature;
import net.mcreator.enlightened_end.world.features.ores.BismuthOreFeature;
import net.mcreator.enlightened_end.world.features.ores.DuskstoneFeature;
import net.mcreator.enlightened_end.world.features.ores.InfestedEndstoneFeature;
import net.mcreator.enlightened_end.world.features.ores.MalachiteOreFeature;
import net.mcreator.enlightened_end.world.features.ores.NullstoneFeature;
import net.mcreator.enlightened_end.world.features.ores.VoidShaleFeature;
import net.mcreator.enlightened_end.world.features.plants.ChorusRootsFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class EnlightenedEndModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"enlightened_end");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> CHORUS_ROOTS = EnlightenedEndModFeatures.register("chorus_roots", ChorusRootsFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, ChorusRootsFeature.GENERATE_BIOMES, ChorusRootsFeature::placedFeature));
    public static final RegistryObject<Feature<?>> CHORLOAM = EnlightenedEndModFeatures.register("chorloam", DuskstoneFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, DuskstoneFeature.GENERATE_BIOMES, DuskstoneFeature::placedFeature));
    public static final RegistryObject<Feature<?>> INFESTED_END_STONE = EnlightenedEndModFeatures.register("infested_end_stone", InfestedEndstoneFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, InfestedEndstoneFeature.GENERATE_BIOMES, InfestedEndstoneFeature::placedFeature));
    public static final RegistryObject<Feature<?>> NULLSTONE = EnlightenedEndModFeatures.register("nullstone", NullstoneFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, NullstoneFeature.GENERATE_BIOMES, NullstoneFeature::placedFeature));
    public static final RegistryObject<Feature<?>> MALACHITE_ORE = EnlightenedEndModFeatures.register("malachite_ore", MalachiteOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, MalachiteOreFeature.GENERATE_BIOMES, MalachiteOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> BISMUTH_ORE = EnlightenedEndModFeatures.register("bismuth_ore", BismuthOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, BismuthOreFeature.GENERATE_BIOMES, BismuthOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> VOIKRUST = EnlightenedEndModFeatures.register("voikrust", VoidShaleFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, VoidShaleFeature.GENERATE_BIOMES, VoidShaleFeature::placedFeature));
    public static final RegistryObject<Feature<?>> NULLSTONE_LAYER = EnlightenedEndModFeatures.register("nullstone_layer", NullstoneLayerFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, NullstoneLayerFeature.GENERATE_BIOMES, NullstoneLayerFeature::placedFeature));
    public static final RegistryObject<Feature<?>> END_BIOMES = EnlightenedEndModFeatures.register("end_biomes", EndBiomesFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, EndBiomesFeature.GENERATE_BIOMES, EndBiomesFeature::placedFeature));
    public static final RegistryObject<Feature<?>> OOZE_POOL = EnlightenedEndModFeatures.register("ooze_pool", OozePoolFeature::feature, new FeatureRegistration(GenerationStep.Decoration.LAKES, OozePoolFeature.GENERATE_BIOMES, OozePoolFeature::placedFeature));
    public static final RegistryObject<Feature<?>> MAGNETITE_CRYSTAL = EnlightenedEndModFeatures.register("magnetite_crystal", MagnetiteCrystalFeature::feature, new FeatureRegistration(GenerationStep.Decoration.RAW_GENERATION, MagnetiteCrystalFeature.GENERATE_BIOMES, MagnetiteCrystalFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

