/*
 * Decompiled with CFR 0.152.
 */
package com.toadstoolstudios.lilwings.registry.entity;

import com.toadstoolstudios.lilwings.LilWings;
import com.toadstoolstudios.lilwings.block.jareffects.JarEffect;
import com.toadstoolstudios.lilwings.entity.ButterflyEntity;
import com.toadstoolstudios.lilwings.entity.effects.CatchEffect;
import com.toadstoolstudios.lilwings.platform.CommonServices;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;

public record Butterfly(Supplier<EntityType<ButterflyEntity>> entityType, Supplier<SpawnEggItem> spawnEggItem, Supplier<Item>[] wings, Supplier<Item>[] cottonBallsItems, Supplier<ElytraItem>[] elytras, Item breedingItem, Supplier<Item> netItem, SimpleParticleType particleType, float particleSpawnChance, float spawnScale, float childSpawnScale, float maxHealth, int catchAmount, CatchEffect catchEffect, Supplier<JarEffect> jarEffect, String textureName) {
    public static final Map<ResourceLocation, Butterfly> BUTTERFLIES = new HashMap<ResourceLocation, Butterfly>();

    public static Butterfly getButterfly(EntityType<?> entityType) {
        return BUTTERFLIES.get(EntityType.m_20613_(entityType));
    }

    public static class Builder {
        private final String name;
        private String[] wings;
        private String[] cottonBalls;
        private String[] elytras;
        private boolean spawnEgg = false;
        private int eggBackgroundColor = 0xFFFFFF;
        private int eggOutlineColor = 0xFFFFFF;
        private SimpleParticleType particleType = null;
        private float particleSpawnChance = 0.08f;
        private float spawnScale = 0.65f;
        private float childSpawnScale = 0.4f;
        private float boundingWidth = 0.7f;
        private float boundingHeight = 0.7f;
        private float maxHealth = 6.0f;
        private int catchAmount = 1;
        private Item breedingItem = null;
        private Supplier<Item> netItem = null;
        private CatchEffect catchEffect;
        private Supplier<JarEffect> jarEffect;
        private CreativeModeTab creativeTab = LilWings.TAB;

        private Builder(String name) {
            this.name = name;
        }

        public Builder addWings(String ... wings) {
            if (wings != null) {
                this.wings = new String[wings.length + 1];
                this.wings[0] = "";
                if (wings.length - 1 >= 0) {
                    System.arraycopy(wings, 0, this.wings, 1, wings.length);
                }
                this.cottonBalls = new String[wings.length + 1];
                this.cottonBalls[0] = "";
                if (wings.length - 1 >= 0) {
                    System.arraycopy(wings, 0, this.cottonBalls, 1, wings.length);
                }
            } else {
                this.wings = new String[]{""};
            }
            return this;
        }

        public Builder addElytra(String ... elytras) {
            if (elytras != null) {
                this.elytras = Arrays.copyOf(elytras, elytras.length + 1);
                this.elytras[elytras.length] = "";
            } else {
                this.elytras = new String[]{""};
            }
            return this;
        }

        public Builder addSpawnEgg(int backgroundColor, int outlineColor) {
            this.spawnEgg = true;
            this.eggBackgroundColor = backgroundColor;
            this.eggOutlineColor = outlineColor;
            return this;
        }

        public Builder addParticles(SimpleParticleType particleType, float spawnChance) {
            this.particleType = particleType;
            this.particleSpawnChance = spawnChance;
            return this;
        }

        public Builder setSpawnScale(float scale, float childScale) {
            this.spawnScale = scale;
            this.childSpawnScale = childScale;
            return this;
        }

        public Builder setBoundingBoxSize(float width, float height) {
            this.boundingWidth = width;
            this.boundingHeight = height;
            return this;
        }

        public Builder setBreedingItem(Item item) {
            this.breedingItem = item;
            return this;
        }

        public Builder setMaxHealth(float maxHealth) {
            this.maxHealth = maxHealth;
            return this;
        }

        public Builder setCatchAmount(int catchAmount) {
            this.catchAmount = catchAmount;
            return this;
        }

        public Builder setCatchEffect(CatchEffect effect) {
            this.catchEffect = effect;
            return this;
        }

        public Builder setJarEffect(Supplier<JarEffect> effectSupplier) {
            this.jarEffect = effectSupplier;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.creativeTab = tab;
            return this;
        }

        public Builder setNet(Supplier<Item> netItem) {
            this.netItem = netItem;
            return this;
        }

        public Butterfly build(String modid) {
            int i;
            Supplier[] wingItems = new Supplier[this.wings != null ? this.wings.length : 0];
            Supplier[] cottonBallsItems = new Supplier[this.cottonBalls != null ? this.cottonBalls.length : 0];
            Supplier[] elytraItems = new Supplier[this.elytras != null ? this.elytras.length : 0];
            Supplier<EntityType<ButterflyEntity>> entityType = CommonServices.REGISTRY.registerEntity(this.name + "_butterfly", ButterflyEntity::new, MobCategory.AMBIENT, this.boundingWidth, this.boundingHeight);
            Supplier<SpawnEggItem> spawnEggItem = null;
            if (this.spawnEgg) {
                spawnEggItem = CommonServices.REGISTRY.registerSpawnEgg(this.name + "_egg", entityType, this.eggBackgroundColor, this.eggOutlineColor, new Item.Properties().m_41491_(this.creativeTab));
            }
            if (this.wings != null) {
                for (i = 0; i < this.wings.length; ++i) {
                    String wingName = this.wings[i];
                    wingItems[i] = CommonServices.REGISTRY.registerItem(this.name + (String)(wingName.isEmpty() ? "" : "_" + wingName) + "_wings", () -> new Item(new Item.Properties().m_41491_(this.creativeTab)));
                }
            }
            if (this.cottonBalls != null) {
                for (i = 0; i < this.cottonBalls.length; ++i) {
                    String cottonBallName = this.cottonBalls[i];
                    cottonBallsItems[i] = CommonServices.REGISTRY.registerItem(this.name + (String)(cottonBallName.isEmpty() ? "" : "_" + cottonBallName) + "_cotton_ball", () -> new Item(new Item.Properties().m_41491_(this.creativeTab)));
                }
            }
            if (this.elytras != null) {
                for (i = 0; i < this.elytras.length; ++i) {
                    String elytraName = this.elytras[i];
                    String regName = this.name + (String)(elytraName.isEmpty() ? "" : "_" + elytraName) + "_elytra";
                    elytraItems[i] = CommonServices.REGISTRY.registerElytra(regName, new ResourceLocation(modid, "textures/elytra/" + regName + ".png"));
                }
            }
            Butterfly butterfly = new Butterfly(entityType, spawnEggItem, wingItems, cottonBallsItems, elytraItems, this.breedingItem, this.netItem, this.particleType, this.particleSpawnChance, this.spawnScale, this.childSpawnScale, this.maxHealth, this.catchAmount, this.catchEffect, this.jarEffect, this.name);
            BUTTERFLIES.put(new ResourceLocation(modid, this.name + "_butterfly"), butterfly);
            return butterfly;
        }

        public static Builder of(String name) {
            return new Builder(name);
        }
    }
}

