/*
 * Decompiled with CFR 0.152.
 */
package com.toadstoolstudios.lilwings.forge;

import com.toadstoolstudios.lilwings.LilWings;
import com.toadstoolstudios.lilwings.api.PatreonManager;
import com.toadstoolstudios.lilwings.compat.TOPCompat;
import com.toadstoolstudios.lilwings.forge.MilkCauldron;
import com.toadstoolstudios.lilwings.forge.platform.ForgeRegistryHelper;
import com.toadstoolstudios.lilwings.registry.LilWingsBlocks;
import com.toadstoolstudios.lilwings.registry.LilWingsEntities;
import com.toadstoolstudios.lilwings.registry.entity.Butterfly;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="lilwings")
public class ForgeLilWings {
    public static final Supplier<Block> MILK_CAULDRON = ForgeRegistryHelper.BLOCKS.register("milk_cauldron", MilkCauldron::new);
    public static final Map<Item, CauldronInteraction> MILK_INTERACTION = CauldronInteraction.m_175617_();
    public static final CauldronInteraction FILL_MILK = (level, blockPos, player, hand, stack, state) -> CauldronInteraction.m_175618_((Level)blockPos, (BlockPos)player, (Player)hand, (InteractionHand)stack, (ItemStack)state, (BlockState)MILK_CAULDRON.get().m_49966_(), (SoundEvent)SoundEvents.f_11778_);

    public ForgeLilWings() {
        LilWings.init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::init);
        bus.addListener(this::onComplete);
        bus.addListener(this::attributeEvent);
        ForgeRegistryHelper.ENTITY_TYPES.register(bus);
        ForgeRegistryHelper.BLOCKS.register(bus);
        ForgeRegistryHelper.BLOCK_ENTITIES.register(bus);
        ForgeRegistryHelper.ITEMS.register(bus);
        ForgeRegistryHelper.SOUNDS.register(bus);
        ForgeRegistryHelper.PARTICLE_TYPES.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        bus.addListener(this::imcEvent);
    }

    public void attributeEvent(EntityAttributeCreationEvent event) {
        for (Butterfly butterfly : Butterfly.BUTTERFLIES.values()) {
            event.put(butterfly.entityType().get(), Mob.m_21552_().m_22268_(Attributes.f_22276_, (double)butterfly.maxHealth()).m_22268_(Attributes.f_22280_, 1.0).m_22265_());
        }
    }

    public void init(FMLCommonSetupEvent event) {
        CauldronInteraction.m_175647_(MILK_INTERACTION);
        CauldronInteraction.f_175606_.put(Items.f_42455_, FILL_MILK);
        MILK_INTERACTION.put(Items.f_42455_, FILL_MILK);
        MinecraftForge.EVENT_BUS.addListener(interactEvent -> {
            if (interactEvent.getPlayer().m_6144_() && interactEvent.getItemStack().m_150930_(Items.f_42590_)) {
                Direction face = interactEvent.getFace();
                BlockPos glassBottlePos = interactEvent.getPos();
                if (face != null) {
                    glassBottlePos = glassBottlePos.m_142300_(face);
                }
                if (!interactEvent.getPlayer().m_183503_().m_8055_(glassBottlePos).m_60795_()) {
                    return;
                }
                interactEvent.getPlayer().m_183503_().m_7731_(glassBottlePos, LilWingsBlocks.BUTTERFLY_JAR.get().m_49966_(), 3);
                if (!interactEvent.getPlayer().m_7500_()) {
                    interactEvent.getItemStack().m_41774_(1);
                }
                interactEvent.setCanceled(true);
                interactEvent.setCancellationResult(InteractionResult.SUCCESS);
            }
        });
    }

    public void onComplete(FMLLoadCompleteEvent event) {
        LilWingsEntities.addSpawnPlacements();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> PatreonManager::init);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void addButterflies(BiomeLoadingEvent event) {
        block0 : switch (event.getCategory()) {
            case TAIGA: {
                this.addButterfly(event, LilWingsEntities.APONI_BUTTERFLY);
                break;
            }
            case JUNGLE: {
                this.addButterfly(event, LilWingsEntities.PAINTED_PANTHER_BUTTERFLY);
                break;
            }
            case SWAMP: {
                this.addButterfly(event, LilWingsEntities.SWAMP_HOPPER_BUTTERFLY);
                break;
            }
            case MUSHROOM: {
                this.addButterfly(event, LilWingsEntities.SHROOM_SKIPPER_BUTTERFLY);
                break;
            }
            case FOREST: {
                this.addButterfly(event, LilWingsEntities.RED_APPLEFLY_BUTTERFLY);
                break;
            }
            default: {
                if (event.getName() == null) break;
                switch (event.getName().m_135815_()) {
                    case "sunflower_plains": {
                        this.addButterfly(event, LilWingsEntities.BUTTER_GOLD_BUTTERFLY);
                        break block0;
                    }
                    case "meadow": {
                        this.addButterfly(event, LilWingsEntities.CLOUDY_PUFF_BUTTERFLY);
                        break block0;
                    }
                    case "flower_forest": {
                        this.addButterfly(event, LilWingsEntities.CRYSTAL_PUFF_BUTTERFLY);
                        break block0;
                    }
                    case "lush_caves": {
                        this.addButterfly(event, LilWingsEntities.GRAYLING_BUTTERFLY);
                        break block0;
                    }
                    case "frozen_peaks": {
                        this.addButterfly(event, LilWingsEntities.WHITE_FOX_BUTTERFLY);
                    }
                }
            }
        }
    }

    private void addButterfly(BiomeLoadingEvent event, Butterfly butterfly) {
        event.getSpawns().m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(butterfly.entityType().get(), 25, 2, 2));
    }

    private void imcEvent(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPCompat::new);
        }
    }
}

