/*
 * Decompiled with CFR 0.152.
 */
package com.toadstoolstudios.lilwings.entity.goals;

import com.toadstoolstudios.lilwings.entity.ButterflyEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class FindFlowerGoal
extends Goal {
    public static final ArrayList<BlockPos> positionOffsets = new ArrayList();
    protected final ButterflyEntity butterfly;
    protected int ticks;
    protected int pollinationTicks;
    protected boolean running = false;
    protected boolean completed = false;
    protected Vec3 nextTarget;
    protected Vec3 boundingBox;

    public FindFlowerGoal(ButterflyEntity butterfly) {
        this.butterfly = butterfly;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public void m_8037_() {
        super.m_8037_();
        ++this.ticks;
        if (this.ticks >= 600) {
            this.clearTasks();
        } else {
            this.handleFlower();
        }
        if (this.pollinationTicks > this.getPollinationTime()) {
            this.completed = true;
        }
    }

    public void m_8056_() {
        super.m_8056_();
        this.pollinationTicks = 0;
        this.completed = false;
        this.running = true;
    }

    public void m_8041_() {
        super.m_8041_();
        this.running = false;
        this.butterfly.m_21573_().m_26573_();
        this.updateCooldown(200);
    }

    public boolean m_8036_() {
        if (this.butterfly.getFlowerCooldown() > 0 || this.butterfly.f_19853_.m_46471_()) {
            return false;
        }
        Optional<BlockPos> flowerPos = this.findFlower();
        if (flowerPos.isPresent()) {
            this.moveToFlower(flowerPos.get());
            return true;
        }
        this.updateCooldown(Mth.m_14072_((Random)this.butterfly.m_21187_(), (int)400, (int)500));
        return false;
    }

    public boolean m_8045_() {
        return this.running && this.getSavedPos() != null && !this.completed;
    }

    protected void handleFlower() {
        if (this.getSavedPos() != null) {
            Vec3 bottom = Vec3.m_82539_((Vec3i)this.getSavedPos()).m_82520_(0.0, (double)0.6f, 0.0);
            if (this.boundingBox != null) {
                bottom = this.boundingBox;
            }
            if (bottom.m_82554_(this.butterfly.m_20182_()) > 1.0) {
                this.nextTarget = bottom;
                this.moveToNextTarget();
            } else {
                if (this.nextTarget == null) {
                    this.nextTarget = bottom;
                }
                this.pollinateFlower(bottom);
            }
        }
    }

    private void moveToNextTarget() {
        this.butterfly.m_21566_().m_6849_(this.nextTarget.m_7096_(), this.nextTarget.m_7098_(), this.nextTarget.m_7094_(), 0.5);
    }

    private double getRandomOffset() {
        return ((double)this.butterfly.m_21187_().nextFloat() * 2.0 - 1.0) * 0.33333334;
    }

    private void pollinateFlower(Vec3 vector3d) {
        boolean closeToTarget = this.butterfly.m_20182_().m_82554_(this.nextTarget) <= 0.1;
        boolean shouldMoveToNewTarget = true;
        if (!closeToTarget && this.ticks > 600) {
            this.clearTasks();
        } else {
            if (closeToTarget) {
                if (this.butterfly.m_21187_().nextInt(25) == 0) {
                    this.nextTarget = new Vec3(vector3d.m_7096_() + this.getRandomOffset(), vector3d.m_7098_(), vector3d.m_7094_() + this.getRandomOffset());
                    this.butterfly.m_21573_().m_26573_();
                } else {
                    shouldMoveToNewTarget = false;
                }
                this.butterfly.m_21563_().m_24946_(vector3d.m_7096_(), vector3d.m_7098_(), vector3d.m_7094_());
            }
            if (shouldMoveToNewTarget) {
                this.moveToNextTarget();
            }
            ++this.pollinationTicks;
        }
    }

    public Optional<BlockPos> findFlower() {
        BlockPos beePos = this.butterfly.m_142538_();
        BlockPos.MutableBlockPos flowerPos = beePos.m_122032_();
        for (BlockPos blockPos : positionOffsets) {
            flowerPos.m_122154_((Vec3i)beePos, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
            if (!this.getFlowerBlockPredicate().test((BlockPos)flowerPos)) continue;
            return Optional.of(flowerPos);
        }
        return Optional.empty();
    }

    public void clearTasks() {
        this.butterfly.setSavedFlowerPos(null);
        this.boundingBox = null;
    }

    protected void moveToFlower(BlockPos flowerPos) {
        this.butterfly.setSavedFlowerPos(flowerPos);
        this.butterfly.m_21573_().m_26519_((double)flowerPos.m_123341_() + 0.5, (double)flowerPos.m_123342_() + 0.5, (double)flowerPos.m_123343_() + 0.5, 1.2);
    }

    public int getPollinationTime() {
        return 400;
    }

    protected void updateCooldown(int amount) {
        this.butterfly.setFlowerCooldown(amount);
    }

    protected BlockPos getSavedPos() {
        return this.butterfly.getSavedFlowerPos();
    }

    public Predicate<BlockPos> getFlowerBlockPredicate() {
        return pos -> {
            if (!this.butterfly.f_19853_.m_46739_(this.butterfly.m_142538_())) {
                return false;
            }
            BlockState state = this.butterfly.f_19853_.m_8055_(pos);
            if (state.m_60795_()) {
                return false;
            }
            return state.m_204336_(BlockTags.f_13041_);
        };
    }

    static {
        int i = 0;
        while ((double)i <= 5.0) {
            int j = 0;
            while ((double)j < 5.0) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        positionOffsets.add(new BlockPos(k, i - 1, l));
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
    }
}

