/*
 * Decompiled with CFR 0.152.
 */
package com.toadstoolstudios.lilwings.entity;

import com.toadstoolstudios.lilwings.entity.goals.ButterflyBreedGoal;
import com.toadstoolstudios.lilwings.entity.goals.FindFlowerGoal;
import com.toadstoolstudios.lilwings.entity.goals.GraylingFlowerGoal;
import com.toadstoolstudios.lilwings.item.ButterflyNetItem;
import com.toadstoolstudios.lilwings.registry.LilWingsEntities;
import com.toadstoolstudios.lilwings.registry.LilWingsItems;
import com.toadstoolstudios.lilwings.registry.entity.Butterfly;
import com.toadstoolstudios.lilwings.registry.entity.GraylingType;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ButterflyEntity
extends Animal
implements FlyingAnimal,
IAnimatable {
    private static final EntityDataAccessor<Integer> DATA_COLOR_TYPE = SynchedEntityData.m_135353_(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_CATCH_AMOUNT = SynchedEntityData.m_135353_(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private final Butterfly butterfly;
    private int flowerCooldown = Mth.m_14072_((Random)this.f_19796_, (int)400, (int)600);
    private BlockPos savedFlowerPos;
    public final boolean isInJar;
    private int otherCooldown = Mth.m_14072_((Random)this.f_19796_, (int)300, (int)600);
    private BlockPos savedOtherPos;
    private GraylingType colorType;

    public ButterflyEntity(EntityType<? extends ButterflyEntity> entityType, Level level) {
        this(entityType, level, false);
    }

    public ButterflyEntity(EntityType<? extends ButterflyEntity> entityType, Level level, boolean isInJar) {
        super(entityType, level);
        this.butterfly = Butterfly.getButterfly(entityType);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        if (this.butterfly.maxHealth() <= 0.0f) {
            this.m_20331_(true);
        }
        if (!level.m_5776_()) {
            if (this.butterfly.breedingItem() != null) {
                this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, (double)1.08f, Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.butterfly.breedingItem()}), false));
            }
            if (entityType == LilWingsEntities.GRAYLING_BUTTERFLY.entityType().get()) {
                this.f_21345_.m_25352_(4, (Goal)new GraylingFlowerGoal(this));
            } else {
                this.f_21345_.m_25352_(4, (Goal)new FindFlowerGoal(this));
            }
        }
        this.isInJar = isInJar;
    }

    public void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_CATCH_AMOUNT, (Object)0);
        this.m_20088_().m_135372_(DATA_COLOR_TYPE, (Object)GraylingType.NORMAL.ordinal());
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)LilWingsItems.LANTERN_ON_A_STICK.get()}), false));
        this.f_21345_.m_25352_(1, (Goal)new ButterflyBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, (double)1.08f));
        this.f_21345_.m_25352_(5, (Goal)new PanicGoal((PathfinderMob)this, (double)1.15f));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        boolean canCatch;
        ItemStack handStack = player.m_21120_(hand);
        boolean bl = this.butterfly.netItem() == null ? handStack.m_150930_(LilWingsItems.BUTTERFLY_NET.get()) || handStack.m_150930_(LilWingsItems.ENDERFLY_NET.get()) : (canCatch = handStack.m_150930_(this.butterfly.netItem().get()));
        if (this.f_19853_.m_5776_() && !canCatch && handStack.m_41720_() instanceof ButterflyNetItem) {
            player.m_5661_((Component)new TranslatableComponent("entity.lilwings.interactions.error.invalid_net"), true);
        }
        if (!this.f_19853_.m_5776_() && hand == InteractionHand.MAIN_HAND && canCatch && this.butterfly.catchAmount() > 0 && handStack.m_41720_() instanceof ButterflyNetItem) {
            if (handStack.m_41784_().m_128441_("butterfly")) {
                player.m_5661_((Component)new TranslatableComponent("entity.lilwings.interactions.error.full_net"), true);
                return InteractionResult.FAIL;
            }
            int catchAmount = (Integer)this.m_20088_().m_135370_(DATA_CATCH_AMOUNT) + 1;
            this.m_20088_().m_135381_(DATA_CATCH_AMOUNT, (Object)catchAmount);
            if (catchAmount >= this.butterfly.catchAmount()) {
                if (this.butterfly.catchEffect() != null) {
                    this.butterfly.catchEffect().onCatch(player, this, catchAmount);
                }
                handStack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
                CompoundTag tag = handStack.m_41784_();
                CompoundTag butterflyTag = new CompoundTag();
                this.m_20240_(butterflyTag);
                tag.m_128365_("butterfly", (Tag)butterflyTag);
                tag.m_128359_("butterflyId", EntityType.m_20613_((EntityType)this.m_6095_()).toString());
                handStack.m_41751_(tag);
                player.m_5661_((Component)new TranslatableComponent("entity.lilwings.interactions.success"), true);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return InteractionResult.SUCCESS;
            }
        }
        if (handStack.m_150930_(LilWingsItems.COTTON_BALL.get())) {
            int index = this.getColorType().ordinal();
            Item cottonBall = this.butterfly.cottonBallsItems()[index].get();
            handStack.m_41774_(1);
            player.m_150109_().m_150079_(new ItemStack((ItemLike)cottonBall));
            return InteractionResult.SUCCESS;
        }
        if (handStack.m_150930_(Items.f_42446_) && this.butterfly.equals(LilWingsEntities.CLOUDY_PUFF_BUTTERFLY)) {
            handStack.m_41774_(1);
            player.m_150109_().m_150079_(new ItemStack((ItemLike)LilWingsItems.JELLY_BUCKET.get()));
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public int getCatchAmount() {
        return (Integer)this.m_20088_().m_135370_(DATA_CATCH_AMOUNT);
    }

    public void setCatchAmount(int amount) {
        this.m_20088_().m_135381_(DATA_CATCH_AMOUNT, (Object)amount);
    }

    public void setColorType(GraylingType type) {
        this.m_20088_().m_135381_(DATA_COLOR_TYPE, (Object)type.ordinal());
        this.colorType = type;
    }

    public void setColorTypeNoUpdate(GraylingType type) {
        this.colorType = type;
    }

    public GraylingType getColorType() {
        return GraylingType.values()[(Integer)this.m_20088_().m_135370_(DATA_COLOR_TYPE)];
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCatchAmount(tag.m_128451_("catchAmount"));
        if (tag.m_128441_("colorType")) {
            this.setColorType(GraylingType.valueOf(tag.m_128461_("colorType")));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("catchAmount", this.getCatchAmount());
        tag.m_128359_("colorType", this.getColorType().name());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.butterfly.particleType() != null && this.f_19796_.nextFloat() < this.butterfly.particleSpawnChance()) {
            this.spawnParticle(this.butterfly.particleType(), this.m_20185_() - 0.3, this.m_20185_() + 0.3, this.m_20189_() - (double)0.3f, this.m_20189_() + (double)0.3f, this.m_20227_(0.5));
        }
    }

    private void spawnParticle(SimpleParticleType type, double p_27781_, double x1, double x2, double z1, double z2) {
        this.f_19853_.m_7106_((ParticleOptions)type, Mth.m_14139_((double)this.f_19796_.nextDouble(), (double)p_27781_, (double)x1), z2, Mth.m_14139_((double)this.f_19796_.nextDouble(), (double)x2, (double)z1), 0.0, 0.0, 0.0);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.m_5776_() && this.flowerCooldown > 0) {
            --this.flowerCooldown;
        }
    }

    public PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public boolean m_6898_(ItemStack pStack) {
        return this.butterfly.breedingItem() != null && pStack.m_150930_(this.butterfly.breedingItem());
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)this.m_6095_().m_20615_((Level)serverLevel);
    }

    protected boolean m_142039_() {
        return true;
    }

    public boolean m_142592_() {
        return !this.m_20096_();
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.butterfly.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public int getFlowerCooldown() {
        return this.flowerCooldown;
    }

    public BlockPos getSavedFlowerPos() {
        return this.savedFlowerPos;
    }

    public void setFlowerCooldown(int flowerCooldown) {
        this.flowerCooldown = flowerCooldown;
    }

    public void setSavedFlowerPos(BlockPos savedFlowerPos) {
        this.savedFlowerPos = savedFlowerPos;
    }

    public void setOtherCooldown(int otherCooldown) {
        this.otherCooldown = otherCooldown;
    }

    public void setSavedOtherPos(BlockPos savedOtherPos) {
        this.savedOtherPos = savedOtherPos;
    }

    public int getOtherCooldown() {
        return this.otherCooldown;
    }

    public BlockPos getSavedOtherPos() {
        return this.savedOtherPos;
    }

    public Butterfly getButterfly() {
        return this.butterfly;
    }
}

