/*
 * Decompiled with CFR 0.152.
 */
package com.toadstoolstudios.lilwings.client.patron;

import com.mojang.blaze3d.vertex.PoseStack;
import com.toadstoolstudios.lilwings.api.PatreonData;
import com.toadstoolstudios.lilwings.api.PatreonManager;
import com.toadstoolstudios.lilwings.client.patron.PatreonButterflyModel;
import com.toadstoolstudios.lilwings.client.patron.PatreonFluttererRenderer;
import com.toadstoolstudios.lilwings.client.patron.PatreonFlutteringButterfly;
import com.toadstoolstudios.lilwings.client.patron.PatreonFlutteringModel;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.geo.render.built.GeoModel;

public class PatreonLayerRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("lilwings", "textures/patreon/butter_gold.png");
    private static final Map<PatreonData.ButterflyType, PatreonFlutteringButterfly> BUTTERFLIES = new EnumMap<PatreonData.ButterflyType, PatreonFlutteringButterfly>(PatreonData.ButterflyType.class);
    private final PatreonButterflyModel headwearModel;
    private final PatreonFluttererRenderer renderer = new PatreonFluttererRenderer();

    public PatreonLayerRenderer(PlayerRenderer rendererContext, EntityRendererProvider.Context context) {
        super((RenderLayerParent)rendererContext);
        this.headwearModel = new PatreonButterflyModel(context.m_174023_(PatreonButterflyModel.LAYER));
    }

    public PatreonLayerRenderer(PlayerRenderer rendererContext, EntityModelSet loader) {
        super((RenderLayerParent)rendererContext);
        this.headwearModel = new PatreonButterflyModel(loader.m_171103_(PatreonButterflyModel.LAYER));
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        PatreonData.ButterflyType butterflyType;
        if (PatreonManager.isUserPatron(entity.m_142081_())) {
            matrices.m_85836_();
            this.headwearModel.prepare();
            if (!entity.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                matrices.m_85837_(0.0, -1.0, -1.0);
            }
            this.headwearModel.f_102817_ = entity.m_6047_();
            PatreonLayerRenderer.m_117359_((EntityModel)this.m_117386_(), (EntityModel)this.headwearModel, (ResourceLocation)TEXTURE, (PoseStack)matrices, (MultiBufferSource)vertexConsumers, (int)light, (LivingEntity)entity, (float)limbAngle, (float)limbDistance, (float)0.0f, (float)headYaw, (float)headPitch, (float)tickDelta, (float)1.0f, (float)1.0f, (float)1.0f);
            matrices.m_85849_();
        }
        if ((butterflyType = PatreonManager.getButterflyType(entity.m_142081_())) != null) {
            PatreonFlutteringButterfly data = BUTTERFLIES.computeIfAbsent(butterflyType, type -> new PatreonFlutteringButterfly(new ResourceLocation("lilwings", "textures/patreon/" + type.name().toLowerCase(Locale.ROOT) + ".png")));
            PatreonFlutteringModel modelProvider = data.getModel();
            GeoModel model = modelProvider.getModel(data);
            AnimationEvent event = new AnimationEvent((IAnimatable)data, 0.0f, 0.0f, Minecraft.m_91087_().m_91297_(), false, Collections.emptyList());
            modelProvider.setLivingAnimations(data, this.renderer.getUniqueID(data), event);
            RenderType renderLayer = RenderType.m_110458_((ResourceLocation)data.getTexture());
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.9, 0.0);
            matrices.m_85841_(1.0f, -1.0f, 1.0f);
            this.renderer.render(model, data, tickDelta, renderLayer, matrices, vertexConsumers, vertexConsumers.m_6299_(renderLayer), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrices.m_85849_();
        }
    }
}

