/*
 * Decompiled with CFR 0.152.
 */
package com.toadstoolstudios.lilwings.block.jareffects;

import com.toadstoolstudios.lilwings.block.ButterflyJarBlockEntity;
import com.toadstoolstudios.lilwings.block.jareffects.JarEffect;
import com.toadstoolstudios.lilwings.block.jareffects.forge.SwampHopperJarEffectImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class SwampHopperJarEffect
implements JarEffect {
    private int cooldown;
    private int containerTime;
    private BlockPos containerPos;
    private Direction containerDir;

    @Override
    public void tickEffect(Level level, ButterflyJarBlockEntity blockEntity) {
        if (level.m_5776_()) {
            return;
        }
        if (this.containerPos == null) {
            ++this.containerTime;
            if (this.containerTime >= 80) {
                this.containerDir = SwampHopperJarEffect.findNearestContainer(level, blockEntity.m_58899_());
                this.containerPos = this.containerDir != null ? blockEntity.m_58899_().m_142300_(this.containerDir) : null;
            }
        } else {
            ++this.cooldown;
            if (this.cooldown >= 20) {
                ItemEntity entity = SwampHopperJarEffect.findNearestItem(level, blockEntity.m_58899_());
                if (entity != null) {
                    BlockEntity containerEntity = level.m_7702_(this.containerPos);
                    if (containerEntity != null) {
                        SwampHopperJarEffect.handleItemInsertion(level, containerEntity, this.containerDir, entity);
                    } else {
                        this.containerPos = null;
                    }
                }
                this.cooldown = 0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void handleItemInsertion(Level level, BlockEntity containerPos, Direction direction, ItemEntity entity) {
        void var3_3;
        void var2_2;
        void var1_1;
        SwampHopperJarEffectImpl.handleItemInsertion(level, (BlockEntity)var1_1, (Direction)var2_2, (ItemEntity)var3_3);
    }

    public static ItemEntity findNearestItem(Level level, BlockPos jarPos) {
        List entities = level.m_45976_(ItemEntity.class, new AABB(jarPos).m_82400_(3.0));
        return entities.size() > 0 ? (ItemEntity)entities.get(0) : null;
    }

    public static Direction findNearestContainer(Level level, BlockPos jarPos) {
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = jarPos.m_142300_(direction);
            BlockEntity blockEntity = level.m_7702_(offsetPos);
            if (blockEntity == null || !SwampHopperJarEffect.isContainer(blockEntity, direction.m_122424_())) continue;
            return direction;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isContainer(BlockEntity blockEntity, Direction direction) {
        void var1_1;
        return SwampHopperJarEffectImpl.isContainer(blockEntity, (Direction)var1_1);
    }

    @Override
    public ParticleOptions getParticleType() {
        return null;
    }
}

