/*
 * Decompiled with CFR 0.152.
 */
package com.toadstoolstudios.lilwings.block.jareffects;

import com.toadstoolstudios.lilwings.block.ButterflyJarBlockEntity;
import com.toadstoolstudios.lilwings.block.jareffects.JarEffect;
import com.toadstoolstudios.lilwings.registry.LilWingsItems;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PaintedPantherJarEffect
implements JarEffect {
    private static final int MAX_TIME = 100;
    private static final int MAX_GROW_TIME = 160;
    private int growTime;
    private BlockPos pos;
    private int checkCooldown;
    private int lastParticle;

    @Override
    public void tickEffect(Level level, ButterflyJarBlockEntity blockEntity) {
        if (level.m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.pos == null) {
            ++this.checkCooldown;
            if (this.checkCooldown >= 100) {
                this.pos = this.findNearestCocoa(level, blockEntity.m_58899_());
                this.checkCooldown = 0;
            }
        } else {
            BlockState state;
            ++this.growTime;
            ++this.lastParticle;
            if (this.lastParticle >= 4) {
                this.spawnParticle(serverLevel, this.pos, 0.5, 0.75, 0.5);
                PaintedPantherJarEffect.addGrowthParticles(serverLevel, this.pos, 0);
                this.lastParticle = 0;
            }
            if ((state = level.m_8055_(this.pos)).m_60713_(Blocks.f_50262_) && (Integer)state.m_61143_((Property)CocoaBlock.f_51736_) >= 2) {
                if (this.growTime >= 160) {
                    if (level.m_7731_(this.pos, Blocks.f_50016_.m_49966_(), 3)) {
                        ItemEntity item = new ItemEntity(level, (double)((float)this.pos.m_123341_() + 0.5f), (double)((float)this.pos.m_123342_() + 0.5f), (double)((float)this.pos.m_123343_() + 0.5f), new ItemStack((ItemLike)LilWingsItems.CRIMSON_COCOA_BEANS.get(), Math.max(1, random.nextInt(2))));
                        serverLevel.m_7967_((Entity)item);
                    }
                    this.growTime = 0;
                    this.pos = null;
                }
            } else {
                this.pos = null;
                this.growTime = 0;
            }
        }
    }

    public BlockPos findNearestCocoa(Level level, BlockPos jarPos) {
        for (BlockPos pos : area) {
            BlockPos relativePos = jarPos.m_141952_((Vec3i)pos);
            BlockState state = level.m_8055_(relativePos);
            if (state.m_60795_() || !state.m_60713_(Blocks.f_50262_) || (Integer)state.m_61143_((Property)CocoaBlock.f_51736_) < 2) continue;
            return relativePos;
        }
        return null;
    }

    public static void addGrowthParticles(ServerLevel pLevel, BlockPos pPos, int pData) {
        BlockState blockstate;
        if (pData == 0) {
            pData = 2;
        }
        if (!(blockstate = pLevel.m_8055_(pPos)).m_60795_()) {
            double d0 = 0.5;
            double d1 = blockstate.m_60808_((BlockGetter)pLevel, pPos).m_83297_(Direction.Axis.Y);
            Random random = pLevel.m_5822_();
            pLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            for (int i = 0; i < pData; ++i) {
                double d8;
                double d7;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextGaussian() * 0.02;
                double d4 = random.nextGaussian() * 0.02;
                double d5 = 0.5 - d0;
                double d6 = (double)pPos.m_123341_() + d5 + random.nextDouble() * d0 * 2.0;
                if (pLevel.m_8055_(new BlockPos(d6, d7 = (double)pPos.m_123342_() + random.nextDouble() * d1, d8 = (double)pPos.m_123343_() + d5 + random.nextDouble() * d0 * 2.0).m_7495_()).m_60795_()) continue;
                pLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, d6, d7, d8, 1, d2, d3, d4, 1.0);
            }
        }
    }

    @Override
    public ParticleOptions getParticleType() {
        return ParticleTypes.f_123749_;
    }
}

